/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.blockmanagement;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hdfs.protocol.Block;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockInfo;
import org.apache.hadoop.hdfs.server.blockmanagement.BlockManager;
import org.apache.hadoop.hdfs.server.blockmanagement.DatanodeDescriptor;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.util.Daemon;
import org.apache.hadoop.util.Time;

class PendingReconstructionBlocks {
    private static final Logger LOG = BlockManager.LOG;
    private final Map<BlockInfo, PendingBlockInfo> pendingReconstructions;
    private final ArrayList<BlockInfo> timedOutItems;
    Daemon timerThread = null;
    private volatile boolean fsRunning = true;
    private long timedOutCount = 0L;
    private long timeout = 300000L;
    private static final long DEFAULT_RECHECK_INTERVAL = 300000L;

    PendingReconstructionBlocks(long timeoutPeriod) {
        if (timeoutPeriod > 0L) {
            this.timeout = timeoutPeriod;
        }
        this.pendingReconstructions = new HashMap<BlockInfo, PendingBlockInfo>();
        this.timedOutItems = new ArrayList();
    }

    void start() {
        this.timerThread = new Daemon(new PendingReconstructionMonitor());
        this.timerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void increment(BlockInfo block, DatanodeDescriptor ... targets) {
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReconstructions.get(block);
            if (found == null) {
                this.pendingReconstructions.put(block, new PendingBlockInfo(targets));
            } else {
                found.incrementReplicas(targets);
                found.setTimeStamp();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean decrement(BlockInfo block, DatanodeDescriptor dn) {
        boolean removed = false;
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReconstructions.get(block);
            if (found != null) {
                LOG.debug("Removing pending reconstruction for {}", (Object)block);
                found.decrementReplicas(dn);
                if (found.getNumReplicas() <= 0) {
                    this.pendingReconstructions.remove(block);
                    removed = true;
                }
            }
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void remove(BlockInfo block) {
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            this.pendingReconstructions.remove(block);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            this.pendingReconstructions.clear();
            this.timedOutItems.clear();
            this.timedOutCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int size() {
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            return this.pendingReconstructions.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumReplicas(BlockInfo block) {
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            PendingBlockInfo found = this.pendingReconstructions.get(block);
            if (found != null) {
                return found.getNumReplicas();
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getNumTimedOuts() {
        ArrayList<BlockInfo> arrayList = this.timedOutItems;
        synchronized (arrayList) {
            return this.timedOutCount + (long)this.timedOutItems.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BlockInfo[] getTimedOutBlocks() {
        ArrayList<BlockInfo> arrayList = this.timedOutItems;
        synchronized (arrayList) {
            if (this.timedOutItems.size() <= 0) {
                return null;
            }
            int size = this.timedOutItems.size();
            BlockInfo[] blockList = this.timedOutItems.toArray(new BlockInfo[size]);
            this.timedOutItems.clear();
            this.timedOutCount += (long)size;
            return blockList;
        }
    }

    void stop() {
        this.fsRunning = false;
        if (this.timerThread == null) {
            return;
        }
        this.timerThread.interrupt();
        try {
            this.timerThread.join(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void metaSave(PrintWriter out) {
        Map<BlockInfo, PendingBlockInfo> map = this.pendingReconstructions;
        synchronized (map) {
            out.println("Metasave: Blocks being reconstructed: " + this.pendingReconstructions.size());
            for (Map.Entry<BlockInfo, PendingBlockInfo> entry : this.pendingReconstructions.entrySet()) {
                PendingBlockInfo pendingBlock = entry.getValue();
                Block block = entry.getKey();
                out.println(block + " StartTime: " + new java.sql.Time(pendingBlock.timeStamp) + " NumReconstructInProgress: " + pendingBlock.getNumReplicas());
            }
        }
    }

    class PendingReconstructionMonitor
    implements Runnable {
        PendingReconstructionMonitor() {
        }

        @Override
        public void run() {
            while (PendingReconstructionBlocks.this.fsRunning) {
                long period = Math.min(300000L, PendingReconstructionBlocks.this.timeout);
                try {
                    this.pendingReconstructionCheck();
                    Thread.sleep(period);
                }
                catch (InterruptedException ie) {
                    LOG.debug("PendingReconstructionMonitor thread is interrupted.", ie);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pendingReconstructionCheck() {
            Map map = PendingReconstructionBlocks.this.pendingReconstructions;
            synchronized (map) {
                Iterator iter = PendingReconstructionBlocks.this.pendingReconstructions.entrySet().iterator();
                long now = Time.monotonicNow();
                LOG.debug("PendingReconstructionMonitor checking Q");
                while (iter.hasNext()) {
                    Map.Entry entry = iter.next();
                    PendingBlockInfo pendingBlock = (PendingBlockInfo)entry.getValue();
                    if (now <= pendingBlock.getTimeStamp() + PendingReconstructionBlocks.this.timeout) continue;
                    BlockInfo block = (BlockInfo)entry.getKey();
                    ArrayList arrayList = PendingReconstructionBlocks.this.timedOutItems;
                    synchronized (arrayList) {
                        PendingReconstructionBlocks.this.timedOutItems.add(block);
                    }
                    LOG.warn("PendingReconstructionMonitor timed out " + block);
                    NameNode.getNameNodeMetrics().incTimeoutReReplications();
                    iter.remove();
                }
            }
        }
    }

    static class PendingBlockInfo {
        private long timeStamp = Time.monotonicNow();
        private final List<DatanodeDescriptor> targets;

        PendingBlockInfo(DatanodeDescriptor[] targets) {
            this.targets = targets == null ? new ArrayList<DatanodeDescriptor>() : new ArrayList<DatanodeDescriptor>(Arrays.asList(targets));
        }

        long getTimeStamp() {
            return this.timeStamp;
        }

        void setTimeStamp() {
            this.timeStamp = Time.monotonicNow();
        }

        void incrementReplicas(DatanodeDescriptor ... newTargets) {
            if (newTargets != null) {
                for (DatanodeDescriptor newTarget : newTargets) {
                    if (this.targets.contains(newTarget)) continue;
                    this.targets.add(newTarget);
                }
            }
        }

        void decrementReplicas(DatanodeDescriptor dn) {
            this.targets.remove(dn);
        }

        int getNumReplicas() {
            return this.targets.size();
        }
    }
}

