/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage.organization;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.stats.CounterStat;
import io.trino.plugin.raptor.legacy.storage.StorageManagerConfig;
import io.trino.plugin.raptor.legacy.storage.organization.JobFactory;
import io.trino.plugin.raptor.legacy.storage.organization.OrganizationSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

public class ShardOrganizer {
    private static final Logger log = Logger.get(ShardOrganizer.class);
    private final ExecutorService executorService;
    private final ThreadPoolExecutorMBean executorMBean;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Set<UUID> shardsInProgress = Sets.newConcurrentHashSet();
    private final JobFactory jobFactory;
    private final CounterStat successCount = new CounterStat();
    private final CounterStat failureCount = new CounterStat();

    @Inject
    public ShardOrganizer(JobFactory jobFactory, StorageManagerConfig config) {
        this(jobFactory, config.getOrganizationThreads());
    }

    public ShardOrganizer(JobFactory jobFactory, int threads) {
        Preconditions.checkArgument((threads > 0 ? 1 : 0) != 0, (Object)"threads must be > 0");
        this.jobFactory = Objects.requireNonNull(jobFactory, "jobFactory is null");
        this.executorService = Executors.newFixedThreadPool(threads, Threads.daemonThreadsNamed((String)"shard-organizer-%s"));
        this.executorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.executorService);
    }

    @PreDestroy
    public void shutdown() {
        if (!this.shutdown.getAndSet(true)) {
            this.executorService.shutdownNow();
        }
    }

    public CompletableFuture<?> enqueue(OrganizationSet organizationSet) {
        this.shardsInProgress.addAll(organizationSet.getShards());
        return CompletableFuture.runAsync(this.jobFactory.create(organizationSet), this.executorService).whenComplete((none, throwable) -> {
            this.shardsInProgress.removeAll(organizationSet.getShards());
            if (throwable == null) {
                this.successCount.update(1L);
            } else {
                log.warn(throwable, "Error running organization job");
                this.failureCount.update(1L);
            }
        });
    }

    public boolean inProgress(UUID shardUuid) {
        return this.shardsInProgress.contains(shardUuid);
    }

    @Managed
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.executorMBean;
    }

    @Managed
    public int getShardsInProgress() {
        return this.shardsInProgress.size();
    }

    @Managed
    @Nested
    public CounterStat getSuccessCount() {
        return this.successCount;
    }

    @Managed
    @Nested
    public CounterStat getFailureCount() {
        return this.failureCount;
    }
}

