/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.systemtables;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slice;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.metadata.DatabaseShardManager;
import io.trino.plugin.raptor.legacy.metadata.MetadataDao;
import io.trino.plugin.raptor.legacy.systemtables.PreparedStatementBuilder;
import io.trino.plugin.raptor.legacy.systemtables.ResultSetValues;
import io.trino.plugin.raptor.legacy.util.DatabaseUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.RecordCursor;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;

public class ShardMetadataRecordCursor
implements RecordCursor {
    private static final String SHARD_UUID = "shard_uuid";
    private static final String XXHASH64 = "xxhash64";
    private static final String SCHEMA_NAME = "table_schema";
    private static final String TABLE_NAME = "table_name";
    private static final String MIN_TIMESTAMP = "min_timestamp";
    private static final String MAX_TIMESTAMP = "max_timestamp";
    private static final String MIN_DATE = "min_date";
    private static final String MAX_DATE = "max_date";
    public static final SchemaTableName SHARD_METADATA_TABLE_NAME = new SchemaTableName("system", "shards");
    public static final ConnectorTableMetadata SHARD_METADATA = new ConnectorTableMetadata(SHARD_METADATA_TABLE_NAME, (List)ImmutableList.of((Object)new ColumnMetadata("table_schema", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("table_name", (Type)VarcharType.createUnboundedVarcharType()), (Object)new ColumnMetadata("shard_uuid", RaptorColumnHandle.SHARD_UUID_COLUMN_TYPE), (Object)new ColumnMetadata("bucket_number", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("uncompressed_size", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("compressed_size", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("row_count", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("xxhash64", (Type)VarcharType.createVarcharType((int)16)), (Object)new ColumnMetadata("min_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS), (Object)new ColumnMetadata("max_timestamp", (Type)TimestampType.TIMESTAMP_MILLIS), (Object)new ColumnMetadata("min_date", (Type)DateType.DATE), (Object)new ColumnMetadata("max_date", (Type)DateType.DATE), (Object[])new ColumnMetadata[0]));
    private static final List<ColumnMetadata> COLUMNS = SHARD_METADATA.getColumns();
    private static final List<Type> TYPES = COLUMNS.stream().map(ColumnMetadata::getType).collect(Collectors.toList());
    private final Jdbi dbi;
    private final MetadataDao metadataDao;
    private final Iterator<Long> tableIds;
    private final List<String> columnNames;
    private final TupleDomain<Integer> tupleDomain;
    private ResultSet resultSet;
    private Connection connection;
    private PreparedStatement statement;
    private final ResultSetValues resultSetValues;
    private boolean closed;
    private long completedBytes;

    public ShardMetadataRecordCursor(Jdbi dbi, TupleDomain<Integer> tupleDomain) {
        this.dbi = Objects.requireNonNull(dbi, "dbi is null");
        this.metadataDao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        this.tupleDomain = Objects.requireNonNull(tupleDomain, "tupleDomain is null");
        this.tableIds = ShardMetadataRecordCursor.getTableIds(dbi, tupleDomain);
        this.columnNames = ShardMetadataRecordCursor.createQualifiedColumnNames();
        this.resultSetValues = new ResultSetValues(TYPES);
        this.resultSet = this.getNextResultSet();
    }

    private static String constructSqlTemplate(List<String> columnNames, long tableId) {
        return String.format("SELECT %s\nFROM %s x\nJOIN shards ON (x.shard_id = shards.shard_id AND shards.table_id = %s)\nJOIN tables ON (tables.table_id = %s)\n", Joiner.on((String)", ").join(columnNames), DatabaseShardManager.shardIndexTable(tableId), tableId, tableId);
    }

    private static List<String> createQualifiedColumnNames() {
        return ImmutableList.builder().add((Object)"tables.schema_name").add((Object)"tables.table_name").add((Object)("shards." + COLUMNS.get(2).getName())).add((Object)("shards." + COLUMNS.get(3).getName())).add((Object)("shards." + COLUMNS.get(4).getName())).add((Object)("shards." + COLUMNS.get(5).getName())).add((Object)("shards." + COLUMNS.get(6).getName())).add((Object)("shards." + COLUMNS.get(7).getName())).add((Object)MIN_TIMESTAMP).add((Object)MAX_TIMESTAMP).add((Object)MIN_DATE).add((Object)MAX_DATE).build();
    }

    public long getCompletedBytes() {
        return this.completedBytes;
    }

    public long getReadTimeNanos() {
        return 0L;
    }

    public Type getType(int field) {
        Preconditions.checkPositionIndex((int)field, (int)TYPES.size());
        return TYPES.get(field);
    }

    public boolean advanceNextPosition() {
        if (this.resultSet == null) {
            this.close();
        }
        if (this.closed) {
            return false;
        }
        try {
            while (!this.resultSet.next()) {
                this.resultSet = this.getNextResultSet();
                if (this.resultSet != null) continue;
                this.close();
                return false;
            }
            this.completedBytes += (long)this.resultSetValues.extractValues(this.resultSet, (Set<Integer>)ImmutableSet.of((Object)ShardMetadataRecordCursor.getColumnIndex(SHARD_METADATA, SHARD_UUID)), (Set<Integer>)ImmutableSet.of((Object)ShardMetadataRecordCursor.getColumnIndex(SHARD_METADATA, XXHASH64)));
            return true;
        }
        catch (SQLException | JdbiException e) {
            throw DatabaseUtil.metadataError(e);
        }
    }

    public boolean getBoolean(int field) {
        this.checkFieldType(field, Boolean.TYPE);
        return this.resultSetValues.getBoolean(field);
    }

    public long getLong(int field) {
        this.checkFieldType(field, Long.TYPE);
        return this.resultSetValues.getLong(field);
    }

    public double getDouble(int field) {
        this.checkFieldType(field, Double.TYPE);
        return this.resultSetValues.getDouble(field);
    }

    public Slice getSlice(int field) {
        this.checkFieldType(field, Slice.class);
        return this.resultSetValues.getSlice(field);
    }

    public Object getObject(int field) {
        throw new UnsupportedOperationException();
    }

    public boolean isNull(int field) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Preconditions.checkPositionIndex((int)field, (int)TYPES.size());
        return this.resultSetValues.isNull(field);
    }

    public void close() {
        this.closed = true;
        this.closeCurrentResultSet();
    }

    private void closeCurrentResultSet() {
        try (Connection connection = this.connection;
             PreparedStatement statement = this.statement;){
            ResultSet resultSet = this.resultSet;
            if (resultSet != null) {
                resultSet.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private ResultSet getNextResultSet() {
        List<String> columnNames;
        this.closeCurrentResultSet();
        if (!this.tableIds.hasNext()) {
            return null;
        }
        Long tableId = this.tableIds.next();
        Long columnId = this.metadataDao.getTemporalColumnId(tableId);
        if (columnId == null) {
            columnNames = this.getMappedColumnNames("null", "null", "null", "null");
        } else {
            Type temporalType = this.metadataDao.getTableColumn(tableId, columnId).getDataType();
            if (temporalType.equals(DateType.DATE)) {
                columnNames = this.getMappedColumnNames("null", "null", DatabaseShardManager.minColumn(columnId), DatabaseShardManager.maxColumn(columnId));
            } else if (temporalType.equals(TimestampType.TIMESTAMP_MILLIS)) {
                columnNames = this.getMappedColumnNames(DatabaseShardManager.minColumn(columnId), DatabaseShardManager.maxColumn(columnId), "null", "null");
            } else {
                throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_CORRUPT_METADATA, "Temporal column should be of type date or timestamp, not " + temporalType.getDisplayName());
            }
        }
        try {
            this.connection = this.dbi.open().getConnection();
            this.statement = PreparedStatementBuilder.create(this.connection, ShardMetadataRecordCursor.constructSqlTemplate(columnNames, tableId), columnNames, TYPES, (Set<Integer>)ImmutableSet.of((Object)ShardMetadataRecordCursor.getColumnIndex(SHARD_METADATA, SHARD_UUID)), this.tupleDomain);
            return this.statement.executeQuery();
        }
        catch (SQLException | JdbiException e) {
            this.close();
            throw DatabaseUtil.metadataError(e);
        }
    }

    private List<String> getMappedColumnNames(String minTimestampColumn, String maxTimestampColumn, String minDateColumn, String maxDateColumn) {
        ImmutableList.Builder builder = ImmutableList.builder();
        Iterator<String> iterator = this.columnNames.iterator();
        block12: while (iterator.hasNext()) {
            String column;
            switch (column = iterator.next()) {
                case "min_timestamp": {
                    builder.add((Object)minTimestampColumn);
                    continue block12;
                }
                case "max_timestamp": {
                    builder.add((Object)maxTimestampColumn);
                    continue block12;
                }
                case "min_date": {
                    builder.add((Object)minDateColumn);
                    continue block12;
                }
                case "max_date": {
                    builder.add((Object)maxDateColumn);
                    continue block12;
                }
            }
            builder.add((Object)column);
        }
        return builder.build();
    }

    @VisibleForTesting
    static Iterator<Long> getTableIds(Jdbi dbi, TupleDomain<Integer> tupleDomain) {
        Map domains = (Map)tupleDomain.getDomains().get();
        Domain schemaNameDomain = (Domain)domains.get(ShardMetadataRecordCursor.getColumnIndex(SHARD_METADATA, SCHEMA_NAME));
        Domain tableNameDomain = (Domain)domains.get(ShardMetadataRecordCursor.getColumnIndex(SHARD_METADATA, TABLE_NAME));
        ArrayList<String> values = new ArrayList<String>();
        StringBuilder sql = new StringBuilder("SELECT table_id FROM tables ");
        if (schemaNameDomain != null || tableNameDomain != null) {
            sql.append("WHERE ");
            ArrayList<String> predicates = new ArrayList<String>();
            if (tableNameDomain != null && tableNameDomain.isSingleValue()) {
                predicates.add("table_name = ?");
                values.add(ShardMetadataRecordCursor.getStringValue(tableNameDomain.getSingleValue()));
            }
            if (schemaNameDomain != null && schemaNameDomain.isSingleValue()) {
                predicates.add("schema_name = ?");
                values.add(ShardMetadataRecordCursor.getStringValue(schemaNameDomain.getSingleValue()));
            }
            sql.append(Joiner.on((String)" AND ").join(predicates));
        }
        ImmutableList.Builder tableIds = ImmutableList.builder();
        try (Connection connection = dbi.open().getConnection();
             PreparedStatement statement = connection.prepareStatement(sql.toString());){
            for (int i = 0; i < values.size(); ++i) {
                statement.setString(i + 1, (String)values.get(i));
            }
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    tableIds.add((Object)resultSet.getLong("table_id"));
                }
            }
        }
        catch (SQLException | JdbiException e) {
            throw DatabaseUtil.metadataError(e);
        }
        return tableIds.build().iterator();
    }

    private static int getColumnIndex(ConnectorTableMetadata tableMetadata, String columnName) {
        List columns = tableMetadata.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((ColumnMetadata)columns.get(i)).getName().equals(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column '%s' not found", columnName));
    }

    private void checkFieldType(int field, Class<?> clazz) {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"cursor is closed");
        Type type = this.getType(field);
        Preconditions.checkArgument((type.getJavaType() == clazz ? 1 : 0) != 0, (String)"Type %s cannot be read as %s", (Object)type, (Object)clazz.getSimpleName());
    }

    private static String getStringValue(Object value) {
        return ((Slice)value).toStringUtf8();
    }
}

