/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.util;

import com.google.common.base.Throwables;
import com.google.common.reflect.Reflection;
import com.mysql.cj.jdbc.JdbcStatement;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.lang.reflect.InvocationTargetException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.HandleCallback;
import org.jdbi.v3.core.Jdbi;
import org.jdbi.v3.core.JdbiException;

public final class DatabaseUtil {
    private DatabaseUtil() {
    }

    public static <T> T onDemandDao(Jdbi dbi, Class<T> daoType) {
        Objects.requireNonNull(dbi, "dbi is null");
        return (T)Reflection.newProxy(daoType, (proxy, method, args) -> {
            Object object;
            block9: {
                Handle handle = dbi.open();
                try {
                    Object dao = handle.attach(daoType);
                    object = method.invoke(dao, args);
                    if (handle == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (handle != null) {
                            try {
                                handle.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (JdbiException e) {
                        throw DatabaseUtil.metadataError(e);
                    }
                    catch (InvocationTargetException e) {
                        throw DatabaseUtil.metadataError(e.getCause());
                    }
                }
                handle.close();
            }
            return object;
        });
    }

    public static <T> T runTransaction(Jdbi dbi, HandleCallback<T, RuntimeException> callback) {
        try {
            return (T)dbi.inTransaction(callback);
        }
        catch (JdbiException e) {
            if (e.getCause() != null) {
                Throwables.throwIfInstanceOf((Throwable)e.getCause(), TrinoException.class);
            }
            throw DatabaseUtil.metadataError(e);
        }
    }

    public static <T> void daoTransaction(Jdbi dbi, Class<T> daoType, Consumer<T> callback) {
        DatabaseUtil.runTransaction(dbi, handle -> {
            callback.accept(handle.attach(daoType));
            return null;
        });
    }

    public static TrinoException metadataError(Throwable cause, String message) {
        return new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_METADATA_ERROR, message, cause);
    }

    public static TrinoException metadataError(Throwable cause) {
        return DatabaseUtil.metadataError(cause, "Failed to perform metadata operation");
    }

    public static void runIgnoringConstraintViolation(Runnable task) {
        block2: {
            try {
                task.run();
            }
            catch (RuntimeException e) {
                if (DatabaseUtil.sqlCodeStartsWith(e, "23")) break block2;
                throw e;
            }
        }
    }

    public static void enableStreamingResults(Statement statement) throws SQLException {
        if (statement.isWrapperFor(JdbcStatement.class)) {
            statement.unwrap(JdbcStatement.class).enableStreamingResults();
        }
    }

    public static OptionalInt getOptionalInt(ResultSet rs, String name) throws SQLException {
        int value = rs.getInt(name);
        return rs.wasNull() ? OptionalInt.empty() : OptionalInt.of(value);
    }

    public static OptionalLong getOptionalLong(ResultSet rs, String name) throws SQLException {
        long value = rs.getLong(name);
        return rs.wasNull() ? OptionalLong.empty() : OptionalLong.of(value);
    }

    public static Long getBoxedLong(ResultSet rs, String name) throws SQLException {
        long value = rs.getLong(name);
        return rs.wasNull() ? null : Long.valueOf(value);
    }

    public static void bindOptionalInt(PreparedStatement statement, int index, OptionalInt value) throws SQLException {
        if (value.isPresent()) {
            statement.setInt(index, value.getAsInt());
        } else {
            statement.setNull(index, 4);
        }
    }

    public static boolean isSyntaxOrAccessError(Exception e) {
        return DatabaseUtil.sqlCodeStartsWith(e, "42");
    }

    public static boolean isTransactionCacheFullError(Exception e) {
        return DatabaseUtil.mySqlErrorCodeMatches(e, 1197);
    }

    private static boolean mySqlErrorCodeMatches(Exception e, int errorCode) {
        return Throwables.getCausalChain((Throwable)e).stream().filter(SQLException.class::isInstance).map(SQLException.class::cast).filter(t -> t.getErrorCode() == errorCode).map(Throwable::getStackTrace).anyMatch(DatabaseUtil.isMySQLException());
    }

    private static Predicate<StackTraceElement[]> isMySQLException() {
        return s -> Arrays.stream(s).map(StackTraceElement::getClassName).anyMatch(t -> t.startsWith("com.mysql.jdbc."));
    }

    private static boolean sqlCodeStartsWith(Exception e, String code) {
        for (Throwable throwable : Throwables.getCausalChain((Throwable)e)) {
            String state;
            if (!(throwable instanceof SQLException) || (state = ((SQLException)throwable).getSQLState()) == null || !state.startsWith(code)) continue;
            return true;
        }
        return false;
    }
}

