/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import io.trino.hive.$internal.org.slf4j.Logger;
import io.trino.hive.$internal.org.slf4j.LoggerFactory;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.counters.LlapIOCounters;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.tez.common.counters.CounterGroup;
import org.apache.tez.common.counters.TezCounter;
import org.apache.tez.common.counters.TezCounters;

public class PostExecOrcRowGroupCountPrinter
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger(PostExecOrcRowGroupCountPrinter.class.getName());

    @Override
    public void run(HookContext hookContext) throws Exception {
        assert (hookContext.getHookType() == HookContext.HookType.POST_EXEC_HOOK);
        HiveConf conf = hookContext.getConf();
        if (!"tez".equals(HiveConf.getVar(conf, HiveConf.ConfVars.HIVE_EXECUTION_ENGINE))) {
            return;
        }
        LOG.info("Executing post execution hook to print ORC row groups read counter..");
        SessionState ss = SessionState.get();
        SessionState.LogHelper console = ss.getConsole();
        QueryPlan plan = hookContext.getQueryPlan();
        if (plan == null) {
            return;
        }
        List<TezTask> rootTasks = Utilities.getTezTasks(plan.getRootTasks());
        for (TezTask tezTask : rootTasks) {
            LOG.info("Printing ORC row group counter for tez task: " + tezTask.getName());
            TezCounters counters = tezTask.getTezCounters();
            if (counters == null) continue;
            for (CounterGroup group : counters) {
                if (!group.getName().equals(LlapIOCounters.class.getName())) continue;
                console.printInfo(tezTask.getId() + " LLAP IO COUNTERS:", false);
                for (TezCounter counter : group) {
                    if (!counter.getDisplayName().equals(LlapIOCounters.SELECTED_ROWGROUPS.name())) continue;
                    console.printInfo("   " + counter.getDisplayName() + ": " + counter.getValue(), false);
                }
            }
        }
    }
}

