/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import io.trino.hive.$internal.com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.parse.BaseSemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.ReplicationSpec;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.CreateTableDesc;
import org.apache.hadoop.hive.ql.plan.CreateViewDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;

public class ImportTableDesc {
    private String dbName = null;
    private Table table = null;
    private CreateTableDesc createTblDesc = null;
    private CreateViewDesc createViewDesc = null;

    public ImportTableDesc(String dbName, Table table) throws Exception {
        this.dbName = dbName;
        this.table = table;
        switch (this.getDescType()) {
            case TABLE: {
                this.createTblDesc = new CreateTableDesc(dbName, table.getTableName(), false, false, table.getSd().getCols(), table.getPartitionKeys(), table.getSd().getBucketCols(), table.getSd().getSortCols(), table.getSd().getNumBuckets(), null, null, null, null, null, null, table.getSd().getInputFormat(), table.getSd().getOutputFormat(), null, table.getSd().getSerdeInfo().getSerializationLib(), null, table.getSd().getSerdeInfo().getParameters(), table.getParameters(), false, null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColNames(), null == table.getSd().getSkewedInfo() ? null : table.getSd().getSkewedInfo().getSkewedColValues(), null, null, null, null, null, null);
                this.createTblDesc.setStoredAsSubDirectories(table.getSd().isStoredAsSubDirectories());
                break;
            }
            case VIEW: {
                String[] qualViewName = new String[]{dbName, table.getTableName()};
                String dbDotView = BaseSemanticAnalyzer.getDotName(qualViewName);
                if (table.isMaterializedView()) {
                    this.createViewDesc = new CreateViewDesc(dbDotView, table.getAllCols(), null, table.getParameters(), table.getPartColNames(), false, false, false, false, table.getSd().getInputFormat(), table.getSd().getOutputFormat(), null, table.getSd().getSerdeInfo().getSerializationLib(), null, table.getSd().getSerdeInfo().getParameters());
                    this.createViewDesc.setTablesUsed(table.getCreationMetadata() != null ? table.getCreationMetadata().getTablesUsed() : ImmutableSet.of());
                } else {
                    this.createViewDesc = new CreateViewDesc(dbDotView, table.getAllCols(), null, table.getParameters(), table.getPartColNames(), false, false, false, table.getSd().getInputFormat(), table.getSd().getOutputFormat(), table.getSd().getSerdeInfo().getSerializationLib());
                }
                this.setViewAsReferenceText(dbName, table);
                this.createViewDesc.setPartCols(table.getPartCols());
                break;
            }
            default: {
                throw new HiveException("Invalid table type");
            }
        }
    }

    public TYPE getDescType() {
        if (this.table.isView() || this.table.isMaterializedView()) {
            return TYPE.VIEW;
        }
        return TYPE.TABLE;
    }

    public void setViewAsReferenceText(String dbName, Table table) {
        String originalText = table.getViewOriginalText();
        String expandedText = table.getViewExpandedText();
        if (!dbName.equals(table.getDbName())) {
            // empty if block
        }
        this.createViewDesc.setViewOriginalText(originalText);
        this.createViewDesc.setViewExpandedText(expandedText);
    }

    public void setReplicationSpec(ReplicationSpec replSpec) {
        switch (this.getDescType()) {
            case TABLE: {
                this.createTblDesc.setReplicationSpec(replSpec);
                break;
            }
            case VIEW: {
                this.createViewDesc.setReplicationSpec(replSpec);
            }
        }
    }

    public void setExternal(boolean isExternal) {
        if (TYPE.TABLE.equals((Object)this.getDescType())) {
            this.createTblDesc.setExternal(isExternal);
        }
    }

    public boolean isExternal() {
        if (TYPE.TABLE.equals((Object)this.getDescType())) {
            return this.createTblDesc.isExternal();
        }
        return false;
    }

    public void setLocation(String location) {
        switch (this.getDescType()) {
            case TABLE: {
                this.createTblDesc.setLocation(location);
                break;
            }
            case VIEW: {
                this.createViewDesc.setLocation(location);
            }
        }
    }

    public String getLocation() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getLocation();
            }
            case VIEW: {
                return this.createViewDesc.getLocation();
            }
        }
        return null;
    }

    public void setTableName(String tableName) throws SemanticException {
        switch (this.getDescType()) {
            case TABLE: {
                this.createTblDesc.setTableName(tableName);
                break;
            }
            case VIEW: {
                String[] qualViewName = new String[]{this.dbName, tableName};
                String dbDotView = BaseSemanticAnalyzer.getDotName(qualViewName);
                this.createViewDesc.setViewName(dbDotView);
            }
        }
    }

    public String getTableName() throws SemanticException {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getTableName();
            }
            case VIEW: {
                String dbDotView = this.createViewDesc.getViewName();
                String[] names = Utilities.getDbTableName(dbDotView);
                return names[1];
            }
        }
        return null;
    }

    public List<FieldSchema> getPartCols() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getPartCols();
            }
            case VIEW: {
                return this.createViewDesc.getPartCols();
            }
        }
        return null;
    }

    public List<FieldSchema> getCols() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getCols();
            }
            case VIEW: {
                return this.createViewDesc.getSchema();
            }
        }
        return null;
    }

    public Map<String, String> getTblProps() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getTblProps();
            }
            case VIEW: {
                return this.createViewDesc.getTblProps();
            }
        }
        return null;
    }

    public String getInputFormat() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getInputFormat();
            }
            case VIEW: {
                return this.createViewDesc.getInputFormat();
            }
        }
        return null;
    }

    public String getOutputFormat() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getOutputFormat();
            }
            case VIEW: {
                return this.createViewDesc.getOutputFormat();
            }
        }
        return null;
    }

    public String getSerName() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getSerName();
            }
            case VIEW: {
                return this.createViewDesc.getSerde();
            }
        }
        return null;
    }

    public Map<String, String> getSerdeProps() {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.getSerdeProps();
            }
            case VIEW: {
                return this.createViewDesc.getSerdeProps();
            }
        }
        return null;
    }

    public List<String> getBucketCols() {
        if (TYPE.TABLE.equals((Object)this.getDescType())) {
            return this.createTblDesc.getBucketCols();
        }
        return null;
    }

    public List<Order> getSortCols() {
        if (TYPE.TABLE.equals((Object)this.getDescType())) {
            return this.createTblDesc.getSortCols();
        }
        return null;
    }

    public void setReplaceMode(boolean replaceMode) {
        switch (this.getDescType()) {
            case TABLE: {
                this.createTblDesc.setReplaceMode(replaceMode);
                break;
            }
            case VIEW: {
                this.createViewDesc.setReplace(replaceMode);
            }
        }
    }

    public String getDatabaseName() {
        return this.dbName;
    }

    public Task<? extends Serializable> getCreateTableTask(HashSet<ReadEntity> inputs, HashSet<WriteEntity> outputs, HiveConf conf) {
        switch (this.getDescType()) {
            case TABLE: {
                return TaskFactory.get(new DDLWork(inputs, outputs, this.createTblDesc), conf);
            }
            case VIEW: {
                return TaskFactory.get(new DDLWork(inputs, outputs, this.createViewDesc), conf);
            }
        }
        return null;
    }

    public boolean isView() {
        return this.table.isView();
    }

    public boolean isMaterializedView() {
        return this.table.isMaterializedView();
    }

    public TableType tableType() {
        if (this.isView()) {
            return TableType.VIRTUAL_VIEW;
        }
        if (this.isMaterializedView()) {
            return TableType.MATERIALIZED_VIEW;
        }
        return TableType.MANAGED_TABLE;
    }

    public Table toTable(HiveConf conf) throws Exception {
        switch (this.getDescType()) {
            case TABLE: {
                return this.createTblDesc.toTable(conf);
            }
            case VIEW: {
                return this.createViewDesc.toTable(conf);
            }
        }
        return null;
    }

    public static enum TYPE {
        TABLE,
        VIEW;

    }
}

