/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.argument;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.util.Optional;
import java.util.function.Function;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.DelegatingArgumentFactory;
import org.jdbi.v3.core.argument.ToStringBinder;
import org.jdbi.v3.core.config.ConfigRegistry;

class PrimitivesArgumentFactory
extends DelegatingArgumentFactory {
    PrimitivesArgumentFactory() {
        this.register(Boolean.TYPE, 16, PreparedStatement::setBoolean);
        this.register(Byte.TYPE, -6, PreparedStatement::setByte);
        this.register(Character.TYPE, 1, new ToStringBinder(PreparedStatement::setString));
        this.register(Short.TYPE, 5, PreparedStatement::setShort);
        this.register(Integer.TYPE, 4, PreparedStatement::setInt);
        this.register(Long.TYPE, -5, PreparedStatement::setLong);
        this.register(Float.TYPE, 6, PreparedStatement::setFloat);
        this.register(Double.TYPE, 8, PreparedStatement::setDouble);
    }

    @Override
    public Optional<Function<Object, Argument>> prepare(Type type, ConfigRegistry config) {
        return super.prepare(type, config).map(prepared -> value -> (Argument)prepared.apply(this.checkForNull(config, type, value)));
    }

    @Override
    public Optional<Argument> build(Type expectedType, Object value, ConfigRegistry config) {
        return super.build(expectedType, this.checkForNull(config, expectedType, value), config);
    }

    private Object checkForNull(ConfigRegistry cfg, Type type, Object value) {
        if (value == null && !cfg.get(Arguments.class).isBindingNullToPrimitivesPermitted()) {
            throw new IllegalArgumentException(String.format("binding null to a primitive %s is forbidden by configuration, declare a boxed type instead", type));
        }
        return value;
    }
}

