/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.metadata;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.trino.plugin.raptor.legacy.metadata.BucketNode;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;

public class BucketReassigner {
    private final Map<String, Integer> nodeBucketCounts = new HashMap<String, Integer>();
    private final List<String> activeNodes;
    private final List<BucketNode> bucketNodes;
    private boolean initialized;

    public BucketReassigner(Set<String> activeNodes, List<BucketNode> bucketNodes) {
        Preconditions.checkArgument((!activeNodes.isEmpty() ? 1 : 0) != 0, (Object)"activeNodes must not be empty");
        this.activeNodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(activeNodes, "activeNodes is null"));
        this.bucketNodes = Objects.requireNonNull(bucketNodes, "bucketNodes is null");
    }

    public String getNextReassignmentDestination() {
        if (!this.initialized) {
            for (String node2 : this.activeNodes) {
                this.nodeBucketCounts.put(node2, 0);
            }
            for (BucketNode bucketNode : this.bucketNodes) {
                this.nodeBucketCounts.computeIfPresent(bucketNode.getNodeIdentifier(), (node, bucketCount) -> bucketCount + 1);
            }
            this.initialized = true;
        }
        String assignedNode = this.activeNodes.size() > 1 ? this.randomTwoChoices() : this.activeNodes.get(0);
        this.nodeBucketCounts.compute(assignedNode, (node, count) -> count + 1);
        return assignedNode;
    }

    private String randomTwoChoices() {
        int randomPosition = ThreadLocalRandom.current().nextInt(this.activeNodes.size());
        int randomOffset = ThreadLocalRandom.current().nextInt(1, this.activeNodes.size());
        String candidate1 = this.activeNodes.get(randomPosition);
        String candidate2 = this.activeNodes.get((randomPosition + randomOffset) % this.activeNodes.size());
        return this.nodeBucketCounts.get(candidate1) <= this.nodeBucketCounts.get(candidate2) ? candidate1 : candidate2;
    }
}

