/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.systemtables;

import com.google.common.collect.ImmutableList;
import io.trino.spi.Page;
import io.trino.spi.PageBuilder;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.type.Type;
import java.util.List;

class PageListBuilder {
    private final PageBuilder pageBuilder;
    private final ImmutableList.Builder<Page> pages = ImmutableList.builder();
    private int channel;

    public PageListBuilder(List<Type> types) {
        this.pageBuilder = new PageBuilder(types);
    }

    public List<Page> build() {
        if (!this.pageBuilder.isEmpty()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        return this.pages.build();
    }

    public void beginRow() {
        if (this.pageBuilder.isFull()) {
            this.pages.add((Object)this.pageBuilder.build());
            this.pageBuilder.reset();
        }
        this.pageBuilder.declarePosition();
        this.channel = 0;
    }

    public BlockBuilder nextBlockBuilder() {
        int currentChannel = this.channel++;
        return this.pageBuilder.getBlockBuilder(currentChannel);
    }
}

