/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import io.trino.hadoop.$internal.com.google.common.annotations.VisibleForTesting;
import io.trino.hadoop.$internal.org.slf4j.Logger;
import io.trino.hadoop.$internal.org.slf4j.LoggerFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.hadoop.fs.azurebfs.AbfsConfiguration;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AzureBlobFileSystemException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidUriException;
import org.apache.hadoop.fs.azurebfs.oauth2.AccessTokenProvider;
import org.apache.hadoop.fs.azurebfs.services.AbfsHttpHeader;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperationType;
import org.apache.hadoop.fs.azurebfs.services.AbfsUriQueryBuilder;
import org.apache.hadoop.fs.azurebfs.services.ExponentialRetryPolicy;
import org.apache.hadoop.fs.azurebfs.services.SharedKeyCredentials;
import org.apache.hadoop.fs.azurebfs.utils.SSLSocketFactoryEx;

public class AbfsClient {
    public static final Logger LOG = LoggerFactory.getLogger(AbfsClient.class);
    private final URL baseUrl;
    private final SharedKeyCredentials sharedKeyCredentials;
    private final String xMsVersion = "2018-06-17";
    private final ExponentialRetryPolicy retryPolicy;
    private final String filesystem;
    private final AbfsConfiguration abfsConfiguration;
    private final String userAgent;
    private final AccessTokenProvider tokenProvider;

    public AbfsClient(URL baseUrl, SharedKeyCredentials sharedKeyCredentials, AbfsConfiguration abfsConfiguration, ExponentialRetryPolicy exponentialRetryPolicy, AccessTokenProvider tokenProvider) {
        this.baseUrl = baseUrl;
        this.sharedKeyCredentials = sharedKeyCredentials;
        String baseUrlString = baseUrl.toString();
        this.filesystem = baseUrlString.substring(baseUrlString.lastIndexOf("/") + 1);
        this.abfsConfiguration = abfsConfiguration;
        this.retryPolicy = exponentialRetryPolicy;
        String sslProviderName = null;
        if (this.baseUrl.toString().startsWith("https")) {
            try {
                SSLSocketFactoryEx.initializeDefaultFactory(this.abfsConfiguration.getPreferredSSLFactoryOption());
                sslProviderName = SSLSocketFactoryEx.getDefaultFactory().getProviderName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.userAgent = this.initializeUserAgent(abfsConfiguration, sslProviderName);
        this.tokenProvider = tokenProvider;
    }

    public String getFileSystem() {
        return this.filesystem;
    }

    ExponentialRetryPolicy getRetryPolicy() {
        return this.retryPolicy;
    }

    SharedKeyCredentials getSharedKeyCredentials() {
        return this.sharedKeyCredentials;
    }

    List<AbfsHttpHeader> createDefaultHeaders() {
        ArrayList<AbfsHttpHeader> requestHeaders = new ArrayList<AbfsHttpHeader>();
        requestHeaders.add(new AbfsHttpHeader("x-ms-version", "2018-06-17"));
        requestHeaders.add(new AbfsHttpHeader("Accept", "application/json, application/octet-stream"));
        requestHeaders.add(new AbfsHttpHeader("Accept-Charset", "utf-8"));
        requestHeaders.add(new AbfsHttpHeader("Content-Type", ""));
        requestHeaders.add(new AbfsHttpHeader("User-Agent", this.userAgent));
        return requestHeaders;
    }

    AbfsUriQueryBuilder createDefaultUriQueryBuilder() {
        AbfsUriQueryBuilder abfsUriQueryBuilder = new AbfsUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("timeout", "90");
        return abfsUriQueryBuilder;
    }

    public AbfsRestOperation createFilesystem() throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = new AbfsUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.CreateFileSystem, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation setFilesystemProperties(String properties) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-properties", properties));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.SetFileSystemProperties, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation listPath(String relativePath, boolean recursive, int listMaxResults, String continuation) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        abfsUriQueryBuilder.addQuery("directory", relativePath == null ? "" : relativePath);
        abfsUriQueryBuilder.addQuery("recursive", String.valueOf(recursive));
        abfsUriQueryBuilder.addQuery("continuation", continuation);
        abfsUriQueryBuilder.addQuery("maxResults", String.valueOf(listMaxResults));
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.ListPaths, this, "GET", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation getFilesystemProperties() throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.GetFileSystemProperties, this, "HEAD", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation deleteFilesystem() throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", "filesystem");
        URL url = this.createRequestUrl(abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.DeleteFileSystem, this, "DELETE", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation createPath(String path, boolean isFile, boolean overwrite, String permission, String umask) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        if (!overwrite) {
            requestHeaders.add(new AbfsHttpHeader("If-None-Match", "*"));
        }
        if (permission != null && !permission.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-permissions", permission));
        }
        if (umask != null && !umask.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-umask", umask));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("resource", isFile ? "file" : "directory");
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.CreatePath, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation renamePath(String source, String destination, String continuation) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        String encodedRenameSource = AbfsClient.urlEncode("/" + this.getFileSystem() + source);
        requestHeaders.add(new AbfsHttpHeader("x-ms-rename-source", encodedRenameSource));
        requestHeaders.add(new AbfsHttpHeader("If-None-Match", "*"));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("continuation", continuation);
        URL url = this.createRequestUrl(destination, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.RenamePath, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation append(String path, long position, byte[] buffer, int offset, int length) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "append");
        abfsUriQueryBuilder.addQuery("position", Long.toString(position));
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.Append, this, "PUT", url, requestHeaders, buffer, offset, length);
        op.execute();
        return op;
    }

    public AbfsRestOperation flush(String path, long position, boolean retainUncommittedData) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "flush");
        abfsUriQueryBuilder.addQuery("position", Long.toString(position));
        abfsUriQueryBuilder.addQuery("retainUncommittedData", String.valueOf(retainUncommittedData));
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.Flush, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation setPathProperties(String path, String properties) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-properties", properties));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setProperties");
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.SetPathProperties, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation getPathProperties(String path) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.GetPathProperties, this, "HEAD", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation read(String path, long position, byte[] buffer, int bufferOffset, int bufferLength, String eTag) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("Range", String.format("bytes=%d-%d", position, position + (long)bufferLength - 1L)));
        requestHeaders.add(new AbfsHttpHeader("If-Match", eTag));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.ReadFile, this, "GET", url, requestHeaders, buffer, bufferOffset, bufferLength);
        op.execute();
        return op;
    }

    public AbfsRestOperation deletePath(String path, boolean recursive, String continuation) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("recursive", String.valueOf(recursive));
        abfsUriQueryBuilder.addQuery("continuation", continuation);
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.DeletePath, this, "DELETE", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation setOwner(String path, String owner, String group) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        if (owner != null && !owner.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-owner", owner));
        }
        if (group != null && !group.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("x-ms-group", group));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setAccessControl");
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.SetOwner, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation setPermission(String path, String permission) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-permissions", permission));
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setAccessControl");
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.SetPermissions, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation setAcl(String path, String aclSpecString) throws AzureBlobFileSystemException {
        return this.setAcl(path, aclSpecString, "");
    }

    public AbfsRestOperation setAcl(String path, String aclSpecString, String eTag) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        requestHeaders.add(new AbfsHttpHeader("X-HTTP-Method-Override", "PATCH"));
        requestHeaders.add(new AbfsHttpHeader("x-ms-acl", aclSpecString));
        if (eTag != null && !eTag.isEmpty()) {
            requestHeaders.add(new AbfsHttpHeader("If-Match", eTag));
        }
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "setAccessControl");
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.SetAcl, this, "PUT", url, requestHeaders);
        op.execute();
        return op;
    }

    public AbfsRestOperation getAclStatus(String path) throws AzureBlobFileSystemException {
        List<AbfsHttpHeader> requestHeaders = this.createDefaultHeaders();
        AbfsUriQueryBuilder abfsUriQueryBuilder = this.createDefaultUriQueryBuilder();
        abfsUriQueryBuilder.addQuery("action", "getAccessControl");
        URL url = this.createRequestUrl(path, abfsUriQueryBuilder.toString());
        AbfsRestOperation op = new AbfsRestOperation(AbfsRestOperationType.GetAcl, this, "HEAD", url, requestHeaders);
        op.execute();
        return op;
    }

    private URL createRequestUrl(String query) throws AzureBlobFileSystemException {
        return this.createRequestUrl("", query);
    }

    private URL createRequestUrl(String path, String query) throws AzureBlobFileSystemException {
        URL url;
        String base = this.baseUrl.toString();
        String encodedPath = path;
        try {
            encodedPath = AbfsClient.urlEncode(path);
        }
        catch (AzureBlobFileSystemException ex) {
            LOG.debug("Unexpected error.", ex);
            throw new InvalidUriException(path);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(base);
        sb.append(encodedPath);
        sb.append(query);
        try {
            url = new URL(sb.toString());
        }
        catch (MalformedURLException ex) {
            throw new InvalidUriException(sb.toString());
        }
        return url;
    }

    public static String urlEncode(String value) throws AzureBlobFileSystemException {
        String encodedString;
        try {
            encodedString = URLEncoder.encode(value, "utf-8").replace("+", "%20").replace("%2F", "/");
        }
        catch (UnsupportedEncodingException ex) {
            throw new InvalidUriException(value);
        }
        return encodedString;
    }

    public synchronized String getAccessToken() throws IOException {
        if (this.tokenProvider != null) {
            return "Bearer " + this.tokenProvider.getToken().getAccessToken();
        }
        return null;
    }

    @VisibleForTesting
    String initializeUserAgent(AbfsConfiguration abfsConfiguration, String sslProviderName) {
        StringBuilder sb = new StringBuilder();
        sb.append("(JavaJRE ");
        sb.append(System.getProperty("java.version"));
        sb.append("; ");
        sb.append(System.getProperty("os.name").replaceAll(" ", ""));
        sb.append(" ");
        sb.append(System.getProperty("os.version"));
        if (sslProviderName != null && !sslProviderName.isEmpty()) {
            sb.append("; ");
            sb.append(sslProviderName);
        }
        sb.append(")");
        String userAgentComment = sb.toString();
        String customUserAgentId = abfsConfiguration.getCustomUserAgentPrefix();
        if (customUserAgentId != null && !customUserAgentId.isEmpty()) {
            return String.format(Locale.ROOT, "Azure Blob FS/1.0 %s %s", userAgentComment, customUserAgentId);
        }
        return String.format("Azure Blob FS/1.0 %s", userAgentComment);
    }

    @VisibleForTesting
    URL getBaseUrl() {
        return this.baseUrl;
    }
}

