/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.token.delegation.web;

import io.trino.hadoop.$internal.com.google.common.base.Preconditions;
import io.trino.hadoop.$internal.com.google.common.base.Splitter;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.security.authentication.client.AuthenticationException;
import org.apache.hadoop.security.authentication.server.AuthenticationHandlerUtil;
import org.apache.hadoop.security.authentication.server.AuthenticationToken;
import org.apache.hadoop.security.authentication.server.CompositeAuthenticationHandler;
import org.apache.hadoop.security.authentication.server.MultiSchemeAuthenticationHandler;
import org.apache.hadoop.security.token.delegation.web.DelegationTokenAuthenticationHandler;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MultiSchemeDelegationTokenAuthenticationHandler
extends DelegationTokenAuthenticationHandler
implements CompositeAuthenticationHandler {
    public static final String DELEGATION_TOKEN_SCHEMES_PROPERTY = "multi-scheme-auth-handler.delegation.schemes";
    private static final Splitter STR_SPLITTER = Splitter.on(',').trimResults().omitEmptyStrings();
    private Set<String> delegationAuthSchemes = null;

    public MultiSchemeDelegationTokenAuthenticationHandler() {
        super(new MultiSchemeAuthenticationHandler("multi-scheme-dt"));
    }

    @Override
    public Collection<String> getTokenTypes() {
        return ((CompositeAuthenticationHandler)this.getAuthHandler()).getTokenTypes();
    }

    @Override
    public void init(Properties config) throws ServletException {
        super.init(config);
        String schemesProperty = Preconditions.checkNotNull(config.getProperty("multi-scheme-auth-handler.schemes"));
        String delegationAuthSchemesProp = Preconditions.checkNotNull(config.getProperty(DELEGATION_TOKEN_SCHEMES_PROPERTY));
        HashSet<String> authSchemes = new HashSet<String>();
        for (String scheme : STR_SPLITTER.split(schemesProperty)) {
            authSchemes.add(AuthenticationHandlerUtil.checkAuthScheme(scheme));
        }
        this.delegationAuthSchemes = new HashSet<String>();
        for (String scheme : STR_SPLITTER.split(delegationAuthSchemesProp)) {
            this.delegationAuthSchemes.add(AuthenticationHandlerUtil.checkAuthScheme(scheme));
        }
        Preconditions.checkArgument(authSchemes.containsAll(this.delegationAuthSchemes));
    }

    @Override
    public AuthenticationToken authenticate(HttpServletRequest request, HttpServletResponse response) throws IOException, AuthenticationException {
        String authorization = request.getHeader("Authorization");
        if (this.isManagementOperation(request)) {
            boolean schemeConfigured = false;
            if (authorization != null) {
                for (String scheme : this.delegationAuthSchemes) {
                    if (!AuthenticationHandlerUtil.matchAuthScheme(scheme, authorization)) continue;
                    schemeConfigured = true;
                    break;
                }
            }
            if (!schemeConfigured) {
                response.setStatus(401);
                for (String scheme : this.delegationAuthSchemes) {
                    response.addHeader("WWW-Authenticate", scheme);
                }
                return null;
            }
        }
        return super.authenticate(request, response);
    }
}

