/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.qualifier;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jdbi.v3.core.config.ConfigRegistry;
import org.jdbi.v3.core.config.JdbiCache;
import org.jdbi.v3.core.config.JdbiCaches;
import org.jdbi.v3.core.config.JdbiConfig;
import org.jdbi.v3.core.internal.CollectionCollectors;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.qualifier.Qualifier;

public class Qualifiers
implements JdbiConfig<Qualifiers> {
    private static final JdbiCache<AnnotatedElement[], Set<Annotation>> QUALIFIER_CACHE = JdbiCaches.declare(elements -> ((AnnotatedElement[])elements).length == 1 ? elements[0] : new HashSet<AnnotatedElement>(Arrays.asList(elements)), Qualifiers::getQualifiers);
    private static final JdbiCache<AnnotatedElement, QualifiedType<?>> QUALIFIED_TYPE_CACHE = JdbiCaches.declare(type -> QualifiedType.of((Type)((Object)type)).withAnnotations(Qualifiers.getQualifiers(type)));
    private ConfigRegistry registry;

    @Override
    public void setRegistry(ConfigRegistry registry) {
        this.registry = registry;
    }

    public <ELEM extends AnnotatedElement & Type> QualifiedType<?> qualifiedTypeOf(ELEM type) {
        if (this.registry == null) {
            return QualifiedType.of(type).withAnnotations(Qualifiers.getQualifiers(type));
        }
        return QUALIFIED_TYPE_CACHE.get(type, this.registry);
    }

    public Set<Annotation> findFor(AnnotatedElement ... elements) {
        if (this.registry == null) {
            return Qualifiers.getQualifiers(elements);
        }
        return QUALIFIER_CACHE.get(elements, this.registry);
    }

    private static Set<Annotation> getQualifiers(AnnotatedElement ... elements) {
        return Arrays.stream(elements).filter(Objects::nonNull).map(AnnotatedElement::getAnnotations).flatMap(Arrays::stream).filter(anno -> anno.annotationType().isAnnotationPresent(Qualifier.class)).collect(CollectionCollectors.toUnmodifiableSet());
    }

    @Override
    public Qualifiers createCopy() {
        return new Qualifiers();
    }
}

