/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import io.airlift.concurrent.Threads;
import io.trino.plugin.base.CatalogName;
import io.trino.plugin.raptor.legacy.NodeSupplier;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.RaptorSessionProperties;
import io.trino.plugin.raptor.legacy.RaptorSplit;
import io.trino.plugin.raptor.legacy.RaptorTableHandle;
import io.trino.plugin.raptor.legacy.backup.BackupService;
import io.trino.plugin.raptor.legacy.metadata.BucketShards;
import io.trino.plugin.raptor.legacy.metadata.ShardManager;
import io.trino.plugin.raptor.legacy.metadata.ShardNodes;
import io.trino.plugin.raptor.legacy.util.SynchronizedResultIterator;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.HostAddress;
import io.trino.spi.Node;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorSplitSource;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.DynamicFilter;
import io.trino.spi.predicate.TupleDomain;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;
import org.jdbi.v3.core.result.ResultIterator;

public class RaptorSplitManager
implements ConnectorSplitManager {
    private final NodeSupplier nodeSupplier;
    private final ShardManager shardManager;
    private final boolean backupAvailable;
    private final ExecutorService executor;

    @Inject
    public RaptorSplitManager(CatalogName catalogName, NodeSupplier nodeSupplier, ShardManager shardManager, BackupService backupService) {
        this(catalogName, nodeSupplier, shardManager, backupService.isBackupAvailable());
    }

    public RaptorSplitManager(CatalogName catalogName, NodeSupplier nodeSupplier, ShardManager shardManager, boolean backupAvailable) {
        this.nodeSupplier = Objects.requireNonNull(nodeSupplier, "nodeSupplier is null");
        this.shardManager = Objects.requireNonNull(shardManager, "shardManager is null");
        this.backupAvailable = backupAvailable;
        this.executor = Executors.newCachedThreadPool(Threads.daemonThreadsNamed((String)("raptor-split-" + catalogName + "-%s")));
    }

    @PreDestroy
    public void destroy() {
        this.executor.shutdownNow();
    }

    public ConnectorSplitSource getSplits(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorTableHandle handle, DynamicFilter dynamicFilter, Constraint constraint) {
        RaptorTableHandle table = (RaptorTableHandle)handle;
        long tableId = table.getTableId();
        boolean bucketed = table.getBucketCount().isPresent();
        boolean merged = bucketed && table.getBucketCount().getAsInt() >= RaptorSessionProperties.getOneSplitPerBucketThreshold(session);
        Optional<List<String>> bucketToNode = table.getBucketAssignments();
        Verify.verify((bucketed == bucketToNode.isPresent() ? 1 : 0) != 0, (String)"mismatched bucketCount and bucketToNode presence", (Object[])new Object[0]);
        return new RaptorSplitSource(tableId, merged, table.getConstraint(), bucketToNode);
    }

    private static List<HostAddress> getAddressesForNodes(Map<String, Node> nodeMap, Iterable<String> nodeIdentifiers) {
        ImmutableList.Builder nodes = ImmutableList.builder();
        for (String id : nodeIdentifiers) {
            Node node = nodeMap.get(id);
            if (node == null) continue;
            nodes.add((Object)node.getHostAndPort());
        }
        return nodes.build();
    }

    private static <T> T selectRandom(Iterable<T> elements) {
        ImmutableList list = ImmutableList.copyOf(elements);
        return (T)list.get(ThreadLocalRandom.current().nextInt(list.size()));
    }

    private class RaptorSplitSource
    implements ConnectorSplitSource {
        private final Map<String, Node> nodesById;
        private final long tableId;
        private final Optional<List<String>> bucketToNode;
        private final ResultIterator<BucketShards> iterator;
        @GuardedBy(value="this")
        private CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> future;

        public RaptorSplitSource(long tableId, boolean merged, TupleDomain<RaptorColumnHandle> effectivePredicate, Optional<List<String>> bucketToNode) {
            this.nodesById = Maps.uniqueIndex(RaptorSplitManager.this.nodeSupplier.getWorkerNodes(), Node::getNodeIdentifier);
            this.tableId = tableId;
            this.bucketToNode = Objects.requireNonNull(bucketToNode, "bucketToNode is null");
            ResultIterator<BucketShards> iterator = bucketToNode.isPresent() ? RaptorSplitManager.this.shardManager.getShardNodesBucketed(tableId, merged, bucketToNode.get(), effectivePredicate) : RaptorSplitManager.this.shardManager.getShardNodes(tableId, effectivePredicate);
            this.iterator = new SynchronizedResultIterator<BucketShards>(iterator);
        }

        public synchronized CompletableFuture<ConnectorSplitSource.ConnectorSplitBatch> getNextBatch(int maxSize) {
            Preconditions.checkState((this.future == null || this.future.isDone() ? 1 : 0) != 0, (Object)"previous batch not completed");
            this.future = CompletableFuture.supplyAsync(this.batchSupplier(maxSize), RaptorSplitManager.this.executor);
            return this.future;
        }

        public synchronized void close() {
            if (this.future != null) {
                this.future.cancel(true);
                this.future = null;
            }
            RaptorSplitManager.this.executor.execute(() -> this.iterator.close());
        }

        public boolean isFinished() {
            return !this.iterator.hasNext();
        }

        private Supplier<ConnectorSplitSource.ConnectorSplitBatch> batchSupplier(int maxSize) {
            return () -> {
                ImmutableList.Builder list = ImmutableList.builder();
                for (int i = 0; i < maxSize; ++i) {
                    if (Thread.currentThread().isInterrupted()) {
                        throw new RuntimeException("Split batch fetch was interrupted");
                    }
                    if (!this.iterator.hasNext()) break;
                    list.add((Object)this.createSplit((BucketShards)this.iterator.next()));
                }
                return new ConnectorSplitSource.ConnectorSplitBatch((List)list.build(), this.isFinished());
            };
        }

        private ConnectorSplit createSplit(BucketShards bucketShards) {
            if (bucketShards.getBucketNumber().isPresent()) {
                return this.createBucketSplit(bucketShards.getBucketNumber().getAsInt(), bucketShards.getShards());
            }
            Verify.verify((bucketShards.getShards().size() == 1 ? 1 : 0) != 0, (String)"wrong shard count for non-bucketed table", (Object[])new Object[0]);
            ShardNodes shard = (ShardNodes)Iterables.getOnlyElement(bucketShards.getShards());
            UUID shardId = shard.getShardUuid();
            Set<String> nodeIds = shard.getNodeIdentifiers();
            ImmutableList addresses = RaptorSplitManager.getAddressesForNodes(this.nodesById, nodeIds);
            if (addresses.isEmpty()) {
                if (!RaptorSplitManager.this.backupAvailable) {
                    throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_NO_HOST_FOR_SHARD, String.format("No host for shard %s found: %s", shardId, nodeIds));
                }
                Set<Node> availableNodes = RaptorSplitManager.this.nodeSupplier.getWorkerNodes();
                if (availableNodes.isEmpty()) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "No nodes available to run query");
                }
                Node node = RaptorSplitManager.selectRandom(availableNodes);
                RaptorSplitManager.this.shardManager.replaceShardAssignment(this.tableId, shardId, node.getNodeIdentifier(), true);
                addresses = ImmutableList.of((Object)node.getHostAndPort());
            }
            return new RaptorSplit(shardId, (List<HostAddress>)addresses);
        }

        private ConnectorSplit createBucketSplit(int bucketNumber, Set<ShardNodes> shards) {
            String nodeId = this.bucketToNode.get().get(bucketNumber);
            Node node = this.nodesById.get(nodeId);
            if (node == null) {
                throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NO_NODES_AVAILABLE, "Node for bucket is offline: " + nodeId);
            }
            Set<UUID> shardUuids = shards.stream().map(ShardNodes::getShardUuid).collect(Collectors.toSet());
            HostAddress address = node.getHostAndPort();
            return new RaptorSplit(shardUuids, bucketNumber, address);
        }
    }
}

