/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.backup;

import com.google.common.io.ByteStreams;
import com.google.common.net.MediaType;
import io.airlift.http.client.BodyGenerator;
import io.airlift.http.client.FileBodyGenerator;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.HttpStatus;
import io.airlift.http.client.HttpUriBuilder;
import io.airlift.http.client.Request;
import io.airlift.http.client.Response;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.ResponseHandlerUtils;
import io.airlift.http.client.StatusResponseHandler;
import io.airlift.slice.XxHash64;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.backup.BackupStore;
import io.trino.plugin.raptor.legacy.backup.ForHttpBackup;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.NodeManager;
import io.trino.spi.TrinoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Supplier;
import javax.inject.Inject;

public class HttpBackupStore
implements BackupStore {
    public static final String TRINO_ENVIRONMENT = "X-Trino-Environment";
    public static final String CONTENT_XXH64 = "X-Content-XXH64";
    private final HttpClient httpClient;
    private final Supplier<URI> baseUriSupplier;
    private final String environment;

    @Inject
    public HttpBackupStore(@ForHttpBackup HttpClient httpClient, @ForHttpBackup Supplier<URI> baseUriSupplier, NodeManager nodeManager) {
        this.httpClient = Objects.requireNonNull(httpClient, "httpClient is null");
        this.baseUriSupplier = Objects.requireNonNull(baseUriSupplier, "baseUriSupplier is null");
        this.environment = nodeManager.getEnvironment();
    }

    @Override
    public void backupShard(UUID uuid, File source) {
        Request request = Request.Builder.preparePut().addHeader(TRINO_ENVIRONMENT, this.environment).addHeader("Content-Type", MediaType.APPLICATION_BINARY.toString()).addHeader(CONTENT_XXH64, String.format("%016x", HttpBackupStore.xxHash64(source))).setUri(this.shardUri(uuid)).setBodyGenerator((BodyGenerator)new FileBodyGenerator(source.toPath())).build();
        try {
            StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            if (!HttpBackupStore.isOk(status)) {
                throw HttpBackupStore.badResponse(status);
            }
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to backup shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public void restoreShard(UUID uuid, File target) {
        Request request = Request.Builder.prepareGet().addHeader(TRINO_ENVIRONMENT, this.environment).setUri(this.shardUri(uuid)).build();
        try {
            StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)new FileResponseHandler(target));
            if (HttpBackupStore.isNotFound(status) || HttpBackupStore.isGone(status)) {
                throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Backup shard not found: " + uuid);
            }
            if (!HttpBackupStore.isOk(status)) {
                throw HttpBackupStore.badResponse(status);
            }
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to restore shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public boolean deleteShard(UUID uuid) {
        Request request = Request.Builder.prepareDelete().addHeader(TRINO_ENVIRONMENT, this.environment).setUri(this.shardUri(uuid)).build();
        try {
            StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            if (HttpBackupStore.isOk(status) || HttpBackupStore.isGone(status)) {
                return true;
            }
            if (HttpBackupStore.isNotFound(status)) {
                return false;
            }
            throw HttpBackupStore.badResponse(status);
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to delete shard: " + uuid, (Throwable)e);
        }
    }

    @Override
    public boolean shardExists(UUID uuid) {
        Request request = Request.Builder.prepareHead().addHeader(TRINO_ENVIRONMENT, this.environment).setUri(this.shardUri(uuid)).build();
        try {
            StatusResponseHandler.StatusResponse status = (StatusResponseHandler.StatusResponse)this.httpClient.execute(request, (ResponseHandler)StatusResponseHandler.createStatusResponseHandler());
            if (HttpBackupStore.isOk(status)) {
                return true;
            }
            if (HttpBackupStore.isNotFound(status) || HttpBackupStore.isGone(status)) {
                return false;
            }
            throw HttpBackupStore.badResponse(status);
        }
        catch (RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to check if shard exists: " + uuid, (Throwable)e);
        }
    }

    private URI shardUri(UUID uuid) {
        return HttpUriBuilder.uriBuilderFrom((URI)this.baseUriSupplier.get()).appendPath(uuid.toString().toLowerCase(Locale.ENGLISH)).build();
    }

    private static boolean isOk(StatusResponseHandler.StatusResponse response) {
        return response.getStatusCode() == HttpStatus.OK.code() || response.getStatusCode() == HttpStatus.NO_CONTENT.code();
    }

    private static boolean isNotFound(StatusResponseHandler.StatusResponse response) {
        return response.getStatusCode() == HttpStatus.NOT_FOUND.code();
    }

    private static boolean isGone(StatusResponseHandler.StatusResponse response) {
        return response.getStatusCode() == HttpStatus.GONE.code();
    }

    private static RuntimeException badResponse(StatusResponseHandler.StatusResponse response) {
        throw new RuntimeException("Request failed with HTTP status " + response.getStatusCode());
    }

    private static long xxHash64(File file) {
        long l;
        FileInputStream in = new FileInputStream(file);
        try {
            l = XxHash64.hash((InputStream)in);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_BACKUP_ERROR, "Failed to read file: " + file, (Throwable)e);
            }
        }
        ((InputStream)in).close();
        return l;
    }

    private static class FileResponseHandler
    implements ResponseHandler<StatusResponseHandler.StatusResponse, IOException> {
        private final File file;

        private FileResponseHandler(File file) {
            this.file = Objects.requireNonNull(file, "file is null");
        }

        public StatusResponseHandler.StatusResponse handleException(Request request, Exception exception) {
            throw ResponseHandlerUtils.propagate((Request)request, (Throwable)exception);
        }

        public StatusResponseHandler.StatusResponse handle(Request request, Response response) throws IOException {
            StatusResponseHandler.StatusResponse status = FileResponseHandler.createStatusResponse(response);
            if (HttpBackupStore.isOk(status)) {
                this.writeFile(response.getInputStream());
            }
            return status;
        }

        private void writeFile(InputStream in) throws IOException {
            try (FileOutputStream out = new FileOutputStream(this.file);){
                ByteStreams.copy((InputStream)in, (OutputStream)out);
                out.flush();
                out.getFD().sync();
            }
        }

        private static StatusResponseHandler.StatusResponse createStatusResponse(Response response) {
            return new StatusResponseHandler.StatusResponse(response.getStatusCode(), response.getHeaders());
        }
    }
}

