/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MaxDataSize;
import io.airlift.units.MinDataSize;
import io.airlift.units.MinDuration;
import io.trino.orc.OrcReaderOptions;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"storage.backup-directory", "storage.shard-day-boundary-time-zone"})
public class StorageManagerConfig {
    private File dataDirectory;
    private DataSize minAvailableSpace = DataSize.ofBytes((long)0L);
    private Duration shardRecoveryTimeout = new Duration(30.0, TimeUnit.SECONDS);
    private Duration missingShardDiscoveryInterval = new Duration(5.0, TimeUnit.MINUTES);
    private boolean compactionEnabled = true;
    private Duration compactionInterval = new Duration(1.0, TimeUnit.HOURS);
    private Duration shardEjectorInterval = new Duration(4.0, TimeUnit.HOURS);
    private OrcReaderOptions options = new OrcReaderOptions();
    private int deletionThreads = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    private int recoveryThreads = 10;
    private int organizationThreads = 5;
    private boolean organizationEnabled = true;
    private Duration organizationDiscoveryInterval = new Duration(6.0, TimeUnit.HOURS);
    private Duration organizationInterval = new Duration(7.0, TimeUnit.DAYS);
    private long maxShardRows = 1000000L;
    private DataSize maxShardSize = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private DataSize maxBufferSize = DataSize.of((long)256L, (DataSize.Unit)DataSize.Unit.MEGABYTE);
    private int oneSplitPerBucketThreshold;

    @NotNull
    public File getDataDirectory() {
        return this.dataDirectory;
    }

    @Config(value="storage.data-directory")
    @ConfigDescription(value="Base directory to use for storing shard data")
    public StorageManagerConfig setDataDirectory(File dataDirectory) {
        this.dataDirectory = dataDirectory;
        return this;
    }

    @NotNull
    public DataSize getMinAvailableSpace() {
        return this.minAvailableSpace;
    }

    @Config(value="storage.min-available-space")
    @ConfigDescription(value="Minimum space that must be available on the data directory file system")
    public StorageManagerConfig setMinAvailableSpace(DataSize minAvailableSpace) {
        this.minAvailableSpace = minAvailableSpace;
        return this;
    }

    public OrcReaderOptions toOrcReaderOptions() {
        return this.options;
    }

    @NotNull
    public DataSize getOrcMaxMergeDistance() {
        return this.options.getMaxMergeDistance();
    }

    @Config(value="storage.orc.max-merge-distance")
    public StorageManagerConfig setOrcMaxMergeDistance(DataSize orcMaxMergeDistance) {
        this.options = this.options.withMaxMergeDistance(orcMaxMergeDistance);
        return this;
    }

    @NotNull
    public DataSize getOrcMaxReadSize() {
        return this.options.getMaxBufferSize();
    }

    @Config(value="storage.orc.max-read-size")
    public StorageManagerConfig setOrcMaxReadSize(DataSize orcMaxReadSize) {
        this.options = this.options.withMaxBufferSize(orcMaxReadSize);
        return this;
    }

    @NotNull
    public DataSize getOrcStreamBufferSize() {
        return this.options.getStreamBufferSize();
    }

    @Config(value="storage.orc.stream-buffer-size")
    public StorageManagerConfig setOrcStreamBufferSize(DataSize orcStreamBufferSize) {
        this.options = this.options.withStreamBufferSize(orcStreamBufferSize);
        return this;
    }

    @NotNull
    public DataSize getOrcTinyStripeThreshold() {
        return this.options.getTinyStripeThreshold();
    }

    @Config(value="storage.orc.tiny-stripe-threshold")
    public StorageManagerConfig setOrcTinyStripeThreshold(DataSize orcTinyStripeThreshold) {
        this.options = this.options.withTinyStripeThreshold(orcTinyStripeThreshold);
        return this;
    }

    @Deprecated
    public boolean isOrcLazyReadSmallRanges() {
        return this.options.isLazyReadSmallRanges();
    }

    @Deprecated
    @Config(value="storage.orc.lazy-read-small-ranges")
    public StorageManagerConfig setOrcLazyReadSmallRanges(boolean orcLazyReadSmallRanges) {
        this.options = this.options.withLazyReadSmallRanges(orcLazyReadSmallRanges);
        return this;
    }

    @Deprecated
    public boolean isOrcNestedLazy() {
        return this.options.isNestedLazy();
    }

    @Deprecated
    @Config(value="storage.orc.nested-lazy")
    public StorageManagerConfig setOrcNestedLazy(boolean nestedLazy) {
        this.options = this.options.withNestedLazy(nestedLazy);
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getDeletionThreads() {
        return this.deletionThreads;
    }

    @Config(value="storage.max-deletion-threads")
    @ConfigDescription(value="Maximum number of threads to use for deletions")
    public StorageManagerConfig setDeletionThreads(int deletionThreads) {
        this.deletionThreads = deletionThreads;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getShardRecoveryTimeout() {
        return this.shardRecoveryTimeout;
    }

    @Config(value="storage.shard-recovery-timeout")
    @ConfigDescription(value="Maximum time to wait for a shard to recover from backup while running a query")
    public StorageManagerConfig setShardRecoveryTimeout(Duration shardRecoveryTimeout) {
        this.shardRecoveryTimeout = shardRecoveryTimeout;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getMissingShardDiscoveryInterval() {
        return this.missingShardDiscoveryInterval;
    }

    @Config(value="storage.missing-shard-discovery-interval")
    @ConfigDescription(value="How often to check the database and local file system missing shards")
    public StorageManagerConfig setMissingShardDiscoveryInterval(Duration missingShardDiscoveryInterval) {
        this.missingShardDiscoveryInterval = missingShardDiscoveryInterval;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getCompactionInterval() {
        return this.compactionInterval;
    }

    @Config(value="storage.compaction-interval")
    @ConfigDescription(value="How often to check for local shards that need compaction")
    public StorageManagerConfig setCompactionInterval(Duration compactionInterval) {
        this.compactionInterval = compactionInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getOrganizationInterval() {
        return this.organizationInterval;
    }

    @Config(value="storage.organization-interval")
    @ConfigDescription(value="How long to wait between table organization iterations")
    public StorageManagerConfig setOrganizationInterval(Duration organizationInterval) {
        this.organizationInterval = organizationInterval;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getOrganizationDiscoveryInterval() {
        return this.organizationDiscoveryInterval;
    }

    @Config(value="storage.organization-discovery-interval")
    @ConfigDescription(value="How long to wait between discovering tables that need to be organized")
    public StorageManagerConfig setOrganizationDiscoveryInterval(Duration organizationDiscoveryInterval) {
        this.organizationDiscoveryInterval = organizationDiscoveryInterval;
        return this;
    }

    @MinDuration(value="5m")
    public @MinDuration(value="5m") Duration getShardEjectorInterval() {
        return this.shardEjectorInterval;
    }

    @Config(value="storage.ejector-interval")
    @ConfigDescription(value="How often to check for local shards that need ejection to balance capacity")
    public StorageManagerConfig setShardEjectorInterval(Duration shardEjectorInterval) {
        this.shardEjectorInterval = shardEjectorInterval;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRecoveryThreads() {
        return this.recoveryThreads;
    }

    @Config(value="storage.max-recovery-threads")
    @ConfigDescription(value="Maximum number of threads to use for recovery")
    public StorageManagerConfig setRecoveryThreads(int recoveryThreads) {
        this.recoveryThreads = recoveryThreads;
        return this;
    }

    @LegacyConfig(value={"storage.max-compaction-threads"})
    @Config(value="storage.max-organization-threads")
    @ConfigDescription(value="Maximum number of threads to use for organization")
    public StorageManagerConfig setOrganizationThreads(int organizationThreads) {
        this.organizationThreads = organizationThreads;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getOrganizationThreads() {
        return this.organizationThreads;
    }

    @Min(value=1L)
    @Max(value=1000000000L)
    public @Min(value=1L) @Max(value=1000000000L) long getMaxShardRows() {
        return this.maxShardRows;
    }

    @Config(value="storage.max-shard-rows")
    @ConfigDescription(value="Approximate maximum number of rows per shard")
    public StorageManagerConfig setMaxShardRows(long maxShardRows) {
        this.maxShardRows = maxShardRows;
        return this;
    }

    @MinDataSize(value="1MB")
    @MaxDataSize(value="1GB")
    public @MinDataSize(value="1MB") @MaxDataSize(value="1GB") DataSize getMaxShardSize() {
        return this.maxShardSize;
    }

    @Config(value="storage.max-shard-size")
    @ConfigDescription(value="Approximate maximum uncompressed size of a shard")
    public StorageManagerConfig setMaxShardSize(DataSize maxShardSize) {
        this.maxShardSize = maxShardSize;
        return this;
    }

    @MinDataSize(value="1MB")
    public @MinDataSize(value="1MB") DataSize getMaxBufferSize() {
        return this.maxBufferSize;
    }

    @Config(value="storage.max-buffer-size")
    @ConfigDescription(value="Maximum data to buffer before flushing to disk")
    public StorageManagerConfig setMaxBufferSize(DataSize maxBufferSize) {
        this.maxBufferSize = maxBufferSize;
        return this;
    }

    public boolean isCompactionEnabled() {
        return this.compactionEnabled;
    }

    @Config(value="storage.compaction-enabled")
    public StorageManagerConfig setCompactionEnabled(boolean compactionEnabled) {
        this.compactionEnabled = compactionEnabled;
        return this;
    }

    public boolean isOrganizationEnabled() {
        return this.organizationEnabled;
    }

    @Config(value="storage.organization-enabled")
    public StorageManagerConfig setOrganizationEnabled(boolean organizationEnabled) {
        this.organizationEnabled = organizationEnabled;
        return this;
    }

    public int getOneSplitPerBucketThreshold() {
        return this.oneSplitPerBucketThreshold;
    }

    @Config(value="storage.one-split-per-bucket-threshold")
    @ConfigDescription(value="Experimental: Maximum bucket count at which to produce multiple splits per bucket")
    public StorageManagerConfig setOneSplitPerBucketThreshold(int oneSplitPerBucketThreshold) {
        this.oneSplitPerBucketThreshold = oneSplitPerBucketThreshold;
        return this;
    }
}

