/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.storage.organization;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import io.airlift.slice.Slices;
import io.trino.plugin.raptor.legacy.metadata.DatabaseShardManager;
import io.trino.plugin.raptor.legacy.metadata.MetadataDao;
import io.trino.plugin.raptor.legacy.metadata.ShardMetadata;
import io.trino.plugin.raptor.legacy.metadata.Table;
import io.trino.plugin.raptor.legacy.metadata.TableColumn;
import io.trino.plugin.raptor.legacy.storage.ColumnIndexStatsUtils;
import io.trino.plugin.raptor.legacy.storage.organization.OrganizationSet;
import io.trino.plugin.raptor.legacy.storage.organization.ShardIndexInfo;
import io.trino.plugin.raptor.legacy.storage.organization.ShardRange;
import io.trino.plugin.raptor.legacy.storage.organization.TemporalFunction;
import io.trino.plugin.raptor.legacy.storage.organization.Tuple;
import io.trino.spi.type.Type;
import java.sql.Connection;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;

public final class ShardOrganizerUtil {
    private ShardOrganizerUtil() {
    }

    public static Collection<ShardIndexInfo> getOrganizationEligibleShards(Jdbi dbi, MetadataDao metadataDao, Table tableInfo, Collection<ShardMetadata> shards, boolean includeSortColumns) {
        ImmutableMap shardsById = Maps.uniqueIndex(shards, ShardMetadata::getShardId);
        long tableId = tableInfo.getTableId();
        ImmutableList.Builder columnsBuilder = ImmutableList.builder();
        columnsBuilder.add((Object)"shard_id");
        Optional<Object> temporalColumn = Optional.empty();
        if (tableInfo.getTemporalColumnId().isPresent()) {
            long temporalColumnId = tableInfo.getTemporalColumnId().getAsLong();
            temporalColumn = Optional.of(metadataDao.getTableColumn(tableId, temporalColumnId));
            columnsBuilder.add((Object[])new String[]{DatabaseShardManager.minColumn(temporalColumnId), DatabaseShardManager.maxColumn(temporalColumnId)});
        }
        Optional<Object> sortColumns = Optional.empty();
        if (includeSortColumns) {
            sortColumns = Optional.of(metadataDao.listSortColumns(tableId));
            for (TableColumn column : (List)sortColumns.get()) {
                columnsBuilder.add((Object[])new String[]{DatabaseShardManager.minColumn(column.getColumnId()), DatabaseShardManager.maxColumn(column.getColumnId())});
            }
        }
        String columnToSelect = Joiner.on((String)",\n").join((Iterable)columnsBuilder.build());
        ImmutableList.Builder indexInfoBuilder = ImmutableList.builder();
        try (Connection connection = dbi.open().getConnection();){
            for (List partitionedShards : Iterables.partition(shards, (int)1000)) {
                String shardIds = Joiner.on((String)",").join(Collections.nCopies(partitionedShards.size(), "?"));
                String sql = String.format("SELECT %s\nFROM %s\nWHERE shard_id IN (%s)", columnToSelect, DatabaseShardManager.shardIndexTable(tableId), shardIds);
                PreparedStatement statement = connection.prepareStatement(sql);
                try {
                    for (int i = 0; i < partitionedShards.size(); ++i) {
                        statement.setLong(i + 1, ((ShardMetadata)partitionedShards.get(i)).getShardId());
                    }
                    ResultSet resultSet = statement.executeQuery();
                    try {
                        while (resultSet.next()) {
                            long shardId = resultSet.getLong("shard_id");
                            Optional<Object> sortRange = Optional.empty();
                            if (includeSortColumns && (sortRange = ShardOrganizerUtil.getShardRange((List)sortColumns.get(), resultSet)).isEmpty()) continue;
                            Optional<Object> temporalRange = Optional.empty();
                            if (temporalColumn.isPresent() && (temporalRange = ShardOrganizerUtil.getShardRange((List<TableColumn>)ImmutableList.of((Object)((TableColumn)temporalColumn.get())), resultSet)).isEmpty()) continue;
                            ShardMetadata shardMetadata = (ShardMetadata)shardsById.get(shardId);
                            indexInfoBuilder.add((Object)ShardOrganizerUtil.toShardIndexInfo(shardMetadata, temporalRange, sortRange));
                        }
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                    }
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        return indexInfoBuilder.build();
    }

    private static ShardIndexInfo toShardIndexInfo(ShardMetadata shardMetadata, Optional<ShardRange> temporalRange, Optional<ShardRange> sortRange) {
        return new ShardIndexInfo(shardMetadata.getTableId(), shardMetadata.getBucketNumber(), shardMetadata.getShardUuid(), shardMetadata.getRowCount(), shardMetadata.getUncompressedSize(), sortRange, temporalRange);
    }

    public static Collection<Collection<ShardIndexInfo>> getShardsByDaysBuckets(Table tableInfo, Collection<ShardIndexInfo> shards) {
        if (shards.isEmpty()) {
            return ImmutableList.of();
        }
        if (tableInfo.getBucketCount().isEmpty() && tableInfo.getTemporalColumnId().isEmpty()) {
            return ImmutableList.of(shards);
        }
        if (tableInfo.getBucketCount().isPresent() && tableInfo.getTemporalColumnId().isEmpty()) {
            return Multimaps.index(shards, shard -> shard.getBucketNumber().getAsInt()).asMap().values();
        }
        ImmutableMultimap.Builder shardsByDaysBuilder = ImmutableMultimap.builder();
        shards.stream().filter(shard -> shard.getTemporalRange().isPresent()).forEach(shard -> {
            long day = TemporalFunction.getDayFromRange(shard.getTemporalRange().get());
            shardsByDaysBuilder.put((Object)day, shard);
        });
        ImmutableCollection byDays = shardsByDaysBuilder.build().asMap().values();
        if (tableInfo.getBucketCount().isEmpty()) {
            return byDays;
        }
        ImmutableList.Builder sets = ImmutableList.builder();
        for (Collection s : byDays) {
            sets.addAll((Iterable)Multimaps.index((Iterable)s, ShardIndexInfo::getBucketNumber).asMap().values());
        }
        return sets.build();
    }

    private static Optional<ShardRange> getShardRange(List<TableColumn> columns, ResultSet resultSet) throws SQLException {
        ImmutableList.Builder minValuesBuilder = ImmutableList.builder();
        ImmutableList.Builder maxValuesBuilder = ImmutableList.builder();
        ImmutableList.Builder typeBuilder = ImmutableList.builder();
        for (TableColumn tableColumn : columns) {
            long columnId = tableColumn.getColumnId();
            Type type = tableColumn.getDataType();
            Object min = ShardOrganizerUtil.getValue(resultSet, type, DatabaseShardManager.minColumn(columnId));
            Object max = ShardOrganizerUtil.getValue(resultSet, type, DatabaseShardManager.maxColumn(columnId));
            if (min == null || max == null) {
                return Optional.empty();
            }
            minValuesBuilder.add(min);
            maxValuesBuilder.add(max);
            typeBuilder.add((Object)type);
        }
        ImmutableList types = typeBuilder.build();
        Tuple minTuple = new Tuple((List<Type>)types, (List<Object>)minValuesBuilder.build());
        Tuple maxTuple = new Tuple((List<Type>)types, (List<Object>)maxValuesBuilder.build());
        return Optional.of(ShardRange.of(minTuple, maxTuple));
    }

    private static Object getValue(ResultSet resultSet, Type type, String columnName) throws SQLException {
        JDBCType jdbcType = ColumnIndexStatsUtils.jdbcType(type);
        Object value = ShardOrganizerUtil.getValue(resultSet, type, columnName, jdbcType);
        return resultSet.wasNull() ? null : value;
    }

    private static Object getValue(ResultSet resultSet, Type type, String columnName, JDBCType jdbcType) throws SQLException {
        switch (jdbcType) {
            case BOOLEAN: {
                return resultSet.getBoolean(columnName);
            }
            case INTEGER: {
                return resultSet.getInt(columnName);
            }
            case BIGINT: {
                return resultSet.getLong(columnName);
            }
            case DOUBLE: {
                return resultSet.getDouble(columnName);
            }
            case VARBINARY: {
                return Slices.wrappedBuffer((byte[])resultSet.getBytes(columnName)).toStringUtf8();
            }
        }
        throw new IllegalArgumentException("Unhandled type: " + type);
    }

    static OrganizationSet createOrganizationSet(long tableId, Set<ShardIndexInfo> shardsToCompact) {
        Set<UUID> uuids = shardsToCompact.stream().map(ShardIndexInfo::getShardUuid).collect(Collectors.toSet());
        Set bucketNumber = shardsToCompact.stream().map(ShardIndexInfo::getBucketNumber).collect(Collectors.toSet());
        Preconditions.checkArgument((bucketNumber.size() == 1 ? 1 : 0) != 0);
        return new OrganizationSet(tableId, uuids, (OptionalInt)Iterables.getOnlyElement(bucketNumber));
    }
}

