/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy.systemtables;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import com.google.inject.Inject;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.plugin.raptor.legacy.RaptorErrorCode;
import io.trino.plugin.raptor.legacy.metadata.ColumnMetadataRow;
import io.trino.plugin.raptor.legacy.metadata.ForMetadata;
import io.trino.plugin.raptor.legacy.metadata.MetadataDao;
import io.trino.plugin.raptor.legacy.metadata.TableMetadataRow;
import io.trino.plugin.raptor.legacy.systemtables.PageListBuilder;
import io.trino.plugin.raptor.legacy.util.DatabaseUtil;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.block.BlockBuilder;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.NullableValue;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.VarcharType;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.jdbi.v3.core.Jdbi;

public class TableMetadataSystemTable
implements SystemTable {
    private static final String TABLE_NAME = "table_name";
    private static final String SCHEMA_NAME = "table_schema";
    private final MetadataDao dao;
    private final ConnectorTableMetadata tableMetadata;

    @Inject
    public TableMetadataSystemTable(@ForMetadata Jdbi dbi, TypeManager typeManager) {
        this.dao = DatabaseUtil.onDemandDao(dbi, MetadataDao.class);
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableMetadata = new ConnectorTableMetadata(new SchemaTableName("system", "tables"), (List)ImmutableList.of((Object)new ColumnMetadata(SCHEMA_NAME, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata(TABLE_NAME, (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("temporal_column", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("ordering_columns", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new ColumnMetadata("distribution_name", (Type)VarcharType.VARCHAR), (Object)new ColumnMetadata("bucket_count", (Type)BigintType.BIGINT), (Object)new ColumnMetadata("bucketing_columns", (Type)new ArrayType((Type)VarcharType.VARCHAR)), (Object)new ColumnMetadata("organized", (Type)BooleanType.BOOLEAN)));
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        return new FixedPageSource(TableMetadataSystemTable.buildPages(this.dao, this.tableMetadata, constraint));
    }

    private static List<Page> buildPages(MetadataDao dao, ConnectorTableMetadata tableMetadata, TupleDomain<Integer> tupleDomain) {
        Map domainValues = (Map)TupleDomain.extractFixedValues(tupleDomain).orElse(ImmutableMap.of());
        String schemaName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(tableMetadata, SCHEMA_NAME)));
        String tableName = TableMetadataSystemTable.getStringValue((NullableValue)domainValues.get(TableMetadataSystemTable.getColumnIndex(tableMetadata, TABLE_NAME)));
        PageListBuilder pageBuilder = new PageListBuilder(tableMetadata.getColumns().stream().map(ColumnMetadata::getType).collect(Collectors.toList()));
        List<TableMetadataRow> tableRows = dao.getTableMetadataRows(schemaName, tableName);
        PeekingIterator columnRowIterator = Iterators.peekingIterator(dao.getColumnMetadataRows(schemaName, tableName).iterator());
        for (TableMetadataRow tableRow : tableRows) {
            while (columnRowIterator.hasNext() && ((ColumnMetadataRow)columnRowIterator.peek()).getTableId() < tableRow.getTableId()) {
                columnRowIterator.next();
            }
            String temporalColumnName = null;
            TreeMap<Integer, String> sortColumnNames = new TreeMap<Integer, String>();
            TreeMap<Integer, String> bucketColumnNames = new TreeMap<Integer, String>();
            OptionalLong temporalColumnId = tableRow.getTemporalColumnId();
            while (columnRowIterator.hasNext() && ((ColumnMetadataRow)columnRowIterator.peek()).getTableId() == tableRow.getTableId()) {
                OptionalInt bucketOrdinalPosition;
                OptionalInt sortOrdinalPosition;
                ColumnMetadataRow columnRow = (ColumnMetadataRow)columnRowIterator.next();
                if (temporalColumnId.isPresent() && columnRow.getColumnId() == temporalColumnId.getAsLong()) {
                    temporalColumnName = columnRow.getColumnName();
                }
                if ((sortOrdinalPosition = columnRow.getSortOrdinalPosition()).isPresent()) {
                    sortColumnNames.put(sortOrdinalPosition.getAsInt(), columnRow.getColumnName());
                }
                if (!(bucketOrdinalPosition = columnRow.getBucketOrdinalPosition()).isPresent()) continue;
                bucketColumnNames.put(bucketOrdinalPosition.getAsInt(), columnRow.getColumnName());
            }
            pageBuilder.beginRow();
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)tableRow.getSchemaName()));
            VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)tableRow.getTableName()));
            if (temporalColumnId.isPresent()) {
                if (temporalColumnName == null) {
                    throw new TrinoException((ErrorCodeSupplier)RaptorErrorCode.RAPTOR_CORRUPT_METADATA, String.format("Table ID %s has corrupt metadata (invalid temporal column ID)", tableRow.getTableId()));
                }
                VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)temporalColumnName));
            } else {
                pageBuilder.nextBlockBuilder().appendNull();
            }
            TableMetadataSystemTable.writeArray(pageBuilder.nextBlockBuilder(), sortColumnNames.values());
            Optional<String> distributionName = tableRow.getDistributionName();
            if (distributionName.isPresent()) {
                VarcharType.VARCHAR.writeSlice(pageBuilder.nextBlockBuilder(), Slices.utf8Slice((String)distributionName.get()));
            } else {
                pageBuilder.nextBlockBuilder().appendNull();
            }
            OptionalInt bucketCount = tableRow.getBucketCount();
            if (bucketCount.isPresent()) {
                BigintType.BIGINT.writeLong(pageBuilder.nextBlockBuilder(), (long)bucketCount.getAsInt());
            } else {
                pageBuilder.nextBlockBuilder().appendNull();
            }
            TableMetadataSystemTable.writeArray(pageBuilder.nextBlockBuilder(), bucketColumnNames.values());
            BooleanType.BOOLEAN.writeBoolean(pageBuilder.nextBlockBuilder(), tableRow.isOrganized());
        }
        return pageBuilder.build();
    }

    private static void writeArray(BlockBuilder blockBuilder, Collection<String> values) {
        if (values.isEmpty()) {
            blockBuilder.appendNull();
        } else {
            BlockBuilder array = blockBuilder.beginBlockEntry();
            for (String value : values) {
                VarcharType.VARCHAR.writeSlice(array, Slices.utf8Slice((String)value));
            }
            blockBuilder.closeEntry();
        }
    }

    static int getColumnIndex(ConnectorTableMetadata tableMetadata, String columnName) {
        List columns = tableMetadata.getColumns();
        for (int i = 0; i < columns.size(); ++i) {
            if (!((ColumnMetadata)columns.get(i)).getName().equals(columnName)) continue;
            return i;
        }
        throw new IllegalArgumentException(String.format("Column '%s' not found", columnName));
    }

    static String getStringValue(NullableValue value) {
        if (value == null || value.isNull()) {
            return null;
        }
        return ((Slice)value.getValue()).toStringUtf8();
    }
}

