/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.raptor.legacy;

import com.google.inject.Inject;
import io.airlift.units.DataSize;
import io.trino.plugin.raptor.legacy.RaptorColumnHandle;
import io.trino.plugin.raptor.legacy.RaptorInsertTableHandle;
import io.trino.plugin.raptor.legacy.RaptorMergeSink;
import io.trino.plugin.raptor.legacy.RaptorMergeTableHandle;
import io.trino.plugin.raptor.legacy.RaptorOutputTableHandle;
import io.trino.plugin.raptor.legacy.RaptorPageSink;
import io.trino.plugin.raptor.legacy.storage.StorageManager;
import io.trino.plugin.raptor.legacy.storage.StorageManagerConfig;
import io.trino.spi.PageSorter;
import io.trino.spi.connector.ConnectorInsertTableHandle;
import io.trino.spi.connector.ConnectorMergeSink;
import io.trino.spi.connector.ConnectorMergeTableHandle;
import io.trino.spi.connector.ConnectorOutputTableHandle;
import io.trino.spi.connector.ConnectorPageSink;
import io.trino.spi.connector.ConnectorPageSinkId;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class RaptorPageSinkProvider
implements ConnectorPageSinkProvider {
    private final StorageManager storageManager;
    private final PageSorter pageSorter;
    private final DataSize maxBufferSize;

    @Inject
    public RaptorPageSinkProvider(StorageManager storageManager, PageSorter pageSorter, StorageManagerConfig config) {
        this.storageManager = Objects.requireNonNull(storageManager, "storageManager is null");
        this.pageSorter = Objects.requireNonNull(pageSorter, "pageSorter is null");
        this.maxBufferSize = config.getMaxBufferSize();
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorOutputTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        RaptorOutputTableHandle handle = (RaptorOutputTableHandle)tableHandle;
        return new RaptorPageSink(this.pageSorter, this.storageManager, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), handle.getTemporalColumnHandle(), this.maxBufferSize);
    }

    public ConnectorPageSink createPageSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorInsertTableHandle tableHandle, ConnectorPageSinkId pageSinkId) {
        RaptorInsertTableHandle handle = (RaptorInsertTableHandle)tableHandle;
        return new RaptorPageSink(this.pageSorter, this.storageManager, handle.getTransactionId(), RaptorPageSinkProvider.toColumnIds(handle.getColumnHandles()), handle.getColumnTypes(), RaptorPageSinkProvider.toColumnIds(handle.getSortColumnHandles()), handle.getSortOrders(), handle.getBucketCount(), RaptorPageSinkProvider.toColumnIds(handle.getBucketColumnHandles()), handle.getTemporalColumnHandle(), this.maxBufferSize);
    }

    public ConnectorMergeSink createMergeSink(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorMergeTableHandle mergeHandle, ConnectorPageSinkId pageSinkId) {
        RaptorMergeTableHandle merge = (RaptorMergeTableHandle)mergeHandle;
        ConnectorPageSink pageSink = this.createPageSink(transactionHandle, session, merge.getInsertTableHandle(), pageSinkId);
        long transactionId = merge.getInsertTableHandle().getTransactionId();
        int columnCount = merge.getInsertTableHandle().getColumnHandles().size();
        return new RaptorMergeSink(pageSink, this.storageManager, transactionId, columnCount);
    }

    private static List<Long> toColumnIds(List<RaptorColumnHandle> columnHandles) {
        return columnHandles.stream().map(RaptorColumnHandle::getColumnId).collect(Collectors.toList());
    }
}

