/*
 * Decompiled with CFR 0.152.
 */
package org.jdbi.v3.core.statement;

import java.lang.reflect.Type;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jdbi.v3.core.Handle;
import org.jdbi.v3.core.argument.Argument;
import org.jdbi.v3.core.argument.Arguments;
import org.jdbi.v3.core.argument.NamedArgumentFinder;
import org.jdbi.v3.core.argument.internal.NamedArgumentFinderFactory;
import org.jdbi.v3.core.qualifier.QualifiedType;
import org.jdbi.v3.core.result.BatchResultBearing;
import org.jdbi.v3.core.result.ResultBearing;
import org.jdbi.v3.core.result.ResultIterator;
import org.jdbi.v3.core.result.ResultProducer;
import org.jdbi.v3.core.result.ResultProducers;
import org.jdbi.v3.core.result.ResultSetScanner;
import org.jdbi.v3.core.result.UnableToProduceResultException;
import org.jdbi.v3.core.statement.ArgumentBinder;
import org.jdbi.v3.core.statement.Batch;
import org.jdbi.v3.core.statement.Binding;
import org.jdbi.v3.core.statement.ParsedParameters;
import org.jdbi.v3.core.statement.ParsedSql;
import org.jdbi.v3.core.statement.SqlLoggerUtil;
import org.jdbi.v3.core.statement.SqlStatement;
import org.jdbi.v3.core.statement.SqlStatements;
import org.jdbi.v3.core.statement.StatementContext;
import org.jdbi.v3.core.statement.UnableToCreateStatementException;
import org.jdbi.v3.core.statement.UnableToExecuteStatementException;
import org.jdbi.v3.core.statement.internal.PreparedBinding;

public class PreparedBatch
extends SqlStatement<PreparedBatch>
implements ResultBearing {
    private final List<PreparedBinding> bindings = new ArrayList<PreparedBinding>();
    final Map<NamedArgumentFinderFactory.PrepareKey, Function<String, Optional<Function<Object, Argument>>>> preparedFinders = new HashMap<NamedArgumentFinderFactory.PrepareKey, Function<String, Optional<Function<Object, Argument>>>>();

    public PreparedBatch(Handle handle, CharSequence sql) {
        super(handle, sql);
        this.getContext().setBinding(new PreparedBinding(this.getContext()));
    }

    public PreparedBatch(Handle handle, String sql) {
        super(handle, sql);
    }

    @Override
    PreparedBatch bindNamedArgumentFinder(NamedArgumentFinderFactory factory, String prefix, Object value, Type type, Supplier<NamedArgumentFinder> backupArgumentFinder) {
        PreparedBinding binding = this.getBinding();
        NamedArgumentFinderFactory.PrepareKey key = factory.keyFor(prefix, value);
        this.preparedFinders.computeIfAbsent(key, pk -> factory.prepareFor(this.getConfig(), this::buildArgument, prefix, value, type));
        binding.prepareKeys.put(key, value);
        binding.backupArgumentFinders.add(backupArgumentFinder);
        return this;
    }

    @Override
    protected PreparedBinding getBinding() {
        return (PreparedBinding)super.getBinding();
    }

    Function<Object, Argument> buildArgument(QualifiedType<?> type) {
        return this.getContext().getConfig(Arguments.class).prepareFor(type).orElse(value -> (pos, st, ctx) -> ctx.getConfig(Arguments.class).findFor(type, value).orElseThrow(() -> new UnableToCreateStatementException("no argument factory for type " + type, ctx)).apply(pos, st, ctx));
    }

    @Override
    public <R> R scanResultSet(ResultSetScanner<R> resultSetScanner) {
        return this.execute(ResultProducers.returningResults()).scanResultSet(resultSetScanner);
    }

    public int[] execute() {
        try {
            int[] nArray = this.internalBatchExecute().updateCounts;
            return nArray;
        }
        finally {
            this.close();
        }
    }

    public ResultIterator<Integer> executeAndGetModCount() {
        final StatementContext ctx = this.getContext();
        final int[] modCount = this.execute();
        return new ResultIterator<Integer>(){
            int pos = 0;

            @Override
            public boolean hasNext() {
                return this.pos < modCount.length;
            }

            @Override
            public Integer next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return modCount[this.pos++];
            }

            @Override
            public StatementContext getContext() {
                return ctx;
            }

            @Override
            public void close() {
                ctx.close();
            }
        };
    }

    @Deprecated
    public ResultBearing executeAndReturnGeneratedKeys(String ... columnNames) {
        return this.execute(ResultProducers.returningGeneratedKeys(columnNames));
    }

    public BatchResultBearing executePreparedBatch(String ... columnNames) {
        ExecutedBatchConsumer executedBatchConsumer = new ExecutedBatchConsumer();
        ResultBearing resultBearing = this.execute(ResultProducers.returningGeneratedKeys(columnNames), executedBatchConsumer);
        return new BatchResultBearing(resultBearing, executedBatchConsumer);
    }

    public <R> R execute(ResultProducer<R> producer) {
        return this.execute(producer, x -> {});
    }

    private <R> R execute(ResultProducer<R> producer, Consumer<ExecutedBatch> batchConsumer) {
        try {
            return producer.produce(() -> {
                ExecutedBatch executedBatch = this.internalBatchExecute();
                batchConsumer.accept(executedBatch);
                return executedBatch.stmt;
            }, this.getContext());
        }
        catch (SQLException e) {
            this.cleanUpForException(e);
            throw new UnableToProduceResultException("Exception producing batch result", e, this.getContext());
        }
    }

    private ExecutedBatch internalBatchExecute() {
        if (!this.getBinding().isEmpty()) {
            this.add();
        }
        this.beforeTemplating();
        StatementContext ctx = this.getContext();
        ParsedSql parsedSql = this.parseSql();
        String sql = parsedSql.getSql();
        ParsedParameters parsedParameters = parsedSql.getParameters();
        try {
            try {
                this.stmt = this.createStatement(sql);
                this.getContext().addCleanable(() -> this.cleanupStatement(this.stmt));
                this.getConfig(SqlStatements.class).customize(this.stmt);
            }
            catch (SQLException e) {
                throw new UnableToCreateStatementException(e, ctx);
            }
            if (this.bindings.isEmpty()) {
                ExecutedBatch e = new ExecutedBatch(this.stmt, new int[0]);
                return e;
            }
            this.beforeBinding();
            try {
                ArgumentBinder.Prepared binder = new ArgumentBinder.Prepared(this, parsedParameters, this.bindings.get(0));
                for (Binding binding : this.bindings) {
                    ctx.setBinding(binding);
                    binder.bind(binding);
                    this.stmt.addBatch();
                }
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException("Exception while binding parameters", e, ctx);
            }
            this.beforeExecution();
            try {
                int[] modifiedRows = SqlLoggerUtil.wrap(this.stmt::executeBatch, ctx, this.getConfig(SqlStatements.class).getSqlLogger());
                this.afterExecution();
                ctx.setBinding(new PreparedBinding(ctx));
                ExecutedBatch executedBatch = new ExecutedBatch(this.stmt, modifiedRows);
                return executedBatch;
            }
            catch (SQLException e) {
                throw new UnableToExecuteStatementException(Batch.mungeBatchException(e), ctx);
            }
        }
        finally {
            this.bindings.clear();
        }
    }

    public PreparedBatch add() {
        PreparedBinding currentBinding = this.getBinding();
        if (currentBinding.isEmpty()) {
            throw new IllegalStateException("Attempt to add() an empty batch, you probably didn't mean to do this - call add() *after* setting batch parameters");
        }
        this.bindings.add(currentBinding);
        this.getContext().setBinding(new PreparedBinding(this.getContext()));
        return this;
    }

    public PreparedBatch add(Object ... args) {
        for (int i = 0; i < args.length; ++i) {
            this.bind(i, args[i]);
        }
        this.add();
        return this;
    }

    public PreparedBatch add(Map<String, ?> args) {
        this.bindMap(args);
        this.add();
        return this;
    }

    public int size() {
        return this.bindings.size();
    }

    private static class ExecutedBatch {
        final PreparedStatement stmt;
        final int[] updateCounts;

        ExecutedBatch(PreparedStatement stmt, int[] updateCounts) {
            this.stmt = stmt;
            this.updateCounts = Arrays.copyOf(updateCounts, updateCounts.length);
        }
    }

    private static final class ExecutedBatchConsumer
    implements Consumer<ExecutedBatch>,
    Supplier<int[]> {
        private int[] modifiedRowCounts = new int[0];

        private ExecutedBatchConsumer() {
        }

        @Override
        public void accept(ExecutedBatch executedBatch) {
            this.modifiedRowCounts = executedBatch.updateCounts;
        }

        @Override
        public int[] get() {
            return this.modifiedRowCounts;
        }
    }
}

