/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.fsdataset;

import io.trino.hadoop.$internal.org.slf4j.Logger;
import java.io.Closeable;
import java.io.FileDescriptor;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.FileIoProvider;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.nativeio.NativeIOException;
import org.apache.hadoop.util.DataChecksum;

public class ReplicaOutputStreams
implements Closeable {
    public static final Logger LOG = DataNode.LOG;
    private FileDescriptor outFd = null;
    private OutputStream dataOut;
    private final OutputStream checksumOut;
    private final DataChecksum checksum;
    private final FsVolumeSpi volume;
    private final FileIoProvider fileIoProvider;

    public ReplicaOutputStreams(OutputStream dataOut, OutputStream checksumOut, DataChecksum checksum, FsVolumeSpi volume, FileIoProvider fileIoProvider) {
        this.dataOut = dataOut;
        this.checksum = checksum;
        this.checksumOut = checksumOut;
        this.volume = volume;
        this.fileIoProvider = fileIoProvider;
        try {
            if (this.dataOut instanceof FileOutputStream) {
                this.outFd = ((FileOutputStream)this.dataOut).getFD();
            } else {
                LOG.debug("Could not get file descriptor for outputstream of class " + this.dataOut.getClass());
            }
        }
        catch (IOException e) {
            LOG.warn("Could not get file descriptor for outputstream of class " + this.dataOut.getClass());
        }
    }

    public FileDescriptor getOutFd() {
        return this.outFd;
    }

    public OutputStream getDataOut() {
        return this.dataOut;
    }

    public OutputStream getChecksumOut() {
        return this.checksumOut;
    }

    public DataChecksum getChecksum() {
        return this.checksum;
    }

    public boolean isTransientStorage() {
        return this.volume.isTransientStorage();
    }

    @Override
    public void close() {
        IOUtils.closeStream(this.dataOut);
        IOUtils.closeStream(this.checksumOut);
    }

    public void closeDataStream() throws IOException {
        this.dataOut.close();
        this.dataOut = null;
    }

    public void syncDataOut() throws IOException {
        if (this.dataOut instanceof FileOutputStream) {
            this.fileIoProvider.sync(this.volume, (FileOutputStream)this.dataOut);
        }
    }

    public void syncChecksumOut() throws IOException {
        if (this.checksumOut instanceof FileOutputStream) {
            this.fileIoProvider.sync(this.volume, (FileOutputStream)this.checksumOut);
        }
    }

    public void flushDataOut() throws IOException {
        if (this.dataOut != null) {
            this.fileIoProvider.flush(this.volume, this.dataOut);
        }
    }

    public void flushChecksumOut() throws IOException {
        if (this.checksumOut != null) {
            this.fileIoProvider.flush(this.volume, this.checksumOut);
        }
    }

    public void writeDataToDisk(byte[] b, int off, int len) throws IOException {
        this.dataOut.write(b, off, len);
    }

    public void syncFileRangeIfPossible(long offset, long nbytes, int flags) throws NativeIOException {
        this.fileIoProvider.syncFileRange(this.volume, this.outFd, offset, nbytes, flags);
    }

    public void dropCacheBehindWrites(String identifier, long offset, long len, int flags) throws NativeIOException {
        this.fileIoProvider.posixFadvise(this.volume, identifier, this.outFd, offset, len, flags);
    }
}

