/*
 * Decompiled with CFR 0.152.
 */
package io.trino.filesystem.local;

import io.trino.filesystem.Location;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.NoSuchFileException;

final class LocalUtils {
    private LocalUtils() {
    }

    static IOException handleException(Location location, IOException exception) throws IOException {
        if (exception instanceof NoSuchFileException) {
            throw new FileNotFoundException(location.toString());
        }
        if (exception instanceof FileAlreadyExistsException) {
            throw new FileAlreadyExistsException(location.toString());
        }
        throw new IOException(exception.getMessage() + ": " + location, exception);
    }
}

