/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.trino.orc.DiskRange;
import io.trino.orc.OrcCorruptionException;
import io.trino.orc.OrcDataSource;
import io.trino.orc.OrcDataSourceId;
import io.trino.orc.OrcDataSourceUtils;
import io.trino.orc.OrcReaderOptions;
import io.trino.orc.stream.AbstractDiskOrcDataReader;
import io.trino.orc.stream.MemoryOrcDataReader;
import io.trino.orc.stream.OrcDataReader;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class AbstractOrcDataSource
implements OrcDataSource {
    private final OrcDataSourceId id;
    private final long estimatedSize;
    private final OrcReaderOptions options;
    private long readTimeNanos;
    private long readBytes;

    public AbstractOrcDataSource(OrcDataSourceId id, long estimatedSize, OrcReaderOptions options) {
        this.id = Objects.requireNonNull(id, "id is null");
        this.estimatedSize = estimatedSize;
        this.options = Objects.requireNonNull(options, "options is null");
    }

    protected Slice readTailInternal(int length) throws IOException {
        return this.readFully(this.estimatedSize - (long)length, length);
    }

    protected abstract void readInternal(long var1, byte[] var3, int var4, int var5) throws IOException;

    @Override
    public OrcDataSourceId getId() {
        return this.id;
    }

    @Override
    public final long getReadBytes() {
        return this.readBytes;
    }

    @Override
    public final long getReadTimeNanos() {
        return this.readTimeNanos;
    }

    @Override
    public final long getEstimatedSize() {
        return this.estimatedSize;
    }

    @Override
    public Slice readTail(int length) throws IOException {
        long start = System.nanoTime();
        Slice tailSlice = this.readTailInternal(length);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)tailSlice.length();
        return tailSlice;
    }

    @Override
    public long getRetainedSize() {
        return 0L;
    }

    @Override
    public final Slice readFully(long position, int length) throws IOException {
        byte[] buffer = new byte[length];
        this.readFully(position, buffer, 0, length);
        return Slices.wrappedBuffer((byte[])buffer);
    }

    private void readFully(long position, byte[] buffer, int bufferOffset, int bufferLength) throws IOException {
        long start = System.nanoTime();
        this.readInternal(position, buffer, bufferOffset, bufferLength);
        this.readTimeNanos += System.nanoTime() - start;
        this.readBytes += (long)bufferLength;
    }

    @Override
    public final <K> Map<K, OrcDataReader> readFully(Map<K, DiskRange> diskRanges) throws IOException {
        Objects.requireNonNull(diskRanges, "diskRanges is null");
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        long maxReadSizeBytes = this.options.getMaxBufferSize().toBytes();
        ImmutableMap.Builder smallRangesBuilder = ImmutableMap.builder();
        ImmutableMap.Builder largeRangesBuilder = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            if ((long)entry.getValue().getLength() <= maxReadSizeBytes) {
                smallRangesBuilder.put(entry);
                continue;
            }
            largeRangesBuilder.put(entry);
        }
        ImmutableMap smallRanges = smallRangesBuilder.buildOrThrow();
        ImmutableMap largeRanges = largeRangesBuilder.buildOrThrow();
        ImmutableMap.Builder slices = ImmutableMap.builder();
        slices.putAll(this.readSmallDiskRanges((Map<K, DiskRange>)smallRanges));
        slices.putAll(this.readLargeDiskRanges((Map<K, DiskRange>)largeRanges));
        return slices.buildOrThrow();
    }

    private <K> Map<K, OrcDataReader> readSmallDiskRanges(Map<K, DiskRange> diskRanges) throws IOException {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        List<DiskRange> mergedRanges = OrcDataSourceUtils.mergeAdjacentDiskRanges(diskRanges.values(), this.options.getMaxMergeDistance(), this.options.getMaxBufferSize());
        ImmutableMap.Builder slices = ImmutableMap.builder();
        if (this.options.isLazyReadSmallRanges()) {
            for (DiskRange mergedRange : mergedRanges) {
                LazyBufferLoader lazyBufferLoader = new LazyBufferLoader(mergedRange);
                for (Map.Entry<K, DiskRange> diskRangeEntry : diskRanges.entrySet()) {
                    DiskRange diskRange = diskRangeEntry.getValue();
                    if (!mergedRange.contains(diskRange)) continue;
                    slices.put(diskRangeEntry.getKey(), (Object)new MergedOrcDataReader(this.id, diskRange, lazyBufferLoader));
                }
            }
        } else {
            LinkedHashMap<DiskRange, Slice> buffers = new LinkedHashMap<DiskRange, Slice>();
            for (DiskRange diskRange : mergedRanges) {
                Slice buffer = this.readFully(diskRange.getOffset(), diskRange.getLength());
                buffers.put(diskRange, buffer);
            }
            for (Map.Entry entry : diskRanges.entrySet()) {
                slices.put(entry.getKey(), (Object)new MemoryOrcDataReader(this.id, OrcDataSourceUtils.getDiskRangeSlice((DiskRange)entry.getValue(), buffers), ((DiskRange)entry.getValue()).getLength()));
            }
        }
        ImmutableMap sliceStreams = slices.buildOrThrow();
        Verify.verify((boolean)sliceStreams.keySet().equals(diskRanges.keySet()));
        return sliceStreams;
    }

    private <K> Map<K, OrcDataReader> readLargeDiskRanges(Map<K, DiskRange> diskRanges) {
        if (diskRanges.isEmpty()) {
            return ImmutableMap.of();
        }
        ImmutableMap.Builder slices = ImmutableMap.builder();
        for (Map.Entry<K, DiskRange> entry : diskRanges.entrySet()) {
            DiskRange diskRange = entry.getValue();
            slices.put(entry.getKey(), (Object)new DiskOrcDataReader(diskRange));
        }
        return slices.buildOrThrow();
    }

    public final String toString() {
        return this.id.toString();
    }

    private final class LazyBufferLoader {
        private final DiskRange diskRange;
        private Slice bufferSlice;

        public LazyBufferLoader(DiskRange diskRange) {
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
        }

        public Slice loadNestedDiskRangeBuffer(DiskRange nestedDiskRange) {
            this.load();
            Preconditions.checkArgument((boolean)this.diskRange.contains(nestedDiskRange));
            int offset = Math.toIntExact(nestedDiskRange.getOffset() - this.diskRange.getOffset());
            return this.bufferSlice.slice(offset, nestedDiskRange.getLength());
        }

        private void load() {
            if (this.bufferSlice != null) {
                return;
            }
            try {
                this.bufferSlice = AbstractOrcDataSource.this.readFully(this.diskRange.getOffset(), this.diskRange.getLength());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private final class MergedOrcDataReader
    implements OrcDataReader {
        private final OrcDataSourceId orcDataSourceId;
        private final DiskRange diskRange;
        private final LazyBufferLoader lazyBufferLoader;
        private Slice data;

        public MergedOrcDataReader(OrcDataSourceId orcDataSourceId, DiskRange diskRange, LazyBufferLoader lazyBufferLoader) {
            this.orcDataSourceId = Objects.requireNonNull(orcDataSourceId, "orcDataSourceId is null");
            this.diskRange = Objects.requireNonNull(diskRange, "diskRange is null");
            this.lazyBufferLoader = Objects.requireNonNull(lazyBufferLoader, "lazyBufferLoader is null");
        }

        @Override
        public OrcDataSourceId getOrcDataSourceId() {
            return this.orcDataSourceId;
        }

        @Override
        public long getRetainedSize() {
            return this.data == null ? 0L : (long)this.diskRange.getLength();
        }

        @Override
        public int getSize() {
            return this.diskRange.getLength();
        }

        @Override
        public int getMaxBufferSize() {
            return this.diskRange.getLength();
        }

        @Override
        public Slice seekBuffer(int newPosition) throws IOException {
            if (this.data == null) {
                this.data = this.lazyBufferLoader.loadNestedDiskRangeBuffer(this.diskRange);
                if (this.data == null) {
                    throw new OrcCorruptionException(AbstractOrcDataSource.this.id, "Data loader returned null");
                }
                if (this.data.length() != this.diskRange.getLength()) {
                    throw new OrcCorruptionException(AbstractOrcDataSource.this.id, "Expected to load %s bytes, but %s bytes were loaded", this.diskRange.getLength(), this.data.length());
                }
            }
            return this.data.slice(newPosition, this.data.length() - newPosition);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("orcDataSourceId", (Object)this.orcDataSourceId).add("diskRange", (Object)this.diskRange).toString();
        }
    }

    private class DiskOrcDataReader
    extends AbstractDiskOrcDataReader {
        private final DiskRange diskRange;

        public DiskOrcDataReader(DiskRange diskRange) {
            super(AbstractOrcDataSource.this.id, diskRange.getLength(), Math.toIntExact(AbstractOrcDataSource.this.options.getStreamBufferSize().toBytes()));
            this.diskRange = diskRange;
        }

        @Override
        public void read(long position, byte[] buffer, int bufferOffset, int length) throws IOException {
            AbstractOrcDataSource.this.readFully(this.diskRange.getOffset() + position, buffer, bufferOffset, length);
        }

        @Override
        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("orcDataSourceId", (Object)this.getOrcDataSourceId()).add("diskRange", (Object)this.diskRange).add("maxBufferSize", this.getMaxBufferSize()).toString();
        }
    }
}

