/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.http.client.jetty;

import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.AbstractFuture;
import io.airlift.http.client.HttpClient;
import io.airlift.http.client.Request;
import io.airlift.http.client.RequestStats;
import io.airlift.http.client.ResponseHandler;
import io.airlift.http.client.jetty.JettyHttpClient;
import io.airlift.http.client.jetty.JettyResponse;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.semconv.trace.attributes.SemanticAttributes;
import java.io.InputStream;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.LongSupplier;
import org.eclipse.jetty.client.api.Response;

class JettyResponseFuture<T, E extends Exception>
extends AbstractFuture<T>
implements HttpClient.HttpResponseFuture<T> {
    private final long requestStart = System.nanoTime();
    private final AtomicReference<JettyAsyncHttpState> state = new AtomicReference<JettyAsyncHttpState>(JettyAsyncHttpState.WAITING_FOR_CONNECTION);
    private final Request request;
    private final org.eclipse.jetty.client.api.Request jettyRequest;
    private final LongSupplier requestSize;
    private final ResponseHandler<T, E> responseHandler;
    private final Span span;
    private final RequestStats stats;
    private final boolean recordRequestComplete;

    JettyResponseFuture(Request request, org.eclipse.jetty.client.api.Request jettyRequest, LongSupplier requestSize, ResponseHandler<T, E> responseHandler, Span span, RequestStats stats, boolean recordRequestComplete) {
        this.request = Objects.requireNonNull(request, "request is null");
        this.jettyRequest = Objects.requireNonNull(jettyRequest, "jettyRequest is null");
        this.requestSize = Objects.requireNonNull(requestSize, "requestSize is null");
        this.responseHandler = Objects.requireNonNull(responseHandler, "responseHandler is null");
        this.span = Objects.requireNonNull(span, "span is null");
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.recordRequestComplete = recordRequestComplete;
    }

    @Override
    public String getState() {
        return this.state.get().toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        try {
            this.span.setStatus(StatusCode.ERROR, "cancelled");
            this.stats.recordRequestCanceled();
            this.state.set(JettyAsyncHttpState.CANCELED);
            this.jettyRequest.abort((Throwable)new CancellationException());
            boolean bl = super.cancel(mayInterruptIfRunning);
            return bl;
        }
        catch (Throwable e) {
            this.setException(e);
            boolean bl = true;
            return bl;
        }
        finally {
            this.span.end();
        }
    }

    void completed(Response response, InputStream content) {
        T value;
        if (this.state.get() == JettyAsyncHttpState.CANCELED) {
            return;
        }
        this.span.setAttribute(SemanticAttributes.HTTP_STATUS_CODE, response.getStatus());
        if (this.request.getBodyGenerator() != null) {
            this.span.setAttribute(SemanticAttributes.HTTP_REQUEST_CONTENT_LENGTH, (Object)this.requestSize.getAsLong());
        }
        try {
            value = this.processResponse(response, content);
        }
        catch (Throwable e) {
            this.storeException(e);
            return;
        }
        this.state.set(JettyAsyncHttpState.DONE);
        this.set(value);
        this.span.setStatus(StatusCode.OK);
        this.span.end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T processResponse(Response response, InputStream content) throws E {
        T value;
        long responseStart = System.nanoTime();
        this.state.set(JettyAsyncHttpState.PROCESSING_RESPONSE);
        JettyResponse jettyResponse = null;
        try {
            jettyResponse = new JettyResponse(response, content);
            value = this.responseHandler.handle(this.request, jettyResponse);
        }
        finally {
            if (jettyResponse != null) {
                this.span.setAttribute(SemanticAttributes.HTTP_RESPONSE_CONTENT_LENGTH, (Object)jettyResponse.getBytesRead());
            }
            if (this.recordRequestComplete) {
                JettyHttpClient.recordRequestComplete(this.stats, this.request, this.requestSize.getAsLong(), this.requestStart, jettyResponse, responseStart);
            }
        }
        return value;
    }

    void failed(Throwable throwable) {
        if (this.state.get() == JettyAsyncHttpState.CANCELED) {
            return;
        }
        this.stats.recordRequestFailed();
        if (throwable instanceof Exception) {
            try {
                T value = this.responseHandler.handleException(this.request, (Exception)throwable);
                this.state.set(JettyAsyncHttpState.DONE);
                this.set(value);
                return;
            }
            catch (Throwable newThrowable) {
                throwable = newThrowable;
            }
        }
        this.storeException(throwable);
    }

    private void storeException(Throwable throwable) {
        if (throwable instanceof CancellationException) {
            this.state.set(JettyAsyncHttpState.CANCELED);
        } else {
            this.state.set(JettyAsyncHttpState.FAILED);
        }
        if (throwable == null) {
            throwable = new Throwable("Throwable is null");
        }
        this.setException(throwable);
        this.span.setStatus(StatusCode.ERROR, throwable.getMessage());
        this.span.recordException(throwable, Attributes.of((AttributeKey)SemanticAttributes.EXCEPTION_ESCAPED, (Object)true));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("requestStart", this.requestStart).add("state", this.state).add("request", (Object)this.request).toString();
    }

    private static enum JettyAsyncHttpState {
        WAITING_FOR_CONNECTION,
        PROCESSING_RESPONSE,
        DONE,
        FAILED,
        CANCELED;

    }
}

