/*
 * Decompiled with CFR 0.152.
 */
package io.trino.re2j;

import io.airlift.slice.Slice;
import io.trino.re2j.RE2;
import io.trino.re2j.Utils;

final class MachineInput {
    static final byte EOF = -1;
    final Slice slice;
    final byte[] base;
    final int offset;
    final int length;

    static MachineInput fromUTF8(Slice slice) {
        return new MachineInput(slice);
    }

    MachineInput(Slice slice) {
        this.slice = slice;
        this.base = slice.byteArray();
        this.offset = slice.byteArrayOffset();
        this.length = slice.length();
    }

    byte getByte(int i) {
        if (i >= this.length) {
            return -1;
        }
        if (i < 0) {
            throw new IndexOutOfBoundsException("index less than zero (" + i + ")");
        }
        return this.getByteUnchecked(i);
    }

    byte getByteUnchecked(int i) {
        return this.base[this.offset + i];
    }

    int index(RE2 re2, int pos) {
        int i = Utils.indexOf(this.slice, re2.prefixUTF8, pos);
        return i < 0 ? i : i - pos;
    }

    int endPos() {
        return this.length;
    }
}

