/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.MapType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import io.trino.testing.TestingConnectorSession;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericEnumSymbol;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Fail;
import org.assertj.core.api.ObjectAssert;

public final class AvroDecoderTestUtil {
    private AvroDecoderTestUtil() {
    }

    private static void checkPrimitiveValue(Object actual, Object expected) {
        if (actual == null || expected == null) {
            Assertions.assertThat((Object)expected).isNull();
            Assertions.assertThat((Object)actual).isNull();
        } else if (actual instanceof CharSequence) {
            Assertions.assertThat((expected instanceof CharSequence || expected instanceof GenericEnumSymbol ? 1 : 0) != 0).isTrue();
            Assertions.assertThat((String)actual.toString()).isEqualTo(expected.toString());
        } else if (actual instanceof SqlVarbinary) {
            SqlVarbinary sqlVarbinary = (SqlVarbinary)actual;
            if (expected instanceof GenericFixed) {
                GenericFixed genericFixed = (GenericFixed)expected;
                Assertions.assertThat((byte[])sqlVarbinary.getBytes()).isEqualTo((Object)genericFixed.bytes());
            } else if (expected instanceof ByteBuffer) {
                ByteBuffer byteBuffer = (ByteBuffer)expected;
                Assertions.assertThat((Comparable)ByteBuffer.wrap(sqlVarbinary.getBytes())).isEqualTo((Object)byteBuffer);
            } else {
                Fail.fail((String)String.format("Unexpected value type %s", actual.getClass()));
            }
        } else if (AvroDecoderTestUtil.isIntegralType(actual) && AvroDecoderTestUtil.isIntegralType(expected)) {
            Assertions.assertThat((long)((Number)actual).longValue()).isEqualTo(((Number)expected).longValue());
        } else if (AvroDecoderTestUtil.isRealType(actual) && AvroDecoderTestUtil.isRealType(expected)) {
            Assertions.assertThat((double)((Number)actual).doubleValue()).isEqualTo(((Number)expected).doubleValue());
        } else {
            Assertions.assertThat((Object)actual).isEqualTo(expected);
        }
    }

    private static boolean isIntegralType(Object value) {
        return value instanceof Long || value instanceof Integer || value instanceof Short || value instanceof Byte;
    }

    private static boolean isRealType(Object value) {
        return value instanceof Float || value instanceof Double;
    }

    public static void checkArrayValues(Block block, Type type, Object value) {
        ((ObjectAssert)Assertions.assertThat((Object)type).describedAs("Type is null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(type instanceof ArrayType)).describedAs("Unexpected type", new Object[0])).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)block).describedAs("Block is null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)value).describedAs("Value is null", new Object[0])).isNotNull();
        List list = (List)value;
        Assertions.assertThat((int)block.getPositionCount()).isEqualTo(list.size());
        Type elementType = ((ArrayType)type).getElementType();
        for (int index = 0; index < block.getPositionCount(); ++index) {
            if (block.isNull(index)) {
                Assertions.assertThat(list.get(index)).isNull();
                continue;
            }
            if (elementType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)elementType;
                AvroDecoderTestUtil.checkArrayValues(arrayType.getObject(block, index), elementType, list.get(index));
                continue;
            }
            if (elementType instanceof MapType) {
                MapType mapType = (MapType)elementType;
                AvroDecoderTestUtil.checkMapValues(mapType.getObject(block, index), elementType, list.get(index));
                continue;
            }
            if (elementType instanceof RowType) {
                RowType rowType = (RowType)elementType;
                AvroDecoderTestUtil.checkRowValues(rowType.getObject(block, index), elementType, list.get(index));
                continue;
            }
            AvroDecoderTestUtil.checkPrimitiveValue(elementType.getObjectValue(TestingConnectorSession.SESSION, block, index), list.get(index));
        }
    }

    public static void checkMapValues(SqlMap sqlMap, Type type, Object value) {
        ((ObjectAssert)Assertions.assertThat((Object)type).describedAs("Type is null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(type instanceof MapType)).describedAs("Unexpected type", new Object[0])).isTrue();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(((MapType)type).getKeyType() instanceof VarcharType)).describedAs("Unexpected key type", new Object[0])).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)sqlMap).describedAs("sqlMap is null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)value).describedAs("Value is null", new Object[0])).isNotNull();
        Map expected = (Map)value;
        int rawOffset = sqlMap.getRawOffset();
        Block rawKeyBlock = sqlMap.getRawKeyBlock();
        Block rawValueBlock = sqlMap.getRawValueBlock();
        Assertions.assertThat((int)sqlMap.getSize()).isEqualTo(expected.size());
        Type valueType = ((MapType)type).getValueType();
        for (int index = 0; index < sqlMap.getSize(); ++index) {
            String actualKey = VarcharType.VARCHAR.getSlice(rawKeyBlock, rawOffset + index).toStringUtf8();
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)expected.containsKey(actualKey)).describedAs("Key not found: %s".formatted(actualKey), new Object[0])).isTrue();
            if (rawValueBlock.isNull(rawOffset + index)) {
                Assertions.assertThat(expected.get(actualKey)).isNull();
                continue;
            }
            if (valueType instanceof ArrayType) {
                ArrayType arrayType = (ArrayType)valueType;
                AvroDecoderTestUtil.checkArrayValues(arrayType.getObject(rawValueBlock, rawOffset + index), valueType, expected.get(actualKey));
                continue;
            }
            if (valueType instanceof MapType) {
                MapType mapType = (MapType)valueType;
                AvroDecoderTestUtil.checkMapValues(mapType.getObject(rawValueBlock, rawOffset + index), valueType, expected.get(actualKey));
                continue;
            }
            if (valueType instanceof RowType) {
                RowType rowType = (RowType)valueType;
                AvroDecoderTestUtil.checkRowValues(rowType.getObject(rawValueBlock, rawOffset + index), valueType, expected.get(actualKey));
                continue;
            }
            AvroDecoderTestUtil.checkPrimitiveValue(valueType.getObjectValue(TestingConnectorSession.SESSION, rawValueBlock, rawOffset + index), expected.get(actualKey));
        }
    }

    public static void checkRowValues(SqlRow sqlRow, Type type, Object value) {
        ((ObjectAssert)Assertions.assertThat((Object)type).describedAs("Type is null", new Object[0])).isNotNull();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)(type instanceof RowType)).describedAs("Unexpected type", new Object[0])).isTrue();
        ((ObjectAssert)Assertions.assertThat((Object)sqlRow).describedAs("sqlRow is null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)value).describedAs("Value is null", new Object[0])).isNotNull();
        GenericRecord record = (GenericRecord)value;
        RowType rowType = (RowType)type;
        ((AbstractIntegerAssert)Assertions.assertThat((int)record.getSchema().getFields().size()).describedAs("Avro field size mismatch", new Object[0])).isEqualTo(rowType.getFields().size());
        ((AbstractIntegerAssert)Assertions.assertThat((int)sqlRow.getFieldCount()).describedAs("Trino type field size mismatch", new Object[0])).isEqualTo(rowType.getFields().size());
        int rawIndex = sqlRow.getRawIndex();
        for (int fieldIndex = 0; fieldIndex < rowType.getFields().size(); ++fieldIndex) {
            RowType.Field rowField = (RowType.Field)rowType.getFields().get(fieldIndex);
            Object expectedValue = record.get((String)rowField.getName().orElseThrow());
            Block fieldBlock = sqlRow.getRawFieldBlock(fieldIndex);
            if (fieldBlock.isNull(rawIndex)) {
                Assertions.assertThat((Object)expectedValue).isNull();
                continue;
            }
            AvroDecoderTestUtil.checkField(fieldBlock, rowField.getType(), rawIndex, expectedValue);
        }
    }

    private static void checkField(Block actualBlock, Type type, int position, Object expectedValue) {
        ((ObjectAssert)Assertions.assertThat((Object)type).describedAs("Type is null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)actualBlock).describedAs("actualBlock is null", new Object[0])).isNotNull();
        Assertions.assertThat((boolean)actualBlock.isNull(position)).isFalse();
        ((ObjectAssert)Assertions.assertThat((Object)expectedValue).describedAs("expectedValue is null", new Object[0])).isNotNull();
        if (type instanceof ArrayType) {
            ArrayType arrayType = (ArrayType)type;
            AvroDecoderTestUtil.checkArrayValues(arrayType.getObject(actualBlock, position), type, expectedValue);
        } else if (type instanceof MapType) {
            MapType mapType = (MapType)type;
            AvroDecoderTestUtil.checkMapValues(mapType.getObject(actualBlock, position), type, expectedValue);
        } else if (type instanceof RowType) {
            RowType rowType = (RowType)type;
            AvroDecoderTestUtil.checkRowValues(rowType.getObject(actualBlock, position), type, expectedValue);
        } else {
            AvroDecoderTestUtil.checkPrimitiveValue(type.getObjectValue(TestingConnectorSession.SESSION, actualBlock, position), expectedValue);
        }
    }
}

