/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.avro;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.slice.Slices;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderTestColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.avro.AvroDecoderTestUtil;
import io.trino.decoder.avro.AvroDeserializer;
import io.trino.decoder.avro.AvroFileDeserializer;
import io.trino.decoder.avro.AvroReaderSupplier;
import io.trino.decoder.avro.AvroRowDecoderFactory;
import io.trino.decoder.avro.FixedSchemaAvroReaderSupplier;
import io.trino.decoder.util.DecoderTestUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.type.InternalTypeManager;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.io.DatumWriter;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

public class TestAvroDecoder {
    private static final AvroRowDecoderFactory DECODER_FACTORY = new AvroRowDecoderFactory((AvroReaderSupplier.Factory)new FixedSchemaAvroReaderSupplier.Factory(), (AvroDeserializer.Factory)new AvroFileDeserializer.Factory());
    private static final Type VARCHAR_MAP_TYPE = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature()));
    private static final Type DOUBLE_MAP_TYPE = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)DoubleType.DOUBLE.getTypeSignature()));
    private static final Type REAL_MAP_TYPE = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)RealType.REAL.getTypeSignature()));
    private static final Type MAP_OF_REAL_MAP_TYPE = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)REAL_MAP_TYPE.getTypeSignature()));
    private static final Type MAP_OF_ARRAY_OF_MAP_TYPE = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)new ArrayType(REAL_MAP_TYPE).getTypeSignature()));
    private static final Type MAP_OF_RECORD = InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"sf1", (Type)DoubleType.DOUBLE)).add((Object)RowType.field((String)"sf2", (Type)BooleanType.BOOLEAN)).build()).getTypeSignature()));

    private static Schema getAvroSchema(Map<String, String> fields) {
        Schema.Parser parser = new Schema.Parser();
        SchemaBuilder.FieldAssembler<Schema> fieldAssembler = TestAvroDecoder.getFieldBuilder();
        block6: for (Map.Entry<String, String> field : fields.entrySet()) {
            SchemaBuilder.FieldBuilder fieldBuilder = fieldAssembler.name(field.getKey());
            Schema fieldSchema = parser.parse(field.getValue());
            SchemaBuilder.GenericDefault genericDefault = fieldBuilder.type(fieldSchema);
            switch (fieldSchema.getType()) {
                case ARRAY: {
                    genericDefault.withDefault((Object)ImmutableList.of());
                    continue block6;
                }
                case MAP: {
                    genericDefault.withDefault((Object)ImmutableMap.of());
                    continue block6;
                }
                case UNION: {
                    if (fieldSchema.getTypes().stream().map(Schema::getType).anyMatch(arg_0 -> Schema.Type.NULL.equals(arg_0))) {
                        genericDefault.withDefault(null);
                        continue block6;
                    }
                    genericDefault.noDefault();
                    continue block6;
                }
                case NULL: {
                    genericDefault.withDefault(null);
                    continue block6;
                }
            }
            genericDefault.noDefault();
        }
        return (Schema)fieldAssembler.endRecord();
    }

    private static SchemaBuilder.FieldAssembler<Schema> getFieldBuilder() {
        return ((SchemaBuilder.RecordBuilder)SchemaBuilder.record((String)"test_schema").namespace("io.trino.decoder.avro")).fields();
    }

    private Map<DecoderColumnHandle, FieldValueProvider> buildAndDecodeColumns(Set<DecoderColumnHandle> columns, Map<String, String> fieldSchema, Map<String, Object> fieldValue) {
        Schema schema = TestAvroDecoder.getAvroSchema(fieldSchema);
        byte[] avroData = TestAvroDecoder.buildAvroData(schema, fieldValue);
        return TestAvroDecoder.decodeRow(avroData, columns, (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)schema.toString()));
    }

    private Map<DecoderColumnHandle, FieldValueProvider> buildAndDecodeColumn(DecoderTestColumnHandle column, String columnName, String columnType, Object actualValue) {
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumns((Set<DecoderColumnHandle>)ImmutableSet.of((Object)column), (Map<String, String>)ImmutableMap.of((Object)columnName, (Object)columnType), (Map<String, Object>)ImmutableMap.of((Object)columnName, (Object)actualValue));
        Assertions.assertThat(decodedRow).hasSize(1);
        return decodedRow;
    }

    private static Map<DecoderColumnHandle, FieldValueProvider> decodeRow(byte[] avroData, Set<DecoderColumnHandle> columns, Map<String, String> dataParams) {
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("avro", dataParams, columns));
        return (Map)rowDecoder.decodeRow(avroData).orElseThrow(() -> new IllegalStateException("Problems during decode phase"));
    }

    private static byte[] buildAvroData(Schema schema, String name, Object value) {
        return TestAvroDecoder.buildAvroData(schema, (Map<String, Object>)ImmutableMap.of((Object)name, (Object)value));
    }

    private static byte[] buildAvroData(Schema schema, Map<String, Object> values) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        TestAvroDecoder.buildAvroRecord(schema, outputStream, values);
        return outputStream.toByteArray();
    }

    private static <V> Map<String, V> buildMapFromKeysAndValues(List<String> keys, List<V> values) {
        Assertions.assertThat(keys).hasSize(values.size());
        HashMap<String, V> map = new HashMap<String, V>();
        for (int i = 0; i < keys.size(); ++i) {
            map.put(keys.get(i), values.get(i));
        }
        return map;
    }

    private static GenericData.Record buildAvroRecord(Schema schema, ByteArrayOutputStream outputStream, Map<String, Object> values) {
        GenericData.Record record = new GenericData.Record(schema);
        values.forEach((arg_0, arg_1) -> ((GenericData.Record)record).put(arg_0, arg_1));
        try (DataFileWriter dataFileWriter = new DataFileWriter((DatumWriter)new GenericDatumWriter(schema));){
            dataFileWriter.create(schema, (OutputStream)outputStream);
            dataFileWriter.append((Object)record);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to convert to Avro.", e);
        }
        return record;
    }

    @Test
    public void testStringDecodedAsVarchar() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarcharType.VARCHAR, "string_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "string_field", "\"string\"", "Mon Jul 28 20:38:07 +0000 2014");
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "Mon Jul 28 20:38:07 +0000 2014");
    }

    @Test
    public void testEnumDecodedAsVarchar() {
        Schema schema = (Schema)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"record").fields().name("enum_field").type().enumeration("Weekday").symbols(new String[]{"Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday", "Sunday"})).noDefault().endRecord();
        Schema enumType = schema.getField("enum_field").schema();
        GenericData.EnumSymbol enumValue = new GenericData.EnumSymbol(enumType, "Wednesday");
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarcharType.VARCHAR, "enum_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "enum_field", enumType.toString(), enumValue);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "Wednesday");
    }

    @Test
    public void testSchemaEvolutionAddingColumn() {
        DecoderTestColumnHandle originalColumn = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "string_field", null, null, false, false, false);
        DecoderTestColumnHandle newlyAddedColumn = new DecoderTestColumnHandle(1, "row1", (Type)VarcharType.VARCHAR, "string_field_added", null, null, false, false, false);
        byte[] originalData = TestAvroDecoder.buildAvroData((Schema)TestAvroDecoder.getFieldBuilder().name("string_field").type().stringType().noDefault().endRecord(), "string_field", "string_field_value");
        String addedColumnSchema = ((Schema)((SchemaBuilder.FieldAssembler)TestAvroDecoder.getFieldBuilder().name("string_field").type().stringType().noDefault().name("string_field_added").type().optional().stringType()).endRecord()).toString();
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = TestAvroDecoder.decodeRow(originalData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)originalColumn, (Object)newlyAddedColumn), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)addedColumnSchema));
        Assertions.assertThat(decodedRow).hasSize(2);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)originalColumn, "string_field_value");
        DecoderTestUtil.checkIsNull(decodedRow, newlyAddedColumn);
    }

    @Test
    public void testSchemaEvolutionRenamingColumn() {
        byte[] originalData = TestAvroDecoder.buildAvroData((Schema)TestAvroDecoder.getFieldBuilder().name("string_field").type().stringType().noDefault().endRecord(), "string_field", "string_field_value");
        DecoderTestColumnHandle renamedColumn = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "string_field_renamed", null, null, false, false, false);
        String renamedColumnSchema = ((Schema)((SchemaBuilder.FieldAssembler)TestAvroDecoder.getFieldBuilder().name("string_field_renamed").type().optional().stringType()).endRecord()).toString();
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)renamedColumn), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)renamedColumnSchema));
        Assertions.assertThat(decodedEvolvedRow).hasSize(1);
        DecoderTestUtil.checkIsNull(decodedEvolvedRow, renamedColumn);
    }

    @Test
    public void testSchemaEvolutionRemovingColumn() {
        byte[] originalData = TestAvroDecoder.buildAvroData((Schema)((SchemaBuilder.FieldAssembler)TestAvroDecoder.getFieldBuilder().name("string_field").type().stringType().noDefault().name("string_field_to_be_removed").type().optional().stringType()).endRecord(), (Map<String, Object>)ImmutableMap.of((Object)"string_field", (Object)"string_field_value", (Object)"string_field_to_be_removed", (Object)"removed_field_value"));
        DecoderTestColumnHandle evolvedColumn = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "string_field", null, null, false, false, false);
        String removedColumnSchema = ((Schema)TestAvroDecoder.getFieldBuilder().name("string_field").type().stringType().noDefault().endRecord()).toString();
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)evolvedColumn), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)removedColumnSchema));
        Assertions.assertThat(decodedEvolvedRow).hasSize(1);
        DecoderTestUtil.checkValue(decodedEvolvedRow, (DecoderColumnHandle)evolvedColumn, "string_field_value");
    }

    @Test
    public void testSchemaEvolutionIntToLong() {
        byte[] originalIntData = TestAvroDecoder.buildAvroData((Schema)TestAvroDecoder.getFieldBuilder().name("int_to_long_field").type().intType().noDefault().endRecord(), "int_to_long_field", 100);
        DecoderTestColumnHandle longColumnReadingIntData = new DecoderTestColumnHandle(0, "row0", (Type)BigintType.BIGINT, "int_to_long_field", null, null, false, false, false);
        String changedTypeSchema = ((Schema)TestAvroDecoder.getFieldBuilder().name("int_to_long_field").type().longType().noDefault().endRecord()).toString();
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalIntData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)longColumnReadingIntData), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)changedTypeSchema));
        Assertions.assertThat(decodedEvolvedRow).hasSize(1);
        DecoderTestUtil.checkValue(decodedEvolvedRow, (DecoderColumnHandle)longColumnReadingIntData, 100L);
    }

    @Test
    public void testSchemaEvolutionIntToDouble() {
        byte[] originalIntData = TestAvroDecoder.buildAvroData((Schema)TestAvroDecoder.getFieldBuilder().name("int_to_double_field").type().intType().noDefault().endRecord(), "int_to_double_field", 100);
        DecoderTestColumnHandle doubleColumnReadingIntData = new DecoderTestColumnHandle(0, "row0", (Type)DoubleType.DOUBLE, "int_to_double_field", null, null, false, false, false);
        String changedTypeSchema = ((Schema)TestAvroDecoder.getFieldBuilder().name("int_to_double_field").type().doubleType().noDefault().endRecord()).toString();
        Map<DecoderColumnHandle, FieldValueProvider> decodedEvolvedRow = TestAvroDecoder.decodeRow(originalIntData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)doubleColumnReadingIntData), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)changedTypeSchema));
        Assertions.assertThat(decodedEvolvedRow).hasSize(1);
        DecoderTestUtil.checkValue(decodedEvolvedRow, (DecoderColumnHandle)doubleColumnReadingIntData, 100.0);
    }

    @Test
    public void testSchemaEvolutionToIncompatibleType() {
        byte[] originalIntData = TestAvroDecoder.buildAvroData((Schema)TestAvroDecoder.getFieldBuilder().name("int_to_string_field").type().intType().noDefault().endRecord(), "int_to_string_field", 100);
        DecoderTestColumnHandle stringColumnReadingIntData = new DecoderTestColumnHandle(0, "row0", (Type)VarcharType.VARCHAR, "int_to_string_field", null, null, false, false, false);
        String changedTypeSchema = ((Schema)TestAvroDecoder.getFieldBuilder().name("int_to_string_field").type().stringType().noDefault().endRecord()).toString();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAvroDecoder.decodeRow(originalIntData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)stringColumnReadingIntData), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)changedTypeSchema))).isInstanceOf(IllegalStateException.class)).hasMessageMatching("Problems during decode phase");
    }

    @Test
    public void testLongDecodedAsBigint() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)BigintType.BIGINT, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"long\"", 493857959588286460L);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 493857959588286460L);
    }

    @Test
    public void testIntDecodedAsBigint() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)BigintType.BIGINT, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"int\"", 100);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 100L);
    }

    @Test
    public void testIntDecodedAsInteger() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)IntegerType.INTEGER, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"int\"", 100000);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 100000L);
    }

    @Test
    public void testIntDecodedAsSmallInt() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)SmallintType.SMALLINT, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"int\"", 1000);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 1000L);
    }

    @Test
    public void testIntDecodedAsTinyInt() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)TinyintType.TINYINT, "id", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "id", "\"int\"", 100);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 100L);
    }

    @Test
    public void testFloatDecodedAsReal() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)RealType.REAL, "float_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "float_field", "\"float\"", Float.valueOf(10.2f));
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, Float.floatToIntBits(10.2f));
    }

    @Test
    public void testBytesDecodedAsVarbinary() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarbinaryType.VARBINARY, "encoded", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "encoded", "\"bytes\"", ByteBuffer.wrap("mytext".getBytes(StandardCharsets.UTF_8)));
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "mytext");
    }

    @Test
    public void testFixedDecodedAsVarbinary() {
        Schema schema = (Schema)((SchemaBuilder.FixedDefault)SchemaBuilder.record((String)"record").fields().name("fixed_field").type().fixed("fixed5").size(5)).noDefault().endRecord();
        Schema fixedType = schema.getField("fixed_field").schema();
        GenericData.Fixed fixedValue = new GenericData.Fixed(schema.getField("fixed_field").schema());
        byte[] bytes = new byte[]{5, 4, 3, 2, 1};
        fixedValue.bytes(bytes);
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarbinaryType.VARBINARY, "fixed_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "fixed_field", fixedType.toString(), fixedValue);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, Slices.wrappedBuffer((byte[])bytes));
    }

    @Test
    public void testDoubleDecodedAsDouble() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)DoubleType.DOUBLE, "double_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "double_field", "\"double\"", 56.898);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 56.898);
    }

    @Test
    public void testStringDecodedAsVarcharN() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)VarcharType.createVarcharType((int)10), "varcharn_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "varcharn_field", "\"string\"", "abcdefghijklmno");
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, "abcdefghij");
    }

    @Test
    public void testNestedRecord() {
        String schema = "{\"type\" : \"record\",   \"name\" : \"nested_schema\",  \"namespace\" : \"io.trino.decoder.avro\",  \"fields\" :  [{            \"name\":\"nested\",            \"type\":{                      \"type\":\"record\",                      \"name\":\"Nested\",                      \"fields\":                      [                          {                              \"name\":\"id\",                              \"type\":[\"long\", \"null\"]                          }                      ]                  }  }]}";
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)BigintType.BIGINT, "nested/id", null, null, false, false, false);
        Schema nestedSchema = new Schema.Parser().parse(schema);
        Schema userSchema = nestedSchema.getField("nested").schema();
        GenericData.Record userRecord = TestAvroDecoder.buildAvroRecord(userSchema, new ByteArrayOutputStream(), (Map<String, Object>)ImmutableMap.of((Object)"id", (Object)98247748L));
        byte[] avroData = TestAvroDecoder.buildAvroData(nestedSchema, "nested", userRecord);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = TestAvroDecoder.decodeRow(avroData, (Set<DecoderColumnHandle>)ImmutableSet.of((Object)row), (Map<String, String>)ImmutableMap.of((Object)"dataSchema", (Object)schema));
        Assertions.assertThat(decodedRow).hasSize(1);
        DecoderTestUtil.checkValue(decodedRow, (DecoderColumnHandle)row, 98247748L);
    }

    @Test
    public void testNonExistentFieldsAreNull() {
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)VarcharType.createVarcharType((int)100), "very/deep/varchar", null, null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)BigintType.BIGINT, "no_bigint", null, null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)DoubleType.DOUBLE, "double_record/is_missing", null, null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)BooleanType.BOOLEAN, "hello", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow1 = this.buildAndDecodeColumn(row1, "dummy", "\"long\"", 0L);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow2 = this.buildAndDecodeColumn(row2, "dummy", "\"long\"", 0L);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow3 = this.buildAndDecodeColumn(row3, "dummy", "\"long\"", 0L);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow4 = this.buildAndDecodeColumn(row4, "dummy", "\"long\"", 0L);
        DecoderTestUtil.checkIsNull(decodedRow1, row1);
        DecoderTestUtil.checkIsNull(decodedRow2, row2);
        DecoderTestUtil.checkIsNull(decodedRow3, row3);
        DecoderTestUtil.checkIsNull(decodedRow4, row4);
    }

    @Test
    public void testRuntimeDecodingFailure() {
        DecoderTestColumnHandle booleanColumn = new DecoderTestColumnHandle(0, "some_column", (Type)BooleanType.BOOLEAN, "long_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(booleanColumn, "long_field", "\"long\"", 1L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((FieldValueProvider)decodedRow.get(booleanColumn)).getBoolean()).isInstanceOf(TrinoException.class)).hasMessageMatching("cannot decode object of 'class java.lang.Long' as 'boolean' for column 'some_column'");
    }

    @Test
    public void testArrayDecodedAsArray() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)BigintType.BIGINT), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", "{\"type\": \"array\", \"items\": [\"long\"]}", ImmutableList.of((Object)114L, (Object)136L));
        TestAvroDecoder.checkArrayValue(decodedRow, row, ImmutableList.of((Object)114L, (Object)136L));
    }

    @Test
    public void testNestedLongArray() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)), "array_field", null, null, false, false, false);
        Schema schema = (Schema)SchemaBuilder.array().items().array().items().longType();
        ImmutableList data = ImmutableList.builder().add((Object)ImmutableList.of((Object)12L, (Object)15L, (Object)17L)).add((Object)ImmutableList.of((Object)22L, (Object)25L, (Object)27L, (Object)29L)).build();
        GenericData.Array list = new GenericData.Array(schema, (Collection)data);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testNestedLongArrayWithNulls() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT)), "array_field", null, null, false, false, false);
        Schema schema = (Schema)SchemaBuilder.array().items().nullable().array().items().nullable().longType();
        List<List> data = Arrays.asList(ImmutableList.of((Object)12L, (Object)15L, (Object)17L), ImmutableList.of((Object)22L, (Object)25L, (Object)27L, (Object)29L), null, Arrays.asList(3L, 5L, null, 6L));
        GenericData.Array list = new GenericData.Array(schema, data);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testNestedStringArray() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)), "array_field", null, null, false, false, false);
        Schema schema = (Schema)SchemaBuilder.array().items().array().items().stringType();
        ImmutableList data = ImmutableList.builder().add((Object)ImmutableList.of((Object)"a", (Object)"bb", (Object)"ccc")).add((Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"car")).build();
        GenericData.Array list = new GenericData.Array(schema, (Collection)data);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testNestedStringArrayWithNulls() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR)), "array_field", null, null, false, false, false);
        Schema schema = (Schema)SchemaBuilder.array().items().nullable().array().items().nullable().stringType();
        List<List> data = Arrays.asList(ImmutableList.of((Object)"a", (Object)"bb", (Object)"ccc"), ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"car"), null, Arrays.asList("boo", "hoo", null, "hoo"));
        GenericData.Array list = new GenericData.Array(schema, data);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testDeeplyNestedLongArray() {
        Schema schema = (Schema)SchemaBuilder.array().items().array().items().array().items().longType();
        ImmutableList data = ImmutableList.builder().add((Object)ImmutableList.builder().add((Object)ImmutableList.of((Object)12L, (Object)15L, (Object)17L)).add((Object)ImmutableList.of((Object)22L, (Object)25L, (Object)27L, (Object)29L)).build()).build();
        GenericData.Array list = new GenericData.Array(schema, (Collection)data);
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testDeeplyNestedLongArrayWithNulls() {
        Schema schema = (Schema)SchemaBuilder.array().items().nullable().array().items().nullable().array().items().nullable().longType();
        List<List> data = Arrays.asList(Arrays.asList(ImmutableList.of((Object)12L, (Object)15L, (Object)17L), null, Arrays.asList(3L, 5L, null, 6L), ImmutableList.of((Object)22L, (Object)25L, (Object)27L, (Object)29L)), null);
        GenericData.Array list = new GenericData.Array(schema, data);
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)BigintType.BIGINT))), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testDeeplyNestedStringArray() {
        Schema schema = (Schema)SchemaBuilder.array().items().array().items().array().items().stringType();
        ImmutableList data = ImmutableList.builder().add((Object)ImmutableList.builder().add((Object)ImmutableList.of((Object)"a", (Object)"bb", (Object)"ccc")).add((Object)ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"car")).build()).build();
        GenericData.Array list = new GenericData.Array(schema, (Collection)data);
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testDeeplyNestedStringArrayWithNulls() {
        Schema schema = (Schema)SchemaBuilder.array().items().nullable().array().items().nullable().array().items().nullable().stringType();
        List<List> data = Arrays.asList(Arrays.asList(ImmutableList.of((Object)"a", (Object)"bb", (Object)"ccc"), null, Arrays.asList("boo", "hoo", null, "hoo"), ImmutableList.of((Object)"foo", (Object)"bar", (Object)"baz", (Object)"car")), null);
        GenericData.Array list = new GenericData.Array(schema, data);
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)new ArrayType((Type)new ArrayType((Type)VarcharType.VARCHAR))), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        TestAvroDecoder.checkArrayValue(decodedRow, row, list);
    }

    @Test
    public void testArrayOfMaps() {
        Schema schema = (Schema)SchemaBuilder.array().items().map().values().floatType();
        ImmutableList data = ImmutableList.builder().add(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key1", (Object)"key2", (Object)"key3"), ImmutableList.of((Object)Float.valueOf(1.3f), (Object)Float.valueOf(2.3f), (Object)Float.valueOf(-0.5f)))).add(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key10", (Object)"key20", (Object)"key30"), ImmutableList.of((Object)Float.valueOf(11.3f), (Object)Float.valueOf(12.3f), (Object)Float.valueOf(-1.5f)))).build();
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType(REAL_MAP_TYPE), "array_field", null, null, false, false, false);
        GenericData.Array list = new GenericData.Array(schema, (Collection)data);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        AvroDecoderTestUtil.checkArrayValues((Block)TestAvroDecoder.getObject(decodedRow, row), row.getType(), data);
    }

    @Test
    public void testArrayOfMapsWithNulls() {
        Schema schema = (Schema)SchemaBuilder.array().items().nullable().map().values().nullable().floatType();
        List<Map> data = Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key1", (Object)"key2", (Object)"key3"), ImmutableList.of((Object)Float.valueOf(1.3f), (Object)Float.valueOf(2.3f), (Object)Float.valueOf(-0.5f))), null, TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key10", (Object)"key20", (Object)"key30"), ImmutableList.of((Object)Float.valueOf(11.3f), (Object)Float.valueOf(12.3f), (Object)Float.valueOf(-1.5f))), TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key100", (Object)"key200", (Object)"key300"), Arrays.asList(Float.valueOf(111.3f), null, Float.valueOf(-11.5f))));
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType(REAL_MAP_TYPE), "array_field", null, null, false, false, false);
        GenericData.Array list = new GenericData.Array(schema, data);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), list);
        AvroDecoderTestUtil.checkArrayValues((Block)TestAvroDecoder.getObject(decodedRow, row), row.getType(), data);
    }

    @Test
    public void testMapOfMaps() {
        Schema schema = (Schema)SchemaBuilder.map().values().map().values().floatType();
        ImmutableMap data = ImmutableMap.builder().put((Object)"k1", TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key1", (Object)"key2", (Object)"key3"), ImmutableList.of((Object)Float.valueOf(1.3f), (Object)Float.valueOf(2.3f), (Object)Float.valueOf(-0.5f)))).put((Object)"k2", TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key10", (Object)"key20", (Object)"key30"), ImmutableList.of((Object)Float.valueOf(11.3f), (Object)Float.valueOf(12.3f), (Object)Float.valueOf(-1.5f)))).buildOrThrow();
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", MAP_OF_REAL_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", schema.toString(), data);
        TestAvroDecoder.checkMapValue(decodedRow, row, (Object)data);
    }

    @Test
    public void testMapOfMapsWithNulls() {
        Schema schema = (Schema)SchemaBuilder.map().values().nullable().map().values().nullable().floatType();
        Map<String, Map> data = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2", (Object)"k3"), Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key1", (Object)"key2", (Object)"key3"), ImmutableList.of((Object)Float.valueOf(1.3f), (Object)Float.valueOf(2.3f), (Object)Float.valueOf(-0.5f))), null, TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"key10", (Object)"key20", (Object)"key30"), Arrays.asList(Float.valueOf(11.3f), null, Float.valueOf(-1.5f)))));
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", MAP_OF_REAL_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", schema.toString(), data);
        TestAvroDecoder.checkMapValue(decodedRow, row, data);
    }

    @Test
    public void testMapOfArrayOfMaps() {
        Schema schema = (Schema)SchemaBuilder.map().values().array().items().map().values().floatType();
        Map<String, List> data = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2"), Arrays.asList(Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk1", (Object)"sk2", (Object)"sk3"), Arrays.asList(Float.valueOf(1.3f), Float.valueOf(-5.3f), Float.valueOf(2.3f)))), Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk11", (Object)"sk21", (Object)"sk31"), Arrays.asList(Float.valueOf(11.3f), Float.valueOf(-1.5f), Float.valueOf(12.3f))))));
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", MAP_OF_ARRAY_OF_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", schema.toString(), data);
        TestAvroDecoder.checkMapValue(decodedRow, row, data);
    }

    @Test
    public void testMapOfArrayOfMapsWithNulls() {
        Schema schema = (Schema)SchemaBuilder.map().values().nullable().array().items().nullable().map().values().nullable().floatType();
        Map<String, List> data = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2", (Object)"k3"), Arrays.asList(Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk1", (Object)"sk2", (Object)"sk3"), Arrays.asList(Float.valueOf(1.3f), null, Float.valueOf(2.3f)))), null, Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk11", (Object)"sk21", (Object)"sk31"), Arrays.asList(Float.valueOf(11.3f), Float.valueOf(-1.5f), Float.valueOf(12.3f))))));
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", MAP_OF_ARRAY_OF_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", schema.toString(), data);
        TestAvroDecoder.checkMapValue(decodedRow, row, data);
    }

    @Test
    public void testMapOfArrayOfMapsWithDifferentKeys() {
        Schema schema = (Schema)SchemaBuilder.map().values().array().items().map().values().floatType();
        Map<String, List> data = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2"), Arrays.asList(Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk1", (Object)"sk2", (Object)"sk3"), Arrays.asList(Float.valueOf(1.3f), Float.valueOf(-5.3f), Float.valueOf(2.3f)))), Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk11", (Object)"sk21", (Object)"sk31"), Arrays.asList(Float.valueOf(11.3f), Float.valueOf(-1.5f), Float.valueOf(12.3f))))));
        Map<String, List> mismatchedData = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2"), Arrays.asList(Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk1", (Object)"sk2", (Object)"badKey"), Arrays.asList(Float.valueOf(1.3f), Float.valueOf(-5.3f), Float.valueOf(2.3f)))), Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk11", (Object)"sk21", (Object)"sk31"), Arrays.asList(Float.valueOf(11.3f), Float.valueOf(-1.5f), Float.valueOf(12.3f))))));
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", MAP_OF_ARRAY_OF_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", schema.toString(), data);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAvroDecoder.checkMapValue(decodedRow, row, (Object)mismatchedData)).isInstanceOf(AssertionError.class)).hasMessageContaining("Key not found: sk3");
    }

    @Test
    public void testMapOfArrayOfMapsWithDifferentValues() {
        Schema schema = (Schema)SchemaBuilder.map().values().array().items().map().values().floatType();
        Map<String, List> data = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2"), Arrays.asList(Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk1", (Object)"sk2", (Object)"sk3"), Arrays.asList(Float.valueOf(1.3f), Float.valueOf(-5.3f), Float.valueOf(2.3f)))), Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk11", (Object)"sk21", (Object)"sk31"), Arrays.asList(Float.valueOf(11.3f), Float.valueOf(-1.5f), Float.valueOf(12.3f))))));
        Map<String, List> mismatchedData = TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"k1", (Object)"k2"), Arrays.asList(Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk1", (Object)"sk2", (Object)"sk3"), Arrays.asList(Float.valueOf(1.3f), Float.valueOf(-5.3f), Float.valueOf(-2.3f)))), Arrays.asList(TestAvroDecoder.buildMapFromKeysAndValues((List<String>)ImmutableList.of((Object)"sk11", (Object)"sk21", (Object)"sk31"), Arrays.asList(Float.valueOf(11.3f), Float.valueOf(-1.5f), Float.valueOf(12.3f))))));
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", MAP_OF_ARRAY_OF_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", schema.toString(), data);
        Assertions.assertThatThrownBy(() -> TestAvroDecoder.checkMapValue(decodedRow, row, (Object)mismatchedData)).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testArrayWithNulls() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", (Type)new ArrayType((Type)BigintType.BIGINT), "array_field", null, null, false, false, false);
        ArrayList<Object> values = new ArrayList<Object>();
        values.add(null);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", "{\"type\": \"array\", \"items\": [\"long\", \"null\"]}", values);
        TestAvroDecoder.checkArrayItemIsNull(decodedRow, row, new long[]{0L});
    }

    @Test
    public void testMapDecodedAsMap() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", VARCHAR_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", "{\"type\": \"map\", \"values\": \"string\"}", ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"def", (Object)"key3", (Object)"zyx"));
        TestAvroDecoder.checkMapValue(decodedRow, row, (Object)ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"def", (Object)"key3", (Object)"zyx"));
    }

    @Test
    public void testMapWithNull() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", VARCHAR_MAP_TYPE, "map_field", null, null, false, false, false);
        HashMap<String, Object> expectedValues = new HashMap<String, Object>();
        expectedValues.put("key1", null);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", "{\"type\": \"map\", \"values\": \"null\"}", expectedValues);
        TestAvroDecoder.checkMapValue(decodedRow, row, expectedValues);
    }

    @Test
    public void testMapWithDifferentKeys() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", VARCHAR_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", "{\"type\": \"map\", \"values\": \"string\"}", ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"def", (Object)"key3", (Object)"zyx"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestAvroDecoder.checkMapValue(decodedRow, row, (Object)ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key4", (Object)"def", (Object)"key3", (Object)"zyx"))).isInstanceOf(AssertionError.class)).hasMessageContaining("Key not found: key2");
    }

    @Test
    public void testMapWithDifferentValues() {
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "row", VARCHAR_MAP_TYPE, "map_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "map_field", "{\"type\": \"map\", \"values\": \"string\"}", ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"def", (Object)"key3", (Object)"zyx"));
        Assertions.assertThatThrownBy(() -> TestAvroDecoder.checkMapValue(decodedRow, row, (Object)ImmutableMap.of((Object)"key1", (Object)"abc", (Object)"key2", (Object)"fed", (Object)"key3", (Object)"zyx"))).isInstanceOf(AssertionError.class);
    }

    @Test
    public void testRow() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.EnumDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)((SchemaBuilder.FixedDefault)((SchemaBuilder.EnumDefault)SchemaBuilder.record((String)"record_field").fields().name("f1").type().floatType().noDefault().name("f2").type().doubleType().noDefault().name("f3").type().intType().noDefault().name("f4").type().longType().noDefault().name("f5").type().stringType().noDefault().name("f6").type().enumeration("color").symbols(new String[]{"red", "blue", "green"})).noDefault().name("f7").type().fixed("fixed5").size(5)).noDefault().name("f8").type().bytesType().noDefault().name("f9").type().booleanType().noDefault().name("f10").type().array().items().record("sub_array_field").fields().name("sf1").type().stringType().noDefault().name("sf2").type().longType().noDefault().endRecord()).noDefault().name("f11").type().map().values().record("sub_map_field").fields().name("sf1").type().doubleType().noDefault().name("sf2").type().booleanType().noDefault().endRecord()).noDefault().name("f12").type().record("sub_row_field").fields().name("sf1").type().intType().noDefault().name("sf2").type().enumeration("state").symbols(new String[]{"initialized", "running", "finished", "failed"})).noDefault().endRecord()).noDefault().endRecord();
        RowType rowType = RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"f1", (Type)RealType.REAL)).add((Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)).add((Object)RowType.field((String)"f3", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"f4", (Type)BigintType.BIGINT)).add((Object)RowType.field((String)"f5", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"f6", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"f7", (Type)VarbinaryType.VARBINARY)).add((Object)RowType.field((String)"f8", (Type)VarbinaryType.VARBINARY)).add((Object)RowType.field((String)"f9", (Type)BooleanType.BOOLEAN)).add((Object)RowType.field((String)"f10", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"sf1", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"sf2", (Type)BigintType.BIGINT)).build())))).add((Object)RowType.field((String)"f11", (Type)MAP_OF_RECORD)).add((Object)RowType.field((String)"f12", (Type)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"sf1", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"sf2", (Type)VarcharType.VARCHAR)).build()))).build());
        GenericData.Record data = new GenericRecordBuilder(schema).set("f1", (Object)Float.valueOf(1.5f)).set("f2", (Object)1.6).set("f3", (Object)5).set("f4", (Object)6L).set("f5", (Object)"hello").set("f6", (Object)new GenericData.EnumSymbol(schema.getField("f6").schema(), "blue")).set("f7", (Object)new GenericData.Fixed(schema.getField("f7").schema(), new byte[]{5, 4, 3, 2, 1})).set("f8", (Object)ByteBuffer.wrap("mytext".getBytes(StandardCharsets.UTF_8))).set("f9", (Object)true).set("f10", (Object)ImmutableList.builder().add((Object)new GenericRecordBuilder(schema.getField("f10").schema().getElementType()).set("sf1", (Object)"string text").set("sf2", (Object)365000000L).build()).add((Object)new GenericRecordBuilder(schema.getField("f10").schema().getElementType()).set("sf1", (Object)"more string text").set("sf2", (Object)365000000000L).build()).build()).set("f11", (Object)ImmutableMap.builder().put((Object)"key1", (Object)new GenericRecordBuilder(schema.getField("f11").schema().getValueType()).set("sf1", (Object)3.5).set("sf2", (Object)true).build()).put((Object)"key2", (Object)new GenericRecordBuilder(schema.getField("f11").schema().getValueType()).set("sf1", (Object)4.5).set("sf2", (Object)false).build()).buildOrThrow()).set("f12", (Object)new GenericRecordBuilder(schema.getField("f12").schema()).set("sf1", (Object)3).set("sf2", (Object)new GenericData.EnumSymbol(schema.getField("f12").schema().getField("sf2").schema(), "running")).build()).build();
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "record_field", (Type)rowType, "record_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "record_field", schema.toString(), data);
        TestAvroDecoder.checkRowValue(decodedRow, row, data);
    }

    @Test
    public void testRowWithNulls() {
        Schema schema = (Schema)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FieldAssembler)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.UnionAccumulator)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)((SchemaBuilder.FieldAssembler)SchemaBuilder.record((String)"record_field").fields().name("f1").type().optional().floatType()).name("f2").type().optional().doubleType()).name("f3").type().optional().intType()).name("f4").type().optional().longType()).name("f5").type().optional().stringType()).name("f6").type().optional().enumeration("color").symbols(new String[]{"red", "blue", "green"})).name("f7").type().optional().fixed("fixed5").size(5)).name("f8").type().optional().bytesType()).name("f9").type().optional().booleanType()).name("f10").type().optional().array().items().unionOf().nullType()).and().record("sub_array_field").fields().name("sf1").type().optional().stringType()).name("sf2").type().optional().longType()).endRecord()).endUnion()).name("f11").type().optional().map().values().unionOf().nullType()).and().record("sub_map_field").fields().name("sf1").type().optional().doubleType()).name("sf2").type().optional().booleanType()).endRecord()).endUnion()).name("f12").type().optional().record("sub_row_field").fields().name("sf1").type().optional().intType()).name("sf2").type().optional().enumeration("state").symbols(new String[]{"initialized", "running", "finished", "failed"})).endRecord()).endRecord();
        RowType rowType = RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"f1", (Type)RealType.REAL)).add((Object)RowType.field((String)"f2", (Type)DoubleType.DOUBLE)).add((Object)RowType.field((String)"f3", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"f4", (Type)BigintType.BIGINT)).add((Object)RowType.field((String)"f5", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"f6", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"f7", (Type)VarbinaryType.VARBINARY)).add((Object)RowType.field((String)"f8", (Type)VarbinaryType.VARBINARY)).add((Object)RowType.field((String)"f9", (Type)BooleanType.BOOLEAN)).add((Object)RowType.field((String)"f10", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"sf1", (Type)VarcharType.VARCHAR)).add((Object)RowType.field((String)"sf2", (Type)BigintType.BIGINT)).build())))).add((Object)RowType.field((String)"f11", (Type)MAP_OF_RECORD)).add((Object)RowType.field((String)"f12", (Type)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"sf1", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"sf2", (Type)VarcharType.VARCHAR)).build()))).build());
        GenericData.Record data = new GenericRecordBuilder(schema).build();
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "record_field", (Type)rowType, "record_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "record_field", schema.toString(), data);
        TestAvroDecoder.checkRowValue(decodedRow, row, data);
        GenericData.Array array = new GenericData.Array((Schema)schema.getField("f10").schema().getTypes().get(1), Arrays.asList(new GenericRecordBuilder((Schema)((Schema)schema.getField("f10").schema().getTypes().get(1)).getElementType().getTypes().get(1)).build(), null));
        data = new GenericRecordBuilder(schema).set("f10", (Object)array).set("f11", (Object)ImmutableMap.of((Object)"key1", (Object)new GenericRecordBuilder((Schema)((Schema)schema.getField("f11").schema().getTypes().get(1)).getValueType().getTypes().get(1)).build())).set("f12", (Object)new GenericRecordBuilder((Schema)schema.getField("f12").schema().getTypes().get(1)).build()).build();
        decodedRow = this.buildAndDecodeColumn(row, "record_field", schema.toString(), data);
        TestAvroDecoder.checkRowValue(decodedRow, row, data);
    }

    @Test
    public void testArrayOfRow() {
        Schema schema = (Schema)SchemaBuilder.array().items().record("record").fields().name("f1").type().intType().noDefault().name("f2").type().stringType().noDefault().endRecord();
        ImmutableList.Builder dataBuilder = ImmutableList.builder();
        for (int i = 0; i < 10; ++i) {
            dataBuilder.add((Object)new GenericRecordBuilder(schema.getElementType()).set("f1", (Object)(100 + i)).set("f2", (Object)("hi-" + i)).build());
        }
        ImmutableList data = dataBuilder.build();
        DecoderTestColumnHandle row = new DecoderTestColumnHandle(0, "array_field", (Type)new ArrayType((Type)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"f1", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"f2", (Type)VarcharType.VARCHAR)).build())), "array_field", null, null, false, false, false);
        Map<DecoderColumnHandle, FieldValueProvider> decodedRow = this.buildAndDecodeColumn(row, "array_field", schema.toString(), data);
        TestAvroDecoder.checkArrayValue(decodedRow, row, data);
    }

    private static void checkRowValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, Object expected) {
        AvroDecoderTestUtil.checkRowValues((SqlRow)TestAvroDecoder.getObject(decodedRow, handle), handle.getType(), expected);
    }

    private static void checkArrayValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, Object expected) {
        AvroDecoderTestUtil.checkArrayValues((Block)TestAvroDecoder.getObject(decodedRow, handle), handle.getType(), expected);
    }

    private static void checkMapValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, Object expected) {
        AvroDecoderTestUtil.checkMapValues((SqlMap)TestAvroDecoder.getObject(decodedRow, handle), handle.getType(), expected);
    }

    private static void checkArrayItemIsNull(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, long[] expected) {
        Block actualBlock = (Block)TestAvroDecoder.getObject(decodedRow, handle);
        Assertions.assertThat((int)actualBlock.getPositionCount()).isEqualTo(expected.length);
        for (int i = 0; i < actualBlock.getPositionCount(); ++i) {
            Assertions.assertThat((boolean)actualBlock.isNull(i)).isTrue();
            Assertions.assertThat((long)BigintType.BIGINT.getLong(actualBlock, i)).isEqualTo(expected[i]);
        }
    }

    private static void checkMapValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderTestColumnHandle handle, Object expected) {
        AvroDecoderTestUtil.checkMapValues((SqlMap)TestAvroDecoder.getObject(decodedRow, handle), handle.getType(), expected);
    }

    private static Object getObject(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        return provider.getObject();
    }

    @Test
    public void testInvalidExtraneousParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "mapping", null, "hint", false, false, false)).isInstanceOf(TrinoException.class)).hasMessageMatching("unexpected format hint 'hint' defined for column 'some_column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "mapping", null, null, false, false, true)).isInstanceOf(TrinoException.class)).hasMessageMatching("unexpected internal column 'some_column'");
    }

    @Test
    public void testSupportedDataTypeValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT);
        this.singleColumnDecoder((Type)VarbinaryType.VARBINARY);
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN);
        this.singleColumnDecoder((Type)DoubleType.DOUBLE);
        this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType());
        this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100));
        this.singleColumnDecoder((Type)new ArrayType((Type)BigintType.BIGINT));
        this.singleColumnDecoder(VARCHAR_MAP_TYPE);
        this.singleColumnDecoder(DOUBLE_MAP_TYPE);
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DecimalType.createDecimalType((int)10, (int)4)));
    }

    private void assertUnsupportedColumnTypeException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(TrinoException.class)).hasMessageMatching("Unsupported column type .* for column .*");
    }

    private void singleColumnDecoder(Type columnType) {
        String someSchema = ((Schema)TestAvroDecoder.getFieldBuilder().name("dummy").type().longType().noDefault().endRecord()).toString();
        DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("avro", (Map)ImmutableMap.of((Object)"dataSchema", (Object)someSchema), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "some_column", columnType, "0", null, null, false, false, false))));
    }

    private void singleColumnDecoder(Type columnType, String mapping, String dataFormat, String formatHint, boolean keyDecoder, boolean hidden, boolean internal) {
        String someSchema = ((Schema)TestAvroDecoder.getFieldBuilder().name("dummy").type().longType().noDefault().endRecord()).toString();
        DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("avro", (Map)ImmutableMap.of((Object)"dataSchema", (Object)someSchema), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "some_column", columnType, mapping, dataFormat, formatHint, keyDecoder, hidden, internal))));
    }
}

