/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.airlift.slice.Slice;
import io.trino.decoder.DecoderTestColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.decoder.util.DecoderTestUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.type.Type;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.util.Preconditions;

public class JsonFieldDecoderTester {
    private static final JsonRowDecoderFactory DECODER_FACTORY = new JsonRowDecoderFactory(new ObjectMapperProvider().get());
    private final Optional<String> dataFormat;
    private final Optional<String> formatHint;

    public JsonFieldDecoderTester() {
        this(Optional.empty(), Optional.empty());
    }

    public JsonFieldDecoderTester(String dataFormat) {
        this(Optional.of(dataFormat), Optional.empty());
    }

    public JsonFieldDecoderTester(String dataFormat, String formatHint) {
        this(Optional.of(dataFormat), Optional.of(formatHint));
    }

    private JsonFieldDecoderTester(Optional<String> dataFormat, Optional<String> formatHint) {
        this.dataFormat = Objects.requireNonNull(dataFormat, "dataFormat is null");
        this.formatHint = Objects.requireNonNull(formatHint, "formatHint is null");
    }

    public void assertDecodedAs(String jsonValue, Type type, long expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Long.TYPE ? 1 : 0) != 0, (String)"Wrong (not long based) Trino type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)decodedValue.isNull()).describedAs(String.format("expected non null when decoding %s as %s", jsonValue, type), new Object[0])).isFalse();
        Assertions.assertThat((long)decodedValue.getLong()).isEqualTo(expectedValue);
    }

    public void assertDecodedAs(String jsonValue, Type type, double expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Double.TYPE ? 1 : 0) != 0, (String)"Wrong (not double based) Trino type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)decodedValue.isNull()).describedAs(String.format("expected non null when decoding %s as %s", jsonValue, type), new Object[0])).isFalse();
        Assertions.assertThat((double)decodedValue.getDouble()).isEqualTo(expectedValue);
    }

    public void assertDecodedAs(String jsonValue, Type type, Slice expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Slice.class ? 1 : 0) != 0, (String)"Wrong (not Slice based) Trino type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)decodedValue.isNull()).describedAs(String.format("expected non null when decoding %s as %s", jsonValue, type), new Object[0])).isFalse();
        Assertions.assertThat((Comparable)decodedValue.getSlice()).isEqualTo((Object)expectedValue);
    }

    public void assertDecodedAs(String jsonValue, Type type, boolean expectedValue) {
        Preconditions.checkArgument((type.getJavaType() == Boolean.TYPE ? 1 : 0) != 0, (String)"Wrong (not boolean based) Trino type '%s'", (Object[])new Object[]{type});
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)decodedValue.isNull()).describedAs(String.format("expected non null when decoding %s as %s", jsonValue, type), new Object[0])).isFalse();
        Assertions.assertThat((boolean)decodedValue.getBoolean()).isEqualTo(expectedValue);
    }

    public void assertDecodedAsNull(String jsonValue, Type type) {
        FieldValueProvider decodedValue = this.decode(Optional.of(jsonValue), type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)decodedValue.isNull()).describedAs(String.format("expected null when decoding %s as %s", jsonValue, type), new Object[0])).isTrue();
    }

    public void assertMissingDecodedAsNull(Type type) {
        FieldValueProvider decodedValue = this.decode(Optional.empty(), type);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)decodedValue.isNull()).describedAs(String.format("expected null when decoding missing field as %s", type), new Object[0])).isTrue();
    }

    public void assertInvalidInput(String jsonValue, Type type, String exceptionRegex) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.decode(Optional.of(jsonValue), type).getLong()).isInstanceOf(TrinoException.class)).hasMessageMatching(exceptionRegex);
    }

    private FieldValueProvider decode(Optional<String> jsonValue, Type type) {
        String jsonField = "value";
        String json = jsonValue.map(value -> String.format("{\"%s\":%s}", jsonField, value)).orElse("{}");
        DecoderTestColumnHandle columnHandle = new DecoderTestColumnHandle(0, "some_column", type, jsonField, this.dataFormat.orElse(null), this.formatHint.orElse(null), false, false, false);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("json", Collections.emptyMap(), (Set)ImmutableSet.of((Object)columnHandle)));
        Map decodedRow = (Map)rowDecoder.decodeRow(json.getBytes(StandardCharsets.UTF_8)).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).containsKey((Object)columnHandle);
        return (FieldValueProvider)decodedRow.get(columnHandle);
    }
}

