/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.trino.decoder.DecoderTestColumnHandle;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.json.JsonFieldDecoderTester;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.decoder.util.DecoderTestUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Collections;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestCustomDateTimeJsonFieldDecoder {
    private final JsonFieldDecoderTester timestampTester = new JsonFieldDecoderTester("custom-date-time", "MM/yyyy/dd H:m:s");
    private final JsonFieldDecoderTester timestampWithTimeZoneTester = new JsonFieldDecoderTester("custom-date-time", "MM/yyyy/dd H:m:s Z");
    private final JsonFieldDecoderTester timeTester = new JsonFieldDecoderTester("custom-date-time", "mm:HH:ss");
    private final JsonFieldDecoderTester timeWTZTester = new JsonFieldDecoderTester("custom-date-time", "HH:mm:ss.SSSZ");
    private final JsonFieldDecoderTester dateTester = new JsonFieldDecoderTester("custom-date-time", "MM/yyyy/dd");
    private final JsonFieldDecoderTester timeJustHourTester = new JsonFieldDecoderTester("custom-date-time", "HH");

    @Test
    public void testDecode() {
        this.timestampTester.assertDecodedAs("\"02/2018/19 9:20:11\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032011000000L);
        this.timestampWithTimeZoneTester.assertDecodedAs("\"02/2018/19 11:20:11 +02:00\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032011000000L);
        this.timestampTester.assertDecodedAs("\"02/2018/19 9:20:11\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.timestampWithTimeZoneTester.assertDecodedAs("\"02/2018/19 11:20:11 +02:00\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)120L)));
        this.timeTester.assertDecodedAs("\"15:13:18\"", (Type)TimeType.TIME_MILLIS, 47718000000000000L);
        this.timeJustHourTester.assertDecodedAs("\"15\"", (Type)TimeType.TIME_MILLIS, 54000000000000000L);
        this.timeJustHourTester.assertDecodedAs("15", (Type)TimeType.TIME_MILLIS, 54000000000000000L);
        this.timeTester.assertDecodedAs("\"15:13:18\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)47718000000000L, (int)0));
        this.timeWTZTester.assertDecodedAs("\"15:13:18.123-04:00\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)54798123000000L, (int)-240));
        this.timeWTZTester.assertDecodedAs("\"15:13:18.123+08:00\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)54798123000000L, (int)480));
        this.dateTester.assertDecodedAs("\"02/2018/11\"", (Type)DateType.DATE, 17573L);
    }

    @Test
    public void testDecodeNulls() {
        this.dateTester.assertDecodedAsNull("null", (Type)DateType.DATE);
        this.dateTester.assertMissingDecodedAsNull((Type)DateType.DATE);
        this.timeTester.assertDecodedAsNull("null", (Type)TimeType.TIME_MILLIS);
        this.timeTester.assertMissingDecodedAsNull((Type)TimeType.TIME_MILLIS);
        this.timeTester.assertDecodedAsNull("null", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS);
        this.timeTester.assertMissingDecodedAsNull((Type)TimeWithTimeZoneType.TIME_TZ_MILLIS);
        this.timestampTester.assertDecodedAsNull("null", (Type)TimestampType.TIMESTAMP_MILLIS);
        this.timestampTester.assertMissingDecodedAsNull((Type)TimestampType.TIMESTAMP_MILLIS);
        this.timestampTester.assertDecodedAsNull("null", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
        this.timestampTester.assertMissingDecodedAsNull((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS);
    }

    @Test
    public void testDecodeInvalid() {
        this.timestampTester.assertInvalidInput("1", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value '1' as 'timestamp(3)' for column 'some_column'\\E");
        this.timestampTester.assertInvalidInput("{}", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse non-value node as 'timestamp(3)' for column 'some_column'\\E");
        this.timestampTester.assertInvalidInput("\"a\"", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value 'a' as 'timestamp(3)' for column 'some_column'\\E");
        this.timestampTester.assertInvalidInput("\"15:13:18\"", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value '15:13:18' as 'timestamp(3)' for column 'some_column'\\E");
        this.timestampTester.assertInvalidInput("\"02/2018/11\"", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value '02/2018/11' as 'timestamp(3)' for column 'some_column'\\E");
    }

    @Test
    public void testInvalidFormatHint() {
        DecoderTestColumnHandle columnHandle = new DecoderTestColumnHandle(0, "some_column", (Type)TimestampType.TIMESTAMP_MILLIS, "mappedField", "custom-date-time", "XXMM/yyyy/dd H:m:sXX", false, false, false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> new JsonRowDecoderFactory(new ObjectMapperProvider().get()).create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("json", Collections.emptyMap(), (Set)ImmutableSet.of((Object)columnHandle)))).isInstanceOf(TrinoException.class)).hasMessageMatching("invalid Joda Time pattern 'XXMM/yyyy/dd H:m:sXX' passed as format hint for column 'some_column'");
    }
}

