/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import io.trino.decoder.json.JsonFieldDecoderTester;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.DateType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import org.junit.jupiter.api.Test;

public class TestISO8601JsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester("iso8601");

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032011000000L);
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11Z\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032011000000L);
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11+10:00\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032011000000L);
        this.tester.assertDecodedAs("\"13:15:18\"", (Type)TimeType.TIME_MILLIS, 47718000000000000L);
        this.tester.assertDecodedAs("\"13:15\"", (Type)TimeType.TIME_MILLIS, 47700000000000000L);
        this.tester.assertDecodedAs("\"13:15:18Z\"", (Type)TimeType.TIME_MILLIS, 47718000000000000L);
        this.tester.assertDecodedAs("\"13:15Z\"", (Type)TimeType.TIME_MILLIS, 47700000000000000L);
        this.tester.assertDecodedAs("\"13:15:18+10:00\"", (Type)TimeType.TIME_MILLIS, 47718000000000000L);
        this.tester.assertDecodedAs("\"13:15+10:00\"", (Type)TimeType.TIME_MILLIS, 47700000000000000L);
        this.tester.assertDecodedAs("\"2018-02-11\"", (Type)DateType.DATE, 17573L);
        this.tester.assertDecodedAs("\"2018-02-19T09:20:11Z\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"2018-02-19T12:20:11+03:00\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1519032011000L, (String)"+03:00"));
        this.tester.assertDecodedAs("\"13:15:18Z\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)47718000000000L, (int)0));
        this.tester.assertDecodedAs("\"13:15:18+10:00\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)47718000000000L, (int)600));
        this.tester.assertDecodedAs("\"15:13:18.123-04:00\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)54798123000000L, (int)-240));
        this.tester.assertDecodedAs("\"15:13:18.123+08:00\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)54798123000000L, (int)480));
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(DateType.DATE, TimeType.TIME_MILLIS, TimeWithTimeZoneType.TIME_TZ_MILLIS, TimestampType.TIMESTAMP_MILLIS, TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void testDecodeInvalid() {
        this.tester.assertInvalidInput("1", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value '1' as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("{}", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse non-value node as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"a\"", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value 'a' as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("1", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value '1' as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)DateType.DATE, "could not parse value '2018-02-19T09:20:11' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11Z\"", (Type)DateType.DATE, "could not parse value '2018-02-19T09:20:11Z' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11Z\"", (Type)DateType.DATE, "could not parse value '09:20:11Z' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"09:20:11\"", (Type)DateType.DATE, "could not parse value '09:20:11' as 'date' for column 'some_column'");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "\\Qcould not parse value '2018-02-19T09:20:11' as 'timestamp(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"09:20:11\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "\\Qcould not parse value '09:20:11' as 'timestamp(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"09:20:11Z\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "\\Qcould not parse value '09:20:11Z' as 'timestamp(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "\\Qcould not parse value '2018-02-19' as 'timestamp(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)TimeType.TIME_MILLIS, "\\Qcould not parse value '2018-02-19T09:20:11' as 'time(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11Z\"", (Type)TimeType.TIME_MILLIS, "\\Qcould not parse value '2018-02-19T09:20:11Z' as 'time(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19\"", (Type)TimeType.TIME_MILLIS, "\\Qcould not parse value '2018-02-19' as 'time(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19Z\"", (Type)TimeType.TIME_MILLIS, "\\Qcould not parse value '2018-02-19Z' as 'time(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, "\\Qcould not parse value '2018-02-19T09:20:11' as 'time(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19T09:20:11Z\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, "\\Qcould not parse value '2018-02-19T09:20:11Z' as 'time(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"09:20:11\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, "\\Qcould not parse value '09:20:11' as 'time(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"2018-02-19\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, "\\Qcould not parse value '2018-02-19' as 'time(3) with time zone' for column 'some_column'\\E");
    }
}

