/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import com.google.common.collect.ImmutableSet;
import io.airlift.json.ObjectMapperProvider;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderTestColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.json.JsonRowDecoderFactory;
import io.trino.decoder.util.DecoderTestUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DateType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

public class TestJsonDecoder {
    private static final JsonRowDecoderFactory DECODER_FACTORY = new JsonRowDecoderFactory(new ObjectMapperProvider().get());

    @Test
    public void testSimple() throws Exception {
        byte[] json = TestJsonDecoder.class.getResourceAsStream("/decoder/json/message.json").readAllBytes();
        DecoderTestColumnHandle column1 = new DecoderTestColumnHandle(0, "column1", (Type)VarcharType.createVarcharType((int)100), "source", null, null, false, false, false);
        DecoderTestColumnHandle column2 = new DecoderTestColumnHandle(1, "column2", (Type)VarcharType.createVarcharType((int)10), "user/screen_name", null, null, false, false, false);
        DecoderTestColumnHandle column3 = new DecoderTestColumnHandle(2, "column3", (Type)BigintType.BIGINT, "id", null, null, false, false, false);
        DecoderTestColumnHandle column4 = new DecoderTestColumnHandle(3, "column4", (Type)BigintType.BIGINT, "user/statuses_count", null, null, false, false, false);
        DecoderTestColumnHandle column5 = new DecoderTestColumnHandle(4, "column5", (Type)BooleanType.BOOLEAN, "user/geo_enabled", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)column1, (Object)column2, (Object)column3, (Object)column4, (Object)column5);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("json", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(json).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column1, "<a href=\"http://twitterfeed.com\" rel=\"nofollow\">twitterfeed</a>");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column2, "EKentuckyN");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column3, 493857959588286460L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column4, 7630L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)column5, true);
    }

    @Test
    public void testNonExistent() {
        byte[] json = "{}".getBytes(StandardCharsets.UTF_8);
        DecoderTestColumnHandle column1 = new DecoderTestColumnHandle(0, "column1", (Type)VarcharType.createVarcharType((int)100), "very/deep/varchar", null, null, false, false, false);
        DecoderTestColumnHandle column2 = new DecoderTestColumnHandle(1, "column2", (Type)BigintType.BIGINT, "no_bigint", null, null, false, false, false);
        DecoderTestColumnHandle column3 = new DecoderTestColumnHandle(2, "column3", (Type)DoubleType.DOUBLE, "double/is_missing", null, null, false, false, false);
        DecoderTestColumnHandle column4 = new DecoderTestColumnHandle(3, "column4", (Type)BooleanType.BOOLEAN, "hello", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)column1, (Object)column2, (Object)column3, (Object)column4);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("json", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(json).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        DecoderTestUtil.checkIsNull(decodedRow, column1);
        DecoderTestUtil.checkIsNull(decodedRow, column2);
        DecoderTestUtil.checkIsNull(decodedRow, column3);
        DecoderTestUtil.checkIsNull(decodedRow, column4);
    }

    @Test
    public void testStringNumber() {
        byte[] json = "{\"a_number\":481516,\"a_string\":\"2342\"}".getBytes(StandardCharsets.UTF_8);
        DecoderTestColumnHandle column1 = new DecoderTestColumnHandle(0, "column1", (Type)VarcharType.createVarcharType((int)100), "a_number", null, null, false, false, false);
        DecoderTestColumnHandle column2 = new DecoderTestColumnHandle(1, "column2", (Type)BigintType.BIGINT, "a_number", null, null, false, false, false);
        DecoderTestColumnHandle column3 = new DecoderTestColumnHandle(2, "column3", (Type)VarcharType.createVarcharType((int)100), "a_string", null, null, false, false, false);
        DecoderTestColumnHandle column4 = new DecoderTestColumnHandle(3, "column4", (Type)BigintType.BIGINT, "a_string", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)column1, (Object)column2, (Object)column3, (Object)column4);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("json", Collections.emptyMap(), (Set)columns));
        Optional decodedRow = rowDecoder.decodeRow(json);
        Assertions.assertThat((Optional)decodedRow).isPresent();
        Assertions.assertThat((Map)((Map)decodedRow.get())).hasSize(columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)((Map)decodedRow.get()), (DecoderColumnHandle)column1, "481516");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)((Map)decodedRow.get()), (DecoderColumnHandle)column2, 481516L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)((Map)decodedRow.get()), (DecoderColumnHandle)column3, "2342");
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)((Map)decodedRow.get()), (DecoderColumnHandle)column4, 2342L);
    }

    @Test
    public void testSupportedDataTypeValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT, null);
        this.singleColumnDecoder((Type)IntegerType.INTEGER, null);
        this.singleColumnDecoder((Type)SmallintType.SMALLINT, null);
        this.singleColumnDecoder((Type)TinyintType.TINYINT, null);
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN, null);
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, null);
        this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType(), null);
        this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), null);
        this.singleColumnDecoder((Type)TimestampType.TIMESTAMP_MILLIS, "rfc2822");
        this.singleColumnDecoder((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, "rfc2822");
        for (String dataFormat : ImmutableSet.of((Object)"iso8601", (Object)"custom-date-time")) {
            this.singleColumnDecoder((Type)DateType.DATE, dataFormat);
            this.singleColumnDecoder((Type)TimeType.TIME_MILLIS, dataFormat);
            this.singleColumnDecoder((Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, dataFormat);
            this.singleColumnDecoder((Type)TimestampType.TIMESTAMP_MILLIS, dataFormat);
            this.singleColumnDecoder((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, dataFormat);
        }
        for (String dataFormat : ImmutableSet.of((Object)"seconds-since-epoch", (Object)"milliseconds-since-epoch")) {
            this.singleColumnDecoder((Type)TimeType.TIME_MILLIS, dataFormat);
            this.singleColumnDecoder((Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, dataFormat);
            this.singleColumnDecoder((Type)TimestampType.TIMESTAMP_MILLIS, dataFormat);
            this.singleColumnDecoder((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, dataFormat);
        }
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)RealType.REAL, null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DecimalType.createDecimalType((int)10, (int)4), null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)VarbinaryType.VARBINARY, null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DateType.DATE, null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)TimeType.TIME_MILLIS, null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)TimestampType.TIMESTAMP_MILLIS, null));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, null));
        for (String dataFormat : ImmutableSet.of((Object)"iso8601", (Object)"custom-date-time", (Object)"seconds-since-epoch", (Object)"milliseconds-since-epoch", (Object)"rfc2822")) {
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)IntegerType.INTEGER, dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)SmallintType.SMALLINT, dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT, dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)BooleanType.BOOLEAN, dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType(), dataFormat));
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), dataFormat));
        }
        for (String dataFormat : ImmutableSet.of((Object)"seconds-since-epoch", (Object)"milliseconds-since-epoch")) {
            this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DateType.DATE, dataFormat));
        }
    }

    private void assertUnsupportedColumnTypeException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(TrinoException.class)).hasMessageMatching("unsupported column type .* for column .*");
    }

    @Test
    public void testDataFormatValidation() {
        for (Type type : Arrays.asList(TimestampType.TIMESTAMP_MILLIS, DoubleType.DOUBLE)) {
            ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder(type, "wrong_format")).isInstanceOf(TrinoException.class)).hasMessage("unknown data format 'wrong_format' used for column 'some_column'");
        }
    }

    private void singleColumnDecoder(Type columnType, String dataFormat) {
        this.singleColumnDecoder(columnType, "mappedField", dataFormat);
    }

    private void singleColumnDecoder(Type columnType, String mapping, String dataFormat) {
        String formatHint = "custom-date-time".equals(dataFormat) ? "MM/yyyy/dd H:m:s" : null;
        DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("json", Collections.emptyMap(), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "some_column", columnType, mapping, dataFormat, formatHint, false, false, false))));
    }
}

