/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import io.trino.decoder.json.JsonFieldDecoderTester;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeType;
import io.trino.spi.type.TimeWithTimeZoneType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Test;

public class TestMillisecondsSinceEpochJsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester("milliseconds-since-epoch");

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("33701000", (Type)TimeType.TIME_MILLIS, 33701000000000000L);
        this.tester.assertDecodedAs("\"33701000\"", (Type)TimeType.TIME_MILLIS, 33701000000000000L);
        this.tester.assertDecodedAs("33701000", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)33701000000000L, (int)0));
        this.tester.assertDecodedAs("\"33701000\"", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, DateTimeEncoding.packTimeWithTimeZone((long)33701000000000L, (int)0));
        this.tester.assertDecodedAs("1519032101123", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032101123000L);
        this.tester.assertDecodedAs("\"1519032101123\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1519032101123000L);
        this.tester.assertDecodedAs("1519032101123", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1519032101123L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"1519032101123\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1519032101123L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(TimeType.TIME_MILLIS, TimeWithTimeZoneType.TIME_TZ_MILLIS, TimestampType.TIMESTAMP_MILLIS, TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void testDecodeInvalid() {
        for (Type type : Arrays.asList(TimeType.TIME_MILLIS, TimeWithTimeZoneType.TIME_TZ_MILLIS, TimestampType.TIMESTAMP_MILLIS, TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            this.tester.assertInvalidInput("{}", type, "could not parse non-value node as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("[]", type, "could not parse non-value node as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("[10]", type, "could not parse non-value node as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("\"a\"", type, "could not parse value 'a' as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("12345678901234567890", type, "could not parse value '12345678901234567890' as '.*' for column 'some_column'");
            this.tester.assertInvalidInput("362016000000.5", type, "could not parse value '3.620160000005E11' as '.*' for column 'some_column'");
        }
        this.tester.assertInvalidInput("-1", (Type)TimeType.TIME_MILLIS, "\\Qcould not parse value '-1' as 'time(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput(TimeUnit.DAYS.toMillis(1L) + "1", (Type)TimeType.TIME_MILLIS, "\\Qcould not parse value '864000001' as 'time(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("-1", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, "\\Qcould not parse value '-1' as 'time(3) with time zone' for column 'some_column'\\E");
        this.tester.assertInvalidInput(TimeUnit.DAYS.toMillis(1L) + "1", (Type)TimeWithTimeZoneType.TIME_TZ_MILLIS, "\\Qcould not parse value '864000001' as 'time(3) with time zone' for column 'some_column'\\E");
    }
}

