/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.json;

import io.trino.decoder.json.JsonFieldDecoderTester;
import io.trino.spi.type.DateTimeEncoding;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import java.util.Arrays;
import org.junit.jupiter.api.Test;

public class TestRFC2822JsonFieldDecoder {
    private JsonFieldDecoderTester tester = new JsonFieldDecoderTester("rfc2822");

    @Test
    public void testDecode() {
        this.tester.assertDecodedAs("\"Fri Feb 09 13:15:19 Z 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1518182119000000L);
        this.tester.assertDecodedAs("\"Fri Feb 09 13:15:19 Z 2018\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1518182119000L, (TimeZoneKey)TimeZoneKey.UTC_KEY));
        this.tester.assertDecodedAs("\"Fri Feb 09 15:15:19 +02:00 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, 1518182119000000L);
        this.tester.assertDecodedAs("\"Fri Feb 09 15:15:19 +02:00 2018\"", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS, DateTimeEncoding.packDateTimeWithZone((long)1518182119000L, (TimeZoneKey)TimeZoneKey.getTimeZoneKeyForOffset((long)120L)));
    }

    @Test
    public void testDecodeNulls() {
        for (Type type : Arrays.asList(TimestampType.TIMESTAMP_MILLIS, TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)) {
            this.tester.assertDecodedAsNull("null", type);
            this.tester.assertMissingDecodedAsNull(type);
        }
    }

    @Test
    public void testDecodeInvalid() {
        this.tester.assertInvalidInput("{}", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse non-value node as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"a\"", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value 'a' as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("2018", (Type)TimestampType.TIMESTAMP_MILLIS, "\\Qcould not parse value '2018' as 'timestamp(3)' for column 'some_column'\\E");
        this.tester.assertInvalidInput("\"Mon Feb 12 13:15:16 Z\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 12 13:15:16 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 12 Z 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon Feb 13:15:16 Z 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Mon 12 13:15:16 Z 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Feb 12 13:15:16 Z 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Fri Feb 09 13:15:19 Europe/Warsaw 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
        this.tester.assertInvalidInput("\"Fri Feb 09 13:15:19 EST 2018\"", (Type)TimestampType.TIMESTAMP_MILLIS, "could not parse value '.*' as 'timestamp\\(3\\)' for column 'some_column'");
    }
}

