/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.io.Resources;
import com.google.protobuf.Any;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import io.airlift.slice.Slices;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchema;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaUtils;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderTestColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.protobuf.DescriptorProvider;
import io.trino.decoder.protobuf.DummyDescriptorProvider;
import io.trino.decoder.protobuf.DynamicMessageProvider;
import io.trino.decoder.protobuf.FileDescriptorProvider;
import io.trino.decoder.protobuf.FixedSchemaDynamicMessageProvider;
import io.trino.decoder.protobuf.ProtobufRowDecoder;
import io.trino.decoder.protobuf.ProtobufRowDecoderFactory;
import io.trino.decoder.protobuf.ProtobufUtils;
import io.trino.decoder.util.DecoderTestUtil;
import io.trino.spi.block.Block;
import io.trino.spi.block.SqlMap;
import io.trino.spi.block.SqlRow;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.type.ArrayType;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.RowType;
import io.trino.spi.type.SqlTimestamp;
import io.trino.spi.type.SqlVarbinary;
import io.trino.spi.type.TimestampType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import io.trino.testing.DateTimeTestingUtils;
import io.trino.testing.TestingSession;
import io.trino.type.InternalTypeManager;
import io.trino.type.JsonType;
import java.io.File;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestProtobufDecoder {
    private static final ProtobufRowDecoderFactory DECODER_FACTORY = new ProtobufRowDecoderFactory((DynamicMessageProvider.Factory)new FixedSchemaDynamicMessageProvider.Factory(), InternalTypeManager.TESTING_TYPE_MANAGER, (DescriptorProvider)new FileDescriptorProvider());

    @Test
    public void testAllDataTypes() throws Exception {
        this.testAllDataTypes("Trino", 1, 493857959588286460L, Math.PI, Float.valueOf(3.14f), true, "ONE", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("2020-12-12T15:35:45.923")), "X'65683F'".getBytes(StandardCharsets.UTF_8));
        this.testAllDataTypes(IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", ")), Integer.MAX_VALUE, Long.MIN_VALUE, (Double)Double.MAX_VALUE, Float.valueOf(Float.MIN_VALUE), false, "ZERO", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("1856-01-12T05:25:14.456")), new byte[0]);
        this.testAllDataTypes(IntStream.range(5000, 10000).mapToObj(Integer::toString).collect(Collectors.joining(", ")), Integer.MIN_VALUE, Long.MAX_VALUE, Double.NaN, Float.valueOf(Float.NEGATIVE_INFINITY), false, "ZERO", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("0001-01-01T00:00:00.923")), "X'65683F'".getBytes(StandardCharsets.UTF_8));
    }

    private void testAllDataTypes(String stringData, Integer integerData, Long longData, Double doubleData, Float floatData, Boolean booleanData, String enumData, SqlTimestamp sqlTimestamp, byte[] bytesData) throws Exception {
        DecoderTestColumnHandle stringColumn = new DecoderTestColumnHandle(0, "stringColumn", (Type)VarcharType.createVarcharType((int)30000), "stringColumn", null, null, false, false, false);
        DecoderTestColumnHandle integerColumn = new DecoderTestColumnHandle(1, "integerColumn", (Type)IntegerType.INTEGER, "integerColumn", null, null, false, false, false);
        DecoderTestColumnHandle longColumn = new DecoderTestColumnHandle(2, "longColumn", (Type)BigintType.BIGINT, "longColumn", null, null, false, false, false);
        DecoderTestColumnHandle doubleColumn = new DecoderTestColumnHandle(3, "doubleColumn", (Type)DoubleType.DOUBLE, "doubleColumn", null, null, false, false, false);
        DecoderTestColumnHandle floatColumn = new DecoderTestColumnHandle(4, "floatColumn", (Type)RealType.REAL, "floatColumn", null, null, false, false, false);
        DecoderTestColumnHandle booleanColumn = new DecoderTestColumnHandle(5, "booleanColumn", (Type)BooleanType.BOOLEAN, "booleanColumn", null, null, false, false, false);
        DecoderTestColumnHandle numberColumn = new DecoderTestColumnHandle(6, "numberColumn", (Type)VarcharType.createVarcharType((int)4), "numberColumn", null, null, false, false, false);
        DecoderTestColumnHandle timestampColumn = new DecoderTestColumnHandle(7, "timestampColumn", (Type)TimestampType.createTimestampType((int)3), "timestampColumn", null, null, false, false, false);
        DecoderTestColumnHandle bytesColumn = new DecoderTestColumnHandle(8, "bytesColumn", (Type)VarbinaryType.VARBINARY, "bytesColumn", null, null, false, false, false);
        Descriptors.Descriptor descriptor = this.getDescriptor("all_datatypes.proto");
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        messageBuilder.setField(descriptor.findFieldByName("stringColumn"), (Object)stringData);
        messageBuilder.setField(descriptor.findFieldByName("integerColumn"), (Object)integerData);
        messageBuilder.setField(descriptor.findFieldByName("longColumn"), (Object)longData);
        messageBuilder.setField(descriptor.findFieldByName("doubleColumn"), (Object)doubleData);
        messageBuilder.setField(descriptor.findFieldByName("floatColumn"), (Object)floatData);
        messageBuilder.setField(descriptor.findFieldByName("booleanColumn"), (Object)booleanData);
        messageBuilder.setField(descriptor.findFieldByName("numberColumn"), (Object)descriptor.findEnumTypeByName("Number").findValueByName(enumData));
        messageBuilder.setField(descriptor.findFieldByName("timestampColumn"), (Object)this.getTimestamp(sqlTimestamp));
        messageBuilder.setField(descriptor.findFieldByName("bytesColumn"), (Object)bytesData);
        Map decodedRow = (Map)this.createRowDecoder("all_datatypes.proto", (Set<DecoderColumnHandle>)ImmutableSet.of((Object)stringColumn, (Object)integerColumn, (Object)longColumn, (Object)doubleColumn, (Object)floatColumn, (Object)booleanColumn, (Object[])new DecoderColumnHandle[]{numberColumn, timestampColumn, bytesColumn})).decodeRow(messageBuilder.build().toByteArray()).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(9);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)stringColumn, stringData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)integerColumn, integerData.intValue());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)longColumn, longData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)doubleColumn, doubleData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)floatColumn, floatData.floatValue());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)booleanColumn, booleanData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)numberColumn, enumData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)timestampColumn, sqlTimestamp.getEpochMicros());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)bytesColumn, Slices.wrappedBuffer((byte[])bytesData));
    }

    @Test
    public void testOneofFixedSchemaProvider() throws Exception {
        Set<String> oneofColumnNames = Set.of("stringColumn", "integerColumn", "longColumn", "doubleColumn", "floatColumn", "booleanColumn", "numberColumn", "timestampColumn", "bytesColumn", "rowColumn", "nestedRowColumn");
        Descriptors.Descriptor descriptor = this.getDescriptor("test_oneof.proto");
        for (String oneofColumnName : oneofColumnNames) {
            Assertions.assertThat((Comparable)descriptor.findFieldByName(oneofColumnName)).isNull();
        }
    }

    @Test
    public void testOneofConfluentSchemaProvider() throws Exception {
        String stringData = "Trino";
        int integerData = 1;
        long longData = 493857959588286460L;
        double doubleData = Math.PI;
        float floatData = 3.14f;
        boolean booleanData = true;
        String enumData = "ONE";
        SqlTimestamp sqlTimestamp = DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("2020-12-12T15:35:45.923"));
        byte[] bytesData = "X'65683F'".getBytes(StandardCharsets.UTF_8);
        Descriptors.Descriptor descriptor = ((ProtobufSchema)new ProtobufSchemaProvider().parseSchema(Resources.toString((URL)Resources.getResource((String)"decoder/protobuf/test_oneof.proto"), (Charset)StandardCharsets.UTF_8), List.of(), true).get()).toDescriptor();
        Descriptors.Descriptor rowDescriptor = descriptor.findNestedTypeByName("Row");
        DynamicMessage.Builder rowBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)rowDescriptor);
        rowBuilder.setField(rowDescriptor.findFieldByName("string_column"), (Object)stringData);
        rowBuilder.setField(rowDescriptor.findFieldByName("integer_column"), (Object)integerData);
        rowBuilder.setField(rowDescriptor.findFieldByName("long_column"), (Object)longData);
        rowBuilder.setField(rowDescriptor.findFieldByName("double_column"), (Object)doubleData);
        rowBuilder.setField(rowDescriptor.findFieldByName("float_column"), (Object)Float.valueOf(floatData));
        rowBuilder.setField(rowDescriptor.findFieldByName("boolean_column"), (Object)booleanData);
        rowBuilder.setField(rowDescriptor.findFieldByName("number_column"), (Object)descriptor.findEnumTypeByName("Number").findValueByName(enumData));
        rowBuilder.setField(rowDescriptor.findFieldByName("timestamp_column"), (Object)this.getTimestamp(sqlTimestamp));
        rowBuilder.setField(rowDescriptor.findFieldByName("bytes_column"), (Object)bytesData);
        DynamicMessage.Builder rowMessage = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("rowColumn"), (Object)rowBuilder.build());
        ImmutableMap expectedRowMessageValue = ImmutableMap.of((Object)"stringColumn", (Object)"Trino", (Object)"integerColumn", (Object)1, (Object)"longColumn", (Object)"493857959588286460", (Object)"doubleColumn", (Object)Math.PI, (Object)"floatColumn", (Object)3.14, (Object)"booleanColumn", (Object)true, (Object)"numberColumn", (Object)"ONE", (Object)"timestampColumn", (Object)"2020-12-12T15:35:45.923Z", (Object)"bytesColumn", (Object)"WCc2NTY4M0Yn");
        Descriptors.Descriptor nestedDescriptor = descriptor.findNestedTypeByName("NestedRow");
        DynamicMessage.Builder nestedMessageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)nestedDescriptor);
        nestedMessageBuilder.setField(nestedDescriptor.findFieldByName("nested_list"), (Object)ImmutableList.of((Object)rowBuilder.build()));
        Descriptors.Descriptor mapDescriptor = nestedDescriptor.findFieldByName("nested_map").getMessageType();
        DynamicMessage.Builder mapBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)mapDescriptor);
        mapBuilder.setField(mapDescriptor.findFieldByName("key"), (Object)"Key");
        mapBuilder.setField(mapDescriptor.findFieldByName("value"), (Object)rowBuilder.build());
        nestedMessageBuilder.setField(nestedDescriptor.findFieldByName("nested_map"), (Object)ImmutableList.of((Object)mapBuilder.build()));
        nestedMessageBuilder.setField(nestedDescriptor.findFieldByName("row"), (Object)rowBuilder.build());
        DynamicMessage nestedMessage = nestedMessageBuilder.build();
        this.assertOneof(DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor), Map.of());
        DynamicMessage.Builder message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("stringColumn"), (Object)stringData);
        this.assertOneof(message, Map.of("stringColumn", stringData));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("integerColumn"), (Object)integerData);
        this.assertOneof(message, Map.of("integerColumn", integerData));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("longColumn"), (Object)longData);
        this.assertOneof(message, Map.of("longColumn", Long.toString(longData)));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("doubleColumn"), (Object)doubleData);
        this.assertOneof(message, Map.of("doubleColumn", doubleData));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("floatColumn"), (Object)Float.valueOf(floatData));
        this.assertOneof(message, Map.of("floatColumn", Float.valueOf(floatData)));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("booleanColumn"), (Object)booleanData);
        this.assertOneof(message, Map.of("booleanColumn", booleanData));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("numberColumn"), (Object)descriptor.findEnumTypeByName("Number").findValueByName(enumData));
        this.assertOneof(message, Map.of("numberColumn", enumData));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("timestampColumn"), (Object)this.getTimestamp(sqlTimestamp));
        this.assertOneof(message, Map.of("timestampColumn", "2020-12-12T15:35:45.923Z"));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("bytesColumn"), (Object)bytesData);
        this.assertOneof(message, Map.of("bytesColumn", bytesData));
        this.assertOneof(rowMessage, Map.of("rowColumn", expectedRowMessageValue));
        message = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor).setField(descriptor.findFieldByName("nestedRowColumn"), (Object)nestedMessage);
        this.assertOneof(message, Map.of("nestedRowColumn", ImmutableMap.of((Object)"nestedList", List.of(expectedRowMessageValue), (Object)"nestedMap", (Object)ImmutableMap.of((Object)"Key", (Object)expectedRowMessageValue), (Object)"row", (Object)expectedRowMessageValue)));
    }

    private void assertOneof(DynamicMessage.Builder messageBuilder, Map<String, Object> setValue) throws Exception {
        DecoderTestColumnHandle testColumnHandle = new DecoderTestColumnHandle(0, "column", (Type)VarcharType.VARCHAR, "column", null, null, false, false, false);
        DecoderTestColumnHandle testOneofColumn = new DecoderTestColumnHandle(1, "testOneofColumn", (Type)JsonType.JSON, "testOneofColumn", null, null, false, false, false);
        DynamicMessage message = messageBuilder.setField(messageBuilder.getDescriptorForType().findFieldByName("column"), (Object)"value").build();
        Descriptors.Descriptor descriptor = ProtobufSchemaUtils.getSchema((Message)message).toDescriptor();
        ProtobufRowDecoder decoder = new ProtobufRowDecoder((DynamicMessageProvider)new FixedSchemaDynamicMessageProvider(descriptor), (Set)ImmutableSet.of((Object)testColumnHandle, (Object)testOneofColumn), InternalTypeManager.TESTING_TYPE_MANAGER, (DescriptorProvider)new FileDescriptorProvider());
        Map decodedRow = (Map)decoder.decodeRow(message.toByteArray()).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(2);
        ObjectMapper obj = new ObjectMapper();
        String expected = obj.writeValueAsString(setValue);
        Assertions.assertThat((String)((FieldValueProvider)decodedRow.get(testColumnHandle)).getSlice().toStringUtf8()).isEqualTo("value");
        Assertions.assertThat((String)((FieldValueProvider)decodedRow.get(testOneofColumn)).getSlice().toStringUtf8()).isEqualTo(expected);
    }

    @Test
    public void testAnyTypeWithDummyDescriptor() throws Exception {
        String stringData = "Trino";
        Descriptors.Descriptor allDataTypesDescriptor = this.getDescriptor("all_datatypes.proto");
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)allDataTypesDescriptor);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("stringColumn"), (Object)stringData);
        Descriptors.Descriptor anyTypeDescriptor = this.getDescriptor("test_any.proto");
        DynamicMessage.Builder testAnyBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)anyTypeDescriptor);
        testAnyBuilder.setField(anyTypeDescriptor.findFieldByName("id"), (Object)1);
        testAnyBuilder.setField(anyTypeDescriptor.findFieldByName("anyMessage"), (Object)Any.pack((Message)messageBuilder.build()));
        DynamicMessage testAny = testAnyBuilder.build();
        DecoderTestColumnHandle testAnyColumn = new DecoderTestColumnHandle(0, "anyMessage", (Type)JsonType.JSON, "anyMessage", null, null, false, false, false);
        ProtobufRowDecoder decoder = new ProtobufRowDecoder((DynamicMessageProvider)new FixedSchemaDynamicMessageProvider(anyTypeDescriptor), (Set)ImmutableSet.of((Object)testAnyColumn), InternalTypeManager.TESTING_TYPE_MANAGER, (DescriptorProvider)new DummyDescriptorProvider());
        Map decodedRow = (Map)decoder.decodeRow(testAny.toByteArray()).orElseThrow(AssertionError::new);
        Assertions.assertThat((boolean)((FieldValueProvider)decodedRow.get(testAnyColumn)).isNull()).isTrue();
    }

    @Test
    public void testAnyTypeWithFileDescriptor() throws Exception {
        String stringData = "Trino";
        int integerData = 1;
        long longData = 493857959588286460L;
        double doubleData = Math.PI;
        float floatData = 3.14f;
        boolean booleanData = true;
        String enumData = "ONE";
        SqlTimestamp sqlTimestamp = DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("2020-12-12T15:35:45.923"));
        byte[] bytesData = "X'65683F'".getBytes(StandardCharsets.UTF_8);
        Descriptors.Descriptor allDataTypesDescriptor = this.getDescriptor("all_datatypes.proto");
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)allDataTypesDescriptor);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("stringColumn"), (Object)stringData);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("integerColumn"), (Object)integerData);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("longColumn"), (Object)longData);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("doubleColumn"), (Object)doubleData);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("floatColumn"), (Object)Float.valueOf(floatData));
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("booleanColumn"), (Object)booleanData);
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("numberColumn"), (Object)allDataTypesDescriptor.findEnumTypeByName("Number").findValueByName(enumData));
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("timestampColumn"), (Object)this.getTimestamp(sqlTimestamp));
        messageBuilder.setField(allDataTypesDescriptor.findFieldByName("bytesColumn"), (Object)bytesData);
        URI anySchemaTypeUrl = new File(Resources.getResource((String)"decoder/protobuf/any/all_datatypes/schema").getFile()).getParentFile().toURI();
        Descriptors.Descriptor descriptor = this.getDescriptor("test_any.proto");
        DynamicMessage.Builder testAnyBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        testAnyBuilder.setField(descriptor.findFieldByName("id"), (Object)1);
        testAnyBuilder.setField(descriptor.findFieldByName("anyMessage"), (Object)Any.pack((Message)messageBuilder.build(), (String)anySchemaTypeUrl.toString()));
        DynamicMessage testAny = testAnyBuilder.build();
        DecoderTestColumnHandle testOneOfColumn = new DecoderTestColumnHandle(0, "anyMessage", (Type)JsonType.JSON, "anyMessage", null, null, false, false, false);
        ProtobufRowDecoder decoder = new ProtobufRowDecoder((DynamicMessageProvider)new FixedSchemaDynamicMessageProvider(descriptor), (Set)ImmutableSet.of((Object)testOneOfColumn), InternalTypeManager.TESTING_TYPE_MANAGER, (DescriptorProvider)new FileDescriptorProvider());
        Map decodedRow = (Map)decoder.decodeRow(testAny.toByteArray()).orElseThrow(AssertionError::new);
        JsonNode actual = new ObjectMapper().readTree(((FieldValueProvider)decodedRow.get(testOneOfColumn)).getSlice().toStringUtf8());
        Assertions.assertThat((String)actual.get("@type").textValue()).contains(new CharSequence[]{"schema"});
        Assertions.assertThat((String)actual.get("stringColumn").textValue()).isEqualTo(stringData);
        Assertions.assertThat((int)actual.get("integerColumn").intValue()).isEqualTo(integerData);
        Assertions.assertThat((String)actual.get("longColumn").textValue()).isEqualTo(Long.toString(longData));
        Assertions.assertThat((double)actual.get("doubleColumn").doubleValue()).isEqualTo(doubleData);
        Assertions.assertThat((float)actual.get("floatColumn").floatValue()).isEqualTo(floatData);
        Assertions.assertThat((boolean)actual.get("booleanColumn").booleanValue()).isEqualTo(booleanData);
        Assertions.assertThat((String)actual.get("numberColumn").textValue()).isEqualTo(enumData);
        Assertions.assertThat((String)actual.get("timestampColumn").textValue()).isEqualTo("2020-12-12T15:35:45.923Z");
        Assertions.assertThat((byte[])actual.get("bytesColumn").binaryValue()).isEqualTo((Object)bytesData);
    }

    @Test
    public void testStructuralDataTypes() throws Exception {
        this.testStructuralDataTypes("Trino", 1, 493857959588286460L, Math.PI, Float.valueOf(3.14f), true, "ONE", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("2020-12-12T15:35:45.923")), "X'65683F'".getBytes(StandardCharsets.UTF_8));
        this.testStructuralDataTypes(IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", ")), Integer.MAX_VALUE, Long.MIN_VALUE, (Double)Double.MAX_VALUE, Float.valueOf(Float.MIN_VALUE), false, "ZERO", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("1856-01-12T05:25:14.456")), new byte[0]);
        this.testStructuralDataTypes(IntStream.range(5000, 10000).mapToObj(Integer::toString).collect(Collectors.joining(", ")), Integer.MIN_VALUE, Long.MAX_VALUE, Double.NaN, Float.valueOf(Float.NEGATIVE_INFINITY), false, "ZERO", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("0001-01-01T00:00:00.923")), "X'65683F'".getBytes(StandardCharsets.UTF_8));
    }

    private void testStructuralDataTypes(String stringData, Integer integerData, Long longData, Double doubleData, Float floatData, Boolean booleanData, String enumData, SqlTimestamp sqlTimestamp, byte[] bytesData) throws Exception {
        DecoderTestColumnHandle listColumn = new DecoderTestColumnHandle(0, "list", (Type)new ArrayType((Type)VarcharType.createVarcharType((int)100)), "list", null, null, false, false, false);
        DecoderTestColumnHandle mapColumn = new DecoderTestColumnHandle(1, "map", InternalTypeManager.TESTING_TYPE_MANAGER.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())), "map", null, null, false, false, false);
        DecoderTestColumnHandle rowColumn = new DecoderTestColumnHandle(2, "row", (Type)RowType.from((List)ImmutableList.builder().add((Object)RowType.field((String)"string_column", (Type)VarcharType.createVarcharType((int)30000))).add((Object)RowType.field((String)"integer_column", (Type)IntegerType.INTEGER)).add((Object)RowType.field((String)"long_column", (Type)BigintType.BIGINT)).add((Object)RowType.field((String)"double_column", (Type)DoubleType.DOUBLE)).add((Object)RowType.field((String)"float_column", (Type)RealType.REAL)).add((Object)RowType.field((String)"boolean_column", (Type)BooleanType.BOOLEAN)).add((Object)RowType.field((String)"number_column", (Type)VarcharType.createVarcharType((int)4))).add((Object)RowType.field((String)"timestamp_column", (Type)TimestampType.createTimestampType((int)6))).add((Object)RowType.field((String)"bytes_column", (Type)VarbinaryType.VARBINARY)).build()), "row", null, null, false, false, false);
        Descriptors.Descriptor descriptor = this.getDescriptor("structural_datatypes.proto");
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        messageBuilder.setField(descriptor.findFieldByName("list"), (Object)ImmutableList.of((Object)"Presto"));
        Descriptors.Descriptor mapDescriptor = descriptor.findFieldByName("map").getMessageType();
        DynamicMessage.Builder mapBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)mapDescriptor);
        mapBuilder.setField(mapDescriptor.findFieldByName("key"), (Object)"Key");
        mapBuilder.setField(mapDescriptor.findFieldByName("value"), (Object)"Value");
        messageBuilder.setField(descriptor.findFieldByName("map"), (Object)ImmutableList.of((Object)mapBuilder.build()));
        Descriptors.Descriptor rowDescriptor = descriptor.findFieldByName("row").getMessageType();
        DynamicMessage.Builder rowBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)rowDescriptor);
        rowBuilder.setField(rowDescriptor.findFieldByName("string_column"), (Object)stringData);
        rowBuilder.setField(rowDescriptor.findFieldByName("integer_column"), (Object)integerData);
        rowBuilder.setField(rowDescriptor.findFieldByName("long_column"), (Object)longData);
        rowBuilder.setField(rowDescriptor.findFieldByName("double_column"), (Object)doubleData);
        rowBuilder.setField(rowDescriptor.findFieldByName("float_column"), (Object)floatData);
        rowBuilder.setField(rowDescriptor.findFieldByName("boolean_column"), (Object)booleanData);
        rowBuilder.setField(rowDescriptor.findFieldByName("number_column"), (Object)descriptor.findEnumTypeByName("Number").findValueByName(enumData));
        rowBuilder.setField(rowDescriptor.findFieldByName("timestamp_column"), (Object)this.getTimestamp(sqlTimestamp));
        rowBuilder.setField(rowDescriptor.findFieldByName("bytes_column"), (Object)bytesData);
        messageBuilder.setField(descriptor.findFieldByName("row"), (Object)rowBuilder.build());
        Map decodedRow = (Map)this.createRowDecoder("structural_datatypes.proto", (Set<DecoderColumnHandle>)ImmutableSet.of((Object)listColumn, (Object)mapColumn, (Object)rowColumn)).decodeRow(messageBuilder.build().toByteArray()).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(3);
        Block listBlock = (Block)((FieldValueProvider)decodedRow.get(listColumn)).getObject();
        Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(listBlock, 0).toStringUtf8()).isEqualTo("Presto");
        SqlMap sqlMap = (SqlMap)((FieldValueProvider)decodedRow.get(mapColumn)).getObject();
        Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(sqlMap.getRawKeyBlock(), sqlMap.getRawOffset()).toStringUtf8()).isEqualTo("Key");
        Assertions.assertThat((String)VarcharType.VARCHAR.getSlice(sqlMap.getRawValueBlock(), sqlMap.getRawOffset()).toStringUtf8()).isEqualTo("Value");
        SqlRow sqlRow = (SqlRow)((FieldValueProvider)decodedRow.get(rowColumn)).getObject();
        int rawIndex = sqlRow.getRawIndex();
        ConnectorSession session = TestingSession.testSessionBuilder().build().toConnectorSession();
        Assertions.assertThat((Object)VarcharType.VARCHAR.getObjectValue(session, sqlRow.getRawFieldBlock(0), rawIndex)).isEqualTo((Object)stringData);
        Assertions.assertThat((Object)IntegerType.INTEGER.getObjectValue(session, sqlRow.getRawFieldBlock(1), rawIndex)).isEqualTo((Object)integerData);
        Assertions.assertThat((Object)BigintType.BIGINT.getObjectValue(session, sqlRow.getRawFieldBlock(2), rawIndex)).isEqualTo((Object)longData);
        Assertions.assertThat((Object)DoubleType.DOUBLE.getObjectValue(session, sqlRow.getRawFieldBlock(3), rawIndex)).isEqualTo((Object)doubleData);
        Assertions.assertThat((Object)RealType.REAL.getObjectValue(session, sqlRow.getRawFieldBlock(4), rawIndex)).isEqualTo((Object)floatData);
        Assertions.assertThat((Object)BooleanType.BOOLEAN.getObjectValue(session, sqlRow.getRawFieldBlock(5), rawIndex)).isEqualTo((Object)booleanData);
        Assertions.assertThat((Object)VarcharType.VARCHAR.getObjectValue(session, sqlRow.getRawFieldBlock(6), rawIndex)).isEqualTo((Object)enumData);
        Assertions.assertThat((Object)TimestampType.TIMESTAMP_MICROS.getObjectValue(session, sqlRow.getRawFieldBlock(7), rawIndex)).isEqualTo((Object)sqlTimestamp.roundTo(6));
        Assertions.assertThat((Object)VarbinaryType.VARBINARY.getObjectValue(session, sqlRow.getRawFieldBlock(8), rawIndex)).isEqualTo((Object)new SqlVarbinary(bytesData));
    }

    @Test
    public void testMissingFieldInRowType() throws Exception {
        DecoderTestColumnHandle rowColumn = new DecoderTestColumnHandle(2, "row", (Type)RowType.from((List)ImmutableList.of((Object)RowType.field((String)"unknown_mapping", (Type)VarcharType.createVarcharType((int)30000)))), "row", null, null, false, false, false);
        Descriptors.Descriptor descriptor = this.getDescriptor("structural_datatypes.proto");
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        Descriptors.Descriptor rowDescriptor = descriptor.findFieldByName("row").getMessageType();
        DynamicMessage.Builder rowBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)rowDescriptor);
        rowBuilder.setField(rowDescriptor.findFieldByName("string_column"), (Object)"Test");
        messageBuilder.setField(descriptor.findFieldByName("row"), (Object)rowBuilder.build());
        Map decodedRow = (Map)this.createRowDecoder("structural_datatypes.proto", (Set<DecoderColumnHandle>)ImmutableSet.of((Object)rowColumn)).decodeRow(messageBuilder.build().toByteArray()).orElseThrow(AssertionError::new);
        Assertions.assertThatThrownBy(() -> ((FieldValueProvider)decodedRow.get(rowColumn)).getObject()).hasMessageMatching("Unknown Field unknown_mapping");
    }

    @Test
    public void testRowFlattening() throws Exception {
        this.testRowFlattening("Trino", 1, 493857959588286460L, Math.PI, Float.valueOf(3.14f), true, "ONE", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("2020-12-12T15:35:45.923")), "X'65683F'".getBytes(StandardCharsets.UTF_8));
        this.testRowFlattening(IntStream.range(0, 5000).mapToObj(Integer::toString).collect(Collectors.joining(", ")), Integer.MAX_VALUE, Long.MIN_VALUE, (Double)Double.MAX_VALUE, Float.valueOf(Float.MIN_VALUE), false, "ZERO", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("1856-01-12T05:25:14.456")), new byte[0]);
        this.testRowFlattening(IntStream.range(5000, 10000).mapToObj(Integer::toString).collect(Collectors.joining(", ")), Integer.MIN_VALUE, Long.MAX_VALUE, Double.NaN, Float.valueOf(Float.NEGATIVE_INFINITY), false, "ZERO", DateTimeTestingUtils.sqlTimestampOf((int)3, (LocalDateTime)LocalDateTime.parse("0001-01-01T00:00:00.923")), "X'65683F'".getBytes(StandardCharsets.UTF_8));
    }

    private void testRowFlattening(String stringData, Integer integerData, Long longData, Double doubleData, Float floatData, Boolean booleanData, String enumData, SqlTimestamp sqlTimestamp, byte[] bytesData) throws Exception {
        DecoderTestColumnHandle stringColumn = new DecoderTestColumnHandle(0, "stringColumn", (Type)VarcharType.createVarcharType((int)30000), "row/string_column", null, null, false, false, false);
        DecoderTestColumnHandle integerColumn = new DecoderTestColumnHandle(1, "integerColumn", (Type)IntegerType.INTEGER, "row/integer_column", null, null, false, false, false);
        DecoderTestColumnHandle longColumn = new DecoderTestColumnHandle(2, "longColumn", (Type)BigintType.BIGINT, "row/long_column", null, null, false, false, false);
        DecoderTestColumnHandle doubleColumn = new DecoderTestColumnHandle(3, "doubleColumn", (Type)DoubleType.DOUBLE, "row/double_column", null, null, false, false, false);
        DecoderTestColumnHandle floatColumn = new DecoderTestColumnHandle(4, "floatColumn", (Type)RealType.REAL, "row/float_column", null, null, false, false, false);
        DecoderTestColumnHandle booleanColumn = new DecoderTestColumnHandle(5, "booleanColumn", (Type)BooleanType.BOOLEAN, "row/boolean_column", null, null, false, false, false);
        DecoderTestColumnHandle numberColumn = new DecoderTestColumnHandle(6, "numberColumn", (Type)VarcharType.createVarcharType((int)4), "row/number_column", null, null, false, false, false);
        DecoderTestColumnHandle timestampColumn = new DecoderTestColumnHandle(6, "timestampColumn", (Type)TimestampType.createTimestampType((int)3), "row/timestamp_column", null, null, false, false, false);
        DecoderTestColumnHandle bytesColumn = new DecoderTestColumnHandle(5, "bytesColumn", (Type)VarbinaryType.VARBINARY, "row/bytes_column", null, null, false, false, false);
        Descriptors.Descriptor descriptor = this.getDescriptor("structural_datatypes.proto");
        DynamicMessage.Builder messageBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        Descriptors.Descriptor rowDescriptor = descriptor.findNestedTypeByName("Row");
        DynamicMessage.Builder rowBuilder = DynamicMessage.newBuilder((Descriptors.Descriptor)rowDescriptor);
        rowBuilder.setField(rowDescriptor.findFieldByName("string_column"), (Object)stringData);
        rowBuilder.setField(rowDescriptor.findFieldByName("integer_column"), (Object)integerData);
        rowBuilder.setField(rowDescriptor.findFieldByName("long_column"), (Object)longData);
        rowBuilder.setField(rowDescriptor.findFieldByName("double_column"), (Object)doubleData);
        rowBuilder.setField(rowDescriptor.findFieldByName("float_column"), (Object)floatData);
        rowBuilder.setField(rowDescriptor.findFieldByName("boolean_column"), (Object)booleanData);
        rowBuilder.setField(rowDescriptor.findFieldByName("number_column"), (Object)descriptor.findEnumTypeByName("Number").findValueByName(enumData));
        rowBuilder.setField(rowDescriptor.findFieldByName("timestamp_column"), (Object)this.getTimestamp(sqlTimestamp));
        rowBuilder.setField(rowDescriptor.findFieldByName("bytes_column"), (Object)bytesData);
        messageBuilder.setField(descriptor.findFieldByName("row"), (Object)rowBuilder.build());
        Map decodedRow = (Map)this.createRowDecoder("structural_datatypes.proto", (Set<DecoderColumnHandle>)ImmutableSet.of((Object)stringColumn, (Object)integerColumn, (Object)longColumn, (Object)doubleColumn, (Object)floatColumn, (Object)booleanColumn, (Object[])new DecoderColumnHandle[]{numberColumn, timestampColumn, bytesColumn})).decodeRow(messageBuilder.build().toByteArray()).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(9);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)stringColumn, stringData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)integerColumn, integerData.intValue());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)longColumn, longData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)doubleColumn, doubleData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)floatColumn, floatData.floatValue());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)booleanColumn, booleanData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)numberColumn, enumData);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)timestampColumn, sqlTimestamp.getEpochMicros());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)bytesColumn, Slices.wrappedBuffer((byte[])bytesData));
    }

    private Timestamp getTimestamp(SqlTimestamp sqlTimestamp) {
        return Timestamp.newBuilder().setSeconds(Math.floorDiv(sqlTimestamp.getEpochMicros(), 1000000)).setNanos(Math.floorMod(sqlTimestamp.getEpochMicros(), 1000000) * 1000).build();
    }

    private RowDecoder createRowDecoder(String fileName, Set<DecoderColumnHandle> columns) throws Exception {
        return DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("protobuf", (Map)ImmutableMap.of((Object)"dataSchema", (Object)ProtobufUtils.getProtoFile((String)("decoder/protobuf/" + fileName))), columns));
    }

    private Descriptors.Descriptor getDescriptor(String fileName) throws Exception {
        return ProtobufUtils.getFileDescriptor((String)ProtobufUtils.getProtoFile((String)("decoder/protobuf/" + fileName))).findMessageTypeByName("schema");
    }
}

