/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.raw;

import com.google.common.collect.ImmutableSet;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.DecoderTestColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.decoder.RowDecoder;
import io.trino.decoder.RowDecoderSpec;
import io.trino.decoder.raw.RawRowDecoderFactory;
import io.trino.decoder.util.DecoderTestUtil;
import io.trino.spi.TrinoException;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.DoubleType;
import io.trino.spi.type.IntegerType;
import io.trino.spi.type.RealType;
import io.trino.spi.type.SmallintType;
import io.trino.spi.type.TinyintType;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarbinaryType;
import io.trino.spi.type.VarcharType;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ThrowableAssert;
import org.junit.jupiter.api.Test;

public class TestRawDecoder {
    private static final RawRowDecoderFactory DECODER_FACTORY = new RawRowDecoderFactory();

    @Test
    public void testEmptyRecord() {
        byte[] emptyRow = new byte[]{};
        DecoderTestColumnHandle column = new DecoderTestColumnHandle(0, "row1", (Type)VarcharType.createUnboundedVarcharType(), null, "BYTE", null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)column);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(emptyRow).orElseThrow(AssertionError::new);
        DecoderTestUtil.checkIsNull(decodedRow, column);
    }

    @Test
    public void testSimple() {
        ByteBuffer buf = ByteBuffer.allocate(36);
        buf.putLong(4815162342L);
        buf.putInt(12345678);
        buf.putShort((short)4567);
        buf.put((byte)123);
        buf.put("Ich bin zwei Oeltanks".getBytes(StandardCharsets.UTF_8));
        byte[] row = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, row, 0, buf.position());
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)BigintType.BIGINT, "0", "LONG", null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)BigintType.BIGINT, "8", "INT", null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)BigintType.BIGINT, "12", "SHORT", null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)BigintType.BIGINT, "14", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row5 = new DecoderTestColumnHandle(4, "row5", (Type)VarcharType.createVarcharType((int)10), "15", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row1, (Object)row2, (Object)row3, (Object)row4, (Object)row5);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(row).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row1, 4815162342L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row2, 12345678L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row3, 4567L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row4, 123L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row5, "Ich bin zw");
    }

    @Test
    public void testFixedWithString() {
        String str = "Ich bin zwei Oeltanks";
        byte[] row = str.getBytes(StandardCharsets.UTF_8);
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)VarcharType.createVarcharType((int)100), null, null, null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)VarcharType.createVarcharType((int)100), "0", null, null, false, false, false);
        DecoderTestColumnHandle row3 = new DecoderTestColumnHandle(2, "row3", (Type)VarcharType.createVarcharType((int)100), "0:4", null, null, false, false, false);
        DecoderTestColumnHandle row4 = new DecoderTestColumnHandle(3, "row4", (Type)VarcharType.createVarcharType((int)100), "5:8", null, null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row1, (Object)row2, (Object)row3, (Object)row4);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(row).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row1, str);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row2, str);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row3, str.substring(0, 4));
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row4, str.substring(5, 8));
    }

    @Test
    public void testFloatStuff() {
        ByteBuffer buf = ByteBuffer.allocate(20);
        buf.putDouble(Math.PI);
        buf.putFloat((float)Math.E);
        buf.putDouble(Math.E);
        byte[] row = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, row, 0, buf.position());
        DecoderTestColumnHandle row1 = new DecoderTestColumnHandle(0, "row1", (Type)DoubleType.DOUBLE, null, "DOUBLE", null, false, false, false);
        DecoderTestColumnHandle row2 = new DecoderTestColumnHandle(1, "row2", (Type)DoubleType.DOUBLE, "8", "FLOAT", null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row1, (Object)row2);
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(row).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row1, Math.PI);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row2, Math.E);
    }

    @Test
    public void testBooleanStuff() {
        ByteBuffer buf = ByteBuffer.allocate(38);
        buf.put((byte)127);
        buf.putLong(0L);
        buf.put((byte)126);
        buf.putLong(1L);
        buf.put((byte)125);
        buf.putInt(0);
        buf.put((byte)124);
        buf.putInt(1);
        buf.put((byte)123);
        buf.putShort((short)0);
        buf.put((byte)122);
        buf.putShort((short)1);
        buf.put((byte)121);
        buf.put((byte)0);
        buf.put((byte)120);
        buf.put((byte)1);
        byte[] row = new byte[buf.position()];
        System.arraycopy(buf.array(), 0, row, 0, buf.position());
        DecoderTestColumnHandle row01 = new DecoderTestColumnHandle(0, "row01", (Type)BigintType.BIGINT, "0", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row02 = new DecoderTestColumnHandle(1, "row02", (Type)BooleanType.BOOLEAN, "1", "LONG", null, false, false, false);
        DecoderTestColumnHandle row03 = new DecoderTestColumnHandle(2, "row03", (Type)BigintType.BIGINT, "9", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row04 = new DecoderTestColumnHandle(3, "row04", (Type)BooleanType.BOOLEAN, "10", "LONG", null, false, false, false);
        DecoderTestColumnHandle row11 = new DecoderTestColumnHandle(4, "row11", (Type)BigintType.BIGINT, "18", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row12 = new DecoderTestColumnHandle(5, "row12", (Type)BooleanType.BOOLEAN, "19", "INT", null, false, false, false);
        DecoderTestColumnHandle row13 = new DecoderTestColumnHandle(6, "row13", (Type)BigintType.BIGINT, "23", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row14 = new DecoderTestColumnHandle(7, "row14", (Type)BooleanType.BOOLEAN, "24", "INT", null, false, false, false);
        DecoderTestColumnHandle row21 = new DecoderTestColumnHandle(8, "row21", (Type)BigintType.BIGINT, "28", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row22 = new DecoderTestColumnHandle(9, "row22", (Type)BooleanType.BOOLEAN, "29", "SHORT", null, false, false, false);
        DecoderTestColumnHandle row23 = new DecoderTestColumnHandle(10, "row23", (Type)BigintType.BIGINT, "31", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row24 = new DecoderTestColumnHandle(11, "row24", (Type)BooleanType.BOOLEAN, "32", "SHORT", null, false, false, false);
        DecoderTestColumnHandle row31 = new DecoderTestColumnHandle(12, "row31", (Type)BigintType.BIGINT, "34", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row32 = new DecoderTestColumnHandle(13, "row32", (Type)BooleanType.BOOLEAN, "35", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row33 = new DecoderTestColumnHandle(14, "row33", (Type)BigintType.BIGINT, "36", "BYTE", null, false, false, false);
        DecoderTestColumnHandle row34 = new DecoderTestColumnHandle(15, "row34", (Type)BooleanType.BOOLEAN, "37", "BYTE", null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)row01, (Object)row02, (Object)row03, (Object)row04, (Object)row11, (Object)row12, (Object[])new DecoderColumnHandle[]{row13, row14, row21, row22, row23, row24, row31, row32, row33, row34});
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(row).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row01, 127L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row02, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row03, 126L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row04, true);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row11, 125L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row12, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row13, 124L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row14, true);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row21, 123L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row22, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row23, 122L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row24, true);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row31, 121L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row32, false);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row33, 120L);
        DecoderTestUtil.checkValue((Map<DecoderColumnHandle, FieldValueProvider>)decodedRow, (DecoderColumnHandle)row34, true);
    }

    @Test
    public void testMappingForFixedWidthTypesValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "BYTE");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0:1", "BYTE");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:0", "BYTE"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:2", "BYTE"));
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "SHORT");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0:2", "SHORT");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:1", "SHORT"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:3", "SHORT"));
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "INT");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0:4", "INT");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:3", "INT"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:5", "INT"));
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "LONG");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0:8", "LONG");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:7", "LONG"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:9", "LONG"));
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "LONG");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0:8", "LONG");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:7", "LONG"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0:9", "LONG"));
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "FLOAT");
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0:4", "FLOAT");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0:3", "FLOAT"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0:5", "FLOAT"));
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "DOUBLE");
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0:8", "DOUBLE");
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0:7", "DOUBLE"));
        this.assertMappingDoesNotMatchDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0:9", "DOUBLE"));
    }

    private void assertMappingDoesNotMatchDataFormatException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(TrinoException.class)).hasMessageContaining("Bytes mapping for column 'some_column' does not match dataFormat");
    }

    @Test
    public void testInvalidMapping() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "x", "DOUBLE")).isInstanceOf(TrinoException.class)).hasMessageContaining("invalid mapping format 'x' for column 'some_column'");
    }

    @Test
    public void testInvalidDataFormat() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "format", null, false, false, false)).isInstanceOf(TrinoException.class)).hasMessageMatching("invalid dataFormat 'format' for column 'some_column'");
    }

    @Test
    public void testInvalidExtraneousParameters() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", null, "hint", false, false, false)).isInstanceOf(TrinoException.class)).hasMessageMatching("unexpected format hint 'hint' defined for column 'some_column'");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", null, null, false, false, true)).isInstanceOf(TrinoException.class)).hasMessageMatching("unexpected internal column 'some_column'");
    }

    @Test
    public void testTypeMatchesDataFormatValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "BYTE");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "SHORT");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "INT");
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "LONG");
        this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "BYTE");
        this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "SHORT");
        this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "INT");
        this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "BYTE");
        this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "SHORT");
        this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "BYTE");
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN, "0", "BYTE");
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN, "0", "SHORT");
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN, "0", "INT");
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN, "0", "LONG");
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "DOUBLE");
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "FLOAT");
        this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType(), "0", "BYTE");
        this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "BYTE");
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "FLOAT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "DOUBLE"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "FLOAT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "DOUBLE"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "LONG"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "FLOAT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "DOUBLE"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "LONG"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "INT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "FLOAT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "DOUBLE"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "LONG"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "INT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "SHORT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "LONG"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "INT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "SHORT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "BYTE"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "FLOAT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "DOUBLE"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "LONG"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "INT"));
        this.assertWrongDataFormatException(() -> this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "SHORT"));
    }

    private void assertWrongDataFormatException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(TrinoException.class)).hasMessageMatching("Wrong dataFormat .* specified for column .*");
    }

    @Test
    public void testSupportedDataTypeValidation() {
        this.singleColumnDecoder((Type)BigintType.BIGINT, "0", "LONG");
        this.singleColumnDecoder((Type)IntegerType.INTEGER, "0", "INT");
        this.singleColumnDecoder((Type)SmallintType.SMALLINT, "0", "SHORT");
        this.singleColumnDecoder((Type)TinyintType.TINYINT, "0", "BYTE");
        this.singleColumnDecoder((Type)BooleanType.BOOLEAN, "0", "LONG");
        this.singleColumnDecoder((Type)DoubleType.DOUBLE, "0", "DOUBLE");
        this.singleColumnDecoder((Type)VarcharType.createUnboundedVarcharType(), "0", "BYTE");
        this.singleColumnDecoder((Type)VarcharType.createVarcharType((int)100), "0", "BYTE");
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)RealType.REAL, "0", "BYTE"));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)DecimalType.createDecimalType((int)10, (int)4), "0", "BYTE"));
        this.assertUnsupportedColumnTypeException(() -> this.singleColumnDecoder((Type)VarbinaryType.VARBINARY, "0", "BYTE"));
    }

    @Test
    public void testGetValueTwice() {
        ByteBuffer buf = ByteBuffer.allocate(50);
        buf.putLong(0, 4815162342L);
        buf.putInt(8, Integer.MAX_VALUE);
        buf.putShort(12, (short)Short.MAX_VALUE);
        buf.put(14, (byte)-128);
        buf.putLong(15, 1L);
        buf.putInt(23, 1);
        buf.putShort(27, (short)1);
        buf.put(29, (byte)1);
        buf.putDouble(30, 12345.6789);
        buf.putFloat(38, 123.345f);
        buf.put("test val".getBytes(StandardCharsets.UTF_8));
        byte[] row = new byte[buf.capacity()];
        System.arraycopy(buf.array(), 0, row, 0, buf.limit());
        DecoderTestColumnHandle col1 = new DecoderTestColumnHandle(0, "col1", (Type)BigintType.BIGINT, "0", "LONG", null, false, false, false);
        DecoderTestColumnHandle col2 = new DecoderTestColumnHandle(1, "col2", (Type)BigintType.BIGINT, "8", "INT", null, false, false, false);
        DecoderTestColumnHandle col3 = new DecoderTestColumnHandle(2, "col3", (Type)BigintType.BIGINT, "12", "SHORT", null, false, false, false);
        DecoderTestColumnHandle col4 = new DecoderTestColumnHandle(3, "col4", (Type)BigintType.BIGINT, "14", "BYTE", null, false, false, false);
        DecoderTestColumnHandle col5 = new DecoderTestColumnHandle(4, "col5", (Type)BooleanType.BOOLEAN, "15", "LONG", null, false, false, false);
        DecoderTestColumnHandle col6 = new DecoderTestColumnHandle(5, "col6", (Type)BooleanType.BOOLEAN, "23", "INT", null, false, false, false);
        DecoderTestColumnHandle col7 = new DecoderTestColumnHandle(6, "col7", (Type)BooleanType.BOOLEAN, "27", "SHORT", null, false, false, false);
        DecoderTestColumnHandle col8 = new DecoderTestColumnHandle(7, "col8", (Type)BooleanType.BOOLEAN, "29", "BYTE", null, false, false, false);
        DecoderTestColumnHandle col9 = new DecoderTestColumnHandle(8, "col9", (Type)DoubleType.DOUBLE, "30", "DOUBLE", null, false, false, false);
        DecoderTestColumnHandle col10 = new DecoderTestColumnHandle(9, "col10", (Type)DoubleType.DOUBLE, "38", "FLOAT", null, false, false, false);
        DecoderTestColumnHandle col11 = new DecoderTestColumnHandle(10, "col11", (Type)VarcharType.VARCHAR, "42", "BYTE", null, false, false, false);
        ImmutableSet columns = ImmutableSet.of((Object)col1, (Object)col2, (Object)col3, (Object)col4, (Object)col5, (Object)col6, (Object[])new DecoderColumnHandle[]{col7, col8, col9, col10, col11});
        RowDecoder rowDecoder = DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)columns));
        Map decodedRow = (Map)rowDecoder.decodeRow(row).orElseThrow(AssertionError::new);
        Assertions.assertThat((Map)decodedRow).hasSize(columns.size());
        for (DecoderColumnHandle handle : columns) {
            this.checkTwice(decodedRow, handle);
        }
    }

    private void checkTwice(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Type type = handle.getType();
        if (type == BigintType.BIGINT) {
            Assertions.assertThat((long)provider.getLong()).isEqualTo(provider.getLong());
        } else if (type == BooleanType.BOOLEAN) {
            Assertions.assertThat((boolean)provider.getBoolean()).isEqualTo(provider.getBoolean());
        } else if (type == DoubleType.DOUBLE) {
            Assertions.assertThat((double)provider.getDouble()).isEqualTo(provider.getDouble());
        } else if (type == VarcharType.VARCHAR) {
            Assertions.assertThat((Comparable)provider.getSlice()).isEqualTo((Object)provider.getSlice());
        }
    }

    private void assertUnsupportedColumnTypeException(ThrowableAssert.ThrowingCallable callable) {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy((ThrowableAssert.ThrowingCallable)callable).isInstanceOf(TrinoException.class)).hasMessageMatching("Unsupported column type .* for column .*");
    }

    private void singleColumnDecoder(Type columnType, String mapping, String dataFormat) {
        this.singleColumnDecoder(columnType, mapping, dataFormat, null, false, false, false);
    }

    private void singleColumnDecoder(Type columnType, String mapping, String dataFormat, String formatHint, boolean keyDecoder, boolean hidden, boolean internal) {
        DECODER_FACTORY.create(DecoderTestUtil.TESTING_SESSION, new RowDecoderSpec("raw", Collections.emptyMap(), (Set)ImmutableSet.of((Object)new DecoderTestColumnHandle(0, "some_column", columnType, mapping, dataFormat, formatHint, keyDecoder, hidden, internal))));
    }
}

