/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.util;

import io.airlift.slice.Slice;
import io.trino.decoder.DecoderColumnHandle;
import io.trino.decoder.FieldValueProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.testing.TestingConnectorSession;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.assertj.core.data.Offset;

public final class DecoderTestUtil {
    public static final ConnectorSession TESTING_SESSION = TestingConnectorSession.builder().build();

    private DecoderTestUtil() {
    }

    public static void checkValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, Slice value) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((Comparable)provider.getSlice()).isEqualTo((Object)value);
    }

    public static void checkValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, String value) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((String)provider.getSlice().toStringUtf8()).isEqualTo(value);
    }

    public static void checkValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, long value) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((long)provider.getLong()).isEqualTo(value);
    }

    public static void checkValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, double value) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((double)provider.getDouble()).isCloseTo(value, Offset.offset((Number)1.0E-4));
    }

    public static void checkValue(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle, boolean value) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)provider.getBoolean()).isEqualTo(value);
    }

    public static void checkIsNull(Map<DecoderColumnHandle, FieldValueProvider> decodedRow, DecoderColumnHandle handle) {
        FieldValueProvider provider = decodedRow.get(handle);
        Assertions.assertThat((Object)provider).isNotNull();
        Assertions.assertThat((boolean)provider.isNull()).isTrue();
    }
}

