/*
 * Decompiled with CFR 0.152.
 */
package io.trino.decoder.protobuf;

import com.google.common.base.Preconditions;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.InvalidProtocolBufferException;
import io.trino.decoder.protobuf.DynamicMessageProvider;
import io.trino.decoder.protobuf.ProtobufErrorCode;
import io.trino.decoder.protobuf.ProtobufUtils;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.TrinoException;
import java.util.Objects;
import java.util.Optional;

public class FixedSchemaDynamicMessageProvider
implements DynamicMessageProvider {
    private final Descriptors.Descriptor descriptor;

    public FixedSchemaDynamicMessageProvider(Descriptors.Descriptor descriptor) {
        this.descriptor = Objects.requireNonNull(descriptor, "descriptor is null");
    }

    @Override
    public DynamicMessage parseDynamicMessage(byte[] data) {
        try {
            return DynamicMessage.parseFrom((Descriptors.Descriptor)this.descriptor, (byte[])data);
        }
        catch (InvalidProtocolBufferException e) {
            throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.INVALID_PROTOBUF_MESSAGE, "Decoding Protobuf record failed.", (Throwable)e);
        }
    }

    public static class Factory
    implements DynamicMessageProvider.Factory {
        @Override
        public DynamicMessageProvider create(Optional<String> protoFile) {
            Preconditions.checkState((boolean)protoFile.isPresent(), (Object)"proto file is missing");
            try {
                Descriptors.Descriptor descriptor = ProtobufUtils.getFileDescriptor(protoFile.orElseThrow()).findMessageTypeByName("schema");
                Preconditions.checkState((descriptor != null ? 1 : 0) != 0, (String)"Message %s not found", (Object)"schema");
                return new FixedSchemaDynamicMessageProvider(descriptor);
            }
            catch (Descriptors.DescriptorValidationException descriptorValidationException) {
                throw new TrinoException((ErrorCodeSupplier)ProtobufErrorCode.INVALID_PROTO_FILE, "Unable to parse protobuf schema", (Throwable)descriptorValidationException);
            }
        }
    }
}

