/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.base.Preconditions;
import io.trino.plugin.redis.RedisColumnHandle;
import io.trino.plugin.redis.RedisSplit;
import io.trino.plugin.redis.RedisTableHandle;
import io.trino.plugin.redis.RedisTransactionHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorHandleResolver;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import java.util.Objects;

public class RedisHandleResolver
implements ConnectorHandleResolver {
    public Class<? extends ConnectorTransactionHandle> getTransactionHandleClass() {
        return RedisTransactionHandle.class;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return RedisTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return RedisColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return RedisSplit.class;
    }

    static RedisTableHandle convertTableHandle(ConnectorTableHandle tableHandle) {
        Objects.requireNonNull(tableHandle, "tableHandle is null");
        Preconditions.checkArgument((boolean)(tableHandle instanceof RedisTableHandle), (Object)"tableHandle is not an instance of RedisTableHandle");
        return (RedisTableHandle)tableHandle;
    }

    static RedisColumnHandle convertColumnHandle(ColumnHandle columnHandle) {
        Objects.requireNonNull(columnHandle, "columnHandle is null");
        Preconditions.checkArgument((boolean)(columnHandle instanceof RedisColumnHandle), (Object)"columnHandle is not an instance of RedisColumnHandle");
        return (RedisColumnHandle)columnHandle;
    }

    static RedisSplit convertSplit(ConnectorSplit split) {
        Objects.requireNonNull(split, "split is null");
        Preconditions.checkArgument((boolean)(split instanceof RedisSplit), (Object)"split is not an instance of RedisSplit");
        return (RedisSplit)split;
    }
}

