/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.log.Logger;
import io.trino.plugin.redis.RedisConnectorConfig;
import io.trino.plugin.redis.RedisHandleResolver;
import io.trino.plugin.redis.RedisInternalFieldDescription;
import io.trino.plugin.redis.RedisTableDescription;
import io.trino.plugin.redis.RedisTableFieldDescription;
import io.trino.plugin.redis.RedisTableFieldGroup;
import io.trino.plugin.redis.RedisTableHandle;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableProperties;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SchemaTablePrefix;
import io.trino.spi.connector.TableNotFoundException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class RedisMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(RedisMetadata.class);
    private final boolean hideInternalColumns;
    private final java.util.function.Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier;

    @Inject
    RedisMetadata(RedisConnectorConfig redisConnectorConfig, java.util.function.Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier) {
        Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
        this.hideInternalColumns = redisConnectorConfig.isHideInternalColumns();
        log.debug("Loading redis table definitions from %s", new Object[]{redisConnectorConfig.getTableDescriptionDir().getAbsolutePath()});
        this.redisTableDescriptionSupplier = () -> ((Supplier)Suppliers.memoize(redisTableDescriptionSupplier::get)).get();
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        Set schemas = this.getDefinedTables().keySet().stream().map(SchemaTableName::getSchemaName).collect(Collectors.toCollection(LinkedHashSet::new));
        return ImmutableList.copyOf((Collection)schemas);
    }

    public RedisTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName) {
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            return null;
        }
        String keyName = null;
        if (table.getKey() != null) {
            keyName = table.getKey().getName();
        }
        return new RedisTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), RedisMetadata.getDataFormat(table.getKey()), RedisMetadata.getDataFormat(table.getValue()), keyName);
    }

    private static String getDataFormat(RedisTableFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.getDataFormat();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName schemaTableName = RedisHandleResolver.convertTableHandle(tableHandle).toSchemaTableName();
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(schemaTableName);
        if (tableMetadata == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return tableMetadata;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.getDefinedTables().keySet()) {
            if (!schemaName.map(tableName.getSchemaName()::equals).orElse(true).booleanValue()) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List<RedisTableFieldDescription> fields;
        RedisTableFieldGroup value;
        List<RedisTableFieldDescription> fields2;
        RedisTableHandle redisTableHandle = RedisHandleResolver.convertTableHandle(tableHandle);
        RedisTableDescription redisTableDescription = this.getDefinedTables().get(redisTableHandle.toSchemaTableName());
        if (redisTableDescription == null) {
            throw new TableNotFoundException(redisTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        RedisTableFieldGroup key = redisTableDescription.getKey();
        if (key != null && (fields2 = key.getFields()) != null) {
            for (RedisTableFieldDescription field : fields2) {
                columnHandles.put((Object)field.getName(), (Object)field.getColumnHandle(true, index));
                ++index;
            }
        }
        if ((value = redisTableDescription.getValue()) != null && (fields = value.getFields()) != null) {
            for (RedisTableFieldDescription field : fields) {
                columnHandles.put((Object)field.getName(), (Object)field.getColumnHandle(false, index));
                ++index;
            }
        }
        for (RedisInternalFieldDescription field : RedisInternalFieldDescription.values()) {
            columnHandles.put((Object)field.getColumnName(), (Object)field.getColumnHandle(index, this.hideInternalColumns));
            ++index;
        }
        return columnHandles.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        Objects.requireNonNull(prefix, "prefix is null");
        ImmutableMap.Builder columns = ImmutableMap.builder();
        Object tableNames = prefix.getTable().isEmpty() ? this.listTables(session, prefix.getSchema()) : ImmutableList.of((Object)prefix.toSchemaTableName());
        for (SchemaTableName tableName : tableNames) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            columns.put((Object)tableName, (Object)tableMetadata.getColumns());
        }
        return columns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        RedisHandleResolver.convertTableHandle(tableHandle);
        return RedisHandleResolver.convertColumnHandle(columnHandle).getColumnMetadata();
    }

    public boolean usesLegacyTableLayouts() {
        return false;
    }

    public ConnectorTableProperties getTableProperties(ConnectorSession session, ConnectorTableHandle tableHandle) {
        return new ConnectorTableProperties();
    }

    @VisibleForTesting
    Map<SchemaTableName, RedisTableDescription> getDefinedTables() {
        return this.redisTableDescriptionSupplier.get();
    }

    @Nullable
    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        RedisMetadata.appendFields((ImmutableList.Builder<ColumnMetadata>)builder, table.getKey());
        RedisMetadata.appendFields((ImmutableList.Builder<ColumnMetadata>)builder, table.getValue());
        for (RedisInternalFieldDescription fieldDescription : RedisInternalFieldDescription.values()) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }

    private static void appendFields(ImmutableList.Builder<ColumnMetadata> builder, RedisTableFieldGroup group) {
        List<RedisTableFieldDescription> fields;
        if (group != null && (fields = group.getFields()) != null) {
            for (RedisTableFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.getColumnMetadata());
            }
        }
    }
}

