/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.trino.decoder.DispatchingRowDecoderFactory;
import io.trino.decoder.RowDecoder;
import io.trino.plugin.redis.RedisColumnHandle;
import io.trino.plugin.redis.RedisHandleResolver;
import io.trino.plugin.redis.RedisJedisManager;
import io.trino.plugin.redis.RedisRecordSet;
import io.trino.plugin.redis.RedisSplit;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.RecordSet;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.inject.Inject;

public class RedisRecordSetProvider
implements ConnectorRecordSetProvider {
    private final DispatchingRowDecoderFactory decoderFactory;
    private final RedisJedisManager jedisManager;

    @Inject
    public RedisRecordSetProvider(DispatchingRowDecoderFactory decoderFactory, RedisJedisManager jedisManager) {
        this.decoderFactory = Objects.requireNonNull(decoderFactory, "decoderFactory is null");
        this.jedisManager = Objects.requireNonNull(jedisManager, "jedisManager is null");
    }

    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, ConnectorTableHandle table, List<? extends ColumnHandle> columns) {
        RedisSplit redisSplit = RedisHandleResolver.convertSplit(split);
        List redisColumns = (List)columns.stream().map(RedisHandleResolver::convertColumnHandle).collect(ImmutableList.toImmutableList());
        RowDecoder keyDecoder = this.decoderFactory.create(redisSplit.getKeyDataFormat(), Collections.emptyMap(), (Set)redisColumns.stream().filter(col -> !col.isInternal()).filter(RedisColumnHandle::isKeyDecoder).collect(ImmutableSet.toImmutableSet()));
        RowDecoder valueDecoder = this.decoderFactory.create(redisSplit.getValueDataFormat(), Collections.emptyMap(), (Set)redisColumns.stream().filter(col -> !col.isInternal()).filter(col -> !col.isKeyDecoder()).collect(ImmutableSet.toImmutableSet()));
        return new RedisRecordSet(redisSplit, this.jedisManager, redisColumns, keyDecoder, valueDecoder);
    }
}

