/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import io.trino.plugin.redis.RedisMetadata;
import io.trino.plugin.redis.RedisRecordSetProvider;
import io.trino.plugin.redis.RedisSplitManager;
import io.trino.plugin.redis.RedisTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorRecordSetProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Objects;
import javax.inject.Inject;

public class RedisConnector
implements Connector {
    private final RedisMetadata metadata;
    private final RedisSplitManager splitManager;
    private final RedisRecordSetProvider recordSetProvider;

    @Inject
    public RedisConnector(RedisMetadata metadata, RedisSplitManager splitManager, RedisRecordSetProvider recordSetProvider) {
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.recordSetProvider = Objects.requireNonNull(recordSetProvider, "recordSetProvider is null");
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        return RedisTransactionHandle.INSTANCE;
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        return this.metadata;
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorRecordSetProvider getRecordSetProvider() {
        return this.recordSetProvider;
    }
}

