/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import io.airlift.log.Logger;
import io.airlift.units.Duration;
import io.trino.plugin.redis.RedisConnectorConfig;
import io.trino.spi.HostAddress;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisJedisManager {
    private static final Logger log = Logger.get(RedisJedisManager.class);
    private final ConcurrentMap<HostAddress, JedisPool> jedisPoolCache = new ConcurrentHashMap<HostAddress, JedisPool>();
    private final String redisUser;
    private final String redisPassword;
    private final Duration redisConnectTimeout;
    private final int redisDataBaseIndex;
    private final int redisMaxKeysPerFetch;
    private final char redisKeyDelimiter;
    private final boolean keyPrefixSchemaTable;
    private final int redisScanCount;
    private final JedisPoolConfig jedisPoolConfig;

    @Inject
    RedisJedisManager(RedisConnectorConfig redisConnectorConfig) {
        Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
        this.redisUser = redisConnectorConfig.getRedisUser();
        this.redisPassword = redisConnectorConfig.getRedisPassword();
        this.redisConnectTimeout = redisConnectorConfig.getRedisConnectTimeout();
        this.redisDataBaseIndex = redisConnectorConfig.getRedisDataBaseIndex();
        this.redisMaxKeysPerFetch = redisConnectorConfig.getRedisMaxKeysPerFetch();
        this.redisKeyDelimiter = redisConnectorConfig.getRedisKeyDelimiter();
        this.keyPrefixSchemaTable = redisConnectorConfig.isKeyPrefixSchemaTable();
        this.redisScanCount = redisConnectorConfig.getRedisScanCount();
        this.jedisPoolConfig = new JedisPoolConfig();
    }

    @PreDestroy
    public void tearDown() {
        for (Map.Entry entry : this.jedisPoolCache.entrySet()) {
            try {
                ((JedisPool)entry.getValue()).destroy();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "While destroying JedisPool %s:", new Object[]{entry.getKey()});
            }
        }
    }

    public char getRedisKeyDelimiter() {
        return this.redisKeyDelimiter;
    }

    public int getRedisMaxKeysPerFetch() {
        return this.redisMaxKeysPerFetch;
    }

    public boolean isKeyPrefixSchemaTable() {
        return this.keyPrefixSchemaTable;
    }

    public int getRedisScanCount() {
        return this.redisScanCount;
    }

    public JedisPool getJedisPool(HostAddress host) {
        Objects.requireNonNull(host, "host is null");
        return this.jedisPoolCache.computeIfAbsent(host, this::createConsumer);
    }

    private JedisPool createConsumer(HostAddress host) {
        log.info("Creating new JedisPool for %s", new Object[]{host});
        return new JedisPool((GenericObjectPoolConfig)this.jedisPoolConfig, host.getHostText(), host.getPort(), Math.toIntExact(this.redisConnectTimeout.toMillis()), this.redisUser, this.redisPassword, this.redisDataBaseIndex);
    }
}

