/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.redis.RedisColumnHandle;
import io.trino.plugin.redis.RedisDataType;
import io.trino.spi.HostAddress;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorSplit;
import io.trino.spi.predicate.TupleDomain;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public final class RedisSplit
implements ConnectorSplit {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(RedisSplit.class);
    private final String schemaName;
    private final String tableName;
    private final String keyDataFormat;
    private final String keyName;
    private final String valueDataFormat;
    private final RedisDataType valueDataType;
    private final RedisDataType keyDataType;
    private final List<HostAddress> nodes;
    private final long start;
    private final long end;
    private final TupleDomain<ColumnHandle> constraint;

    @JsonCreator
    public RedisSplit(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="valueDataFormat") String valueDataFormat, @JsonProperty(value="keyName") String keyName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint, @JsonProperty(value="start") long start, @JsonProperty(value="end") long end, @JsonProperty(value="nodes") List<HostAddress> nodes) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        this.valueDataFormat = Objects.requireNonNull(valueDataFormat, "valueDataFormat is null");
        this.keyName = keyName;
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
        this.nodes = ImmutableList.copyOf((Collection)Objects.requireNonNull(nodes, "nodes is null"));
        this.start = start;
        this.end = end;
        this.valueDataType = RedisSplit.toRedisDataType(valueDataFormat);
        this.keyDataType = RedisSplit.toRedisDataType(keyDataFormat);
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getValueDataFormat() {
        return this.valueDataFormat;
    }

    @JsonProperty
    public String getKeyName() {
        return this.keyName;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    @JsonProperty
    public List<HostAddress> getNodes() {
        return this.nodes;
    }

    public RedisDataType getValueDataType() {
        return this.valueDataType;
    }

    public RedisDataType getKeyDataType() {
        return this.keyDataType;
    }

    @JsonProperty
    public long getStart() {
        return this.start;
    }

    @JsonProperty
    public long getEnd() {
        return this.end;
    }

    public List<HostAddress> getAddresses() {
        return this.nodes;
    }

    public Object getInfo() {
        return this;
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.schemaName) + SizeOf.estimatedSizeOf((String)this.tableName) + SizeOf.estimatedSizeOf((String)this.keyDataFormat) + SizeOf.estimatedSizeOf((String)this.keyName) + SizeOf.estimatedSizeOf((String)this.valueDataFormat) + SizeOf.estimatedSizeOf(this.nodes, HostAddress::getRetainedSizeInBytes) + this.constraint.getRetainedSizeInBytes(columnHandle -> ((RedisColumnHandle)columnHandle).getRetainedSizeInBytes());
    }

    public static RedisDataType toRedisDataType(String dataFormat) {
        switch (dataFormat) {
            case "hash": {
                return RedisDataType.HASH;
            }
            case "zset": {
                return RedisDataType.ZSET;
            }
        }
        return RedisDataType.STRING;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("keyDataFormat", (Object)this.keyDataFormat).add("valueDataFormat", (Object)this.valueDataFormat).add("keyName", (Object)this.keyName).add("start", this.start).add("end", this.end).add("nodes", this.nodes).add("constraint", this.constraint).toString();
    }
}

