/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.predicate.TupleDomain;
import java.util.Objects;

public final class RedisTableHandle
implements ConnectorTableHandle {
    private final String schemaName;
    private final String tableName;
    private final String keyDataFormat;
    private final String keyName;
    private final String valueDataFormat;
    private final TupleDomain<ColumnHandle> constraint;

    @JsonCreator
    public RedisTableHandle(@JsonProperty(value="schemaName") String schemaName, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="keyDataFormat") String keyDataFormat, @JsonProperty(value="valueDataFormat") String valueDataFormat, @JsonProperty(value="keyName") String keyName, @JsonProperty(value="constraint") TupleDomain<ColumnHandle> constraint) {
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.keyDataFormat = Objects.requireNonNull(keyDataFormat, "keyDataFormat is null");
        this.valueDataFormat = Objects.requireNonNull(valueDataFormat, "valueDataFormat is null");
        this.keyName = keyName;
        this.constraint = Objects.requireNonNull(constraint, "constraint is null");
    }

    @JsonProperty
    public String getSchemaName() {
        return this.schemaName;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public String getKeyDataFormat() {
        return this.keyDataFormat;
    }

    @JsonProperty
    public String getKeyName() {
        return this.keyName;
    }

    @JsonProperty
    public String getValueDataFormat() {
        return this.valueDataFormat;
    }

    @JsonProperty
    public TupleDomain<ColumnHandle> getConstraint() {
        return this.constraint;
    }

    public SchemaTableName toSchemaTableName() {
        return new SchemaTableName(this.schemaName, this.tableName);
    }

    public int hashCode() {
        return Objects.hash(this.schemaName, this.tableName, this.keyDataFormat, this.valueDataFormat, this.keyName, this.constraint);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RedisTableHandle other = (RedisTableHandle)obj;
        return Objects.equals(this.schemaName, other.schemaName) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.keyDataFormat, other.keyDataFormat) && Objects.equals(this.valueDataFormat, other.valueDataFormat) && Objects.equals(this.keyName, other.keyName) && Objects.equals(this.constraint, other.constraint);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("schemaName", (Object)this.schemaName).add("tableName", (Object)this.tableName).add("keyDataFormat", (Object)this.keyDataFormat).add("valueDataFormat", (Object)this.valueDataFormat).add("keyName", (Object)this.keyName).add("constraint", this.constraint).toString();
    }
}

