/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.function.Try;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.DefaultResource;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.support.scanning.ClassFilter;
import org.junit.platform.commons.support.scanning.ClasspathScanner;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.ClasspathScannerLoader;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.LruCache;
import org.junit.platform.commons.util.ModuleUtils;
import org.junit.platform.commons.util.PackageNameUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ReflectionUtils {
    private static final String USE_LEGACY_SEARCH_SEMANTICS_PROPERTY_NAME = "junit.platform.reflection.search.useLegacySemantics";
    private static final Logger logger = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Pattern SOURCE_CODE_SYNTAX_ARRAY_PATTERN = Pattern.compile("^([^\\[\\]]+)((?>\\[\\])++)$");
    private static final Class<?>[] EMPTY_CLASS_ARRAY = new Class[0];
    private static final ClasspathScanner classpathScanner = ClasspathScannerLoader.getInstance();
    private static final Map<Method, Method> interfaceMethodCache = Collections.synchronizedMap(new LruCache(255));
    private static final Set<String> noCyclesDetectedCache = ConcurrentHashMap.newKeySet();
    private static final Map<String, Class<?>> classNameToTypeMap;
    private static final Map<Class<?>, Class<?>> primitiveToWrapperMap;
    static volatile boolean useLegacySearchSemantics;

    private ReflectionUtils() {
    }

    public static boolean isPublic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isPublic(clazz.getModifiers());
    }

    public static boolean isPublic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isPublic(member.getModifiers());
    }

    public static boolean isPrivate(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isPrivate(clazz.getModifiers());
    }

    public static boolean isPrivate(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isPrivate(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static boolean isNotPrivate(Class<?> clazz) {
        return !ReflectionUtils.isPrivate(clazz);
    }

    @API(status=API.Status.INTERNAL, since="1.1")
    public static boolean isNotPrivate(Member member) {
        return !ReflectionUtils.isPrivate(member);
    }

    public static boolean isAbstract(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isAbstract(clazz.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.13")
    public static boolean isNotAbstract(Class<?> clazz) {
        return !ReflectionUtils.isAbstract(clazz);
    }

    public static boolean isAbstract(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isAbstract(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.13")
    public static boolean isNotAbstract(Member member) {
        return !ReflectionUtils.isAbstract(member);
    }

    public static boolean isStatic(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isStatic(clazz.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static boolean isNotStatic(Class<?> clazz) {
        return !ReflectionUtils.isStatic(clazz);
    }

    public static boolean isStatic(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isStatic(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.1")
    public static boolean isNotStatic(Member member) {
        return !ReflectionUtils.isStatic(member);
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isFinal(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return Modifier.isFinal(clazz.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isNotFinal(Class<?> clazz) {
        return !ReflectionUtils.isFinal(clazz);
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isFinal(Member member) {
        Preconditions.notNull(member, "Member must not be null");
        return Modifier.isFinal(member.getModifiers());
    }

    @API(status=API.Status.INTERNAL, since="1.5")
    public static boolean isNotFinal(Member member) {
        return !ReflectionUtils.isFinal(member);
    }

    public static boolean isInnerClass(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        return !ReflectionUtils.isStatic(clazz) && clazz.isMemberClass();
    }

    @API(status=API.Status.INTERNAL, since="1.12")
    public static boolean isRecordObject(Object object) {
        return object != null && ReflectionUtils.isRecordClass(object.getClass());
    }

    @API(status=API.Status.INTERNAL, since="1.12")
    public static boolean isRecordClass(Class<?> clazz) {
        Class<?> superclass = clazz.getSuperclass();
        return superclass != null && "java.lang.Record".equals(superclass.getName());
    }

    public static boolean returnsPrimitiveVoid(Method method) {
        return method.getReturnType() == Void.TYPE;
    }

    public static boolean isArray(Object obj) {
        return obj != null && obj.getClass().isArray();
    }

    @API(status=API.Status.INTERNAL, since="1.3.2")
    public static boolean isMultidimensionalArray(Object obj) {
        return obj != null && obj.getClass().isArray() && obj.getClass().getComponentType().isArray();
    }

    public static boolean isAssignableTo(Class<?> sourceType, Class<?> targetType) {
        Preconditions.notNull(sourceType, "source type must not be null");
        Preconditions.condition(!sourceType.isPrimitive(), "source type must not be a primitive type");
        Preconditions.notNull(targetType, "target type must not be null");
        if (targetType.isAssignableFrom(sourceType)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            return sourceType == primitiveToWrapperMap.get(targetType) || ReflectionUtils.isWideningConversion(sourceType, targetType);
        }
        return false;
    }

    public static boolean isAssignableTo(Object obj, Class<?> targetType) {
        Preconditions.notNull(targetType, "target type must not be null");
        if (obj == null) {
            return !targetType.isPrimitive();
        }
        if (targetType.isInstance(obj)) {
            return true;
        }
        if (targetType.isPrimitive()) {
            Class<?> sourceType = obj.getClass();
            return sourceType == primitiveToWrapperMap.get(targetType) || ReflectionUtils.isWideningConversion(sourceType, targetType);
        }
        return false;
    }

    static boolean isWideningConversion(Class<?> sourceType, Class<?> targetType) {
        Preconditions.condition(targetType.isPrimitive(), "targetType must be primitive");
        boolean isPrimitive = sourceType.isPrimitive();
        boolean isWrapper = primitiveToWrapperMap.containsValue(sourceType);
        if (!isPrimitive && !isWrapper) {
            return false;
        }
        if (isPrimitive) {
            sourceType = primitiveToWrapperMap.get(sourceType);
        }
        if (sourceType == Byte.class) {
            return targetType == Short.TYPE || targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Short.class || sourceType == Character.class) {
            return targetType == Integer.TYPE || targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Integer.class) {
            return targetType == Long.TYPE || targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Long.class) {
            return targetType == Float.TYPE || targetType == Double.TYPE;
        }
        if (sourceType == Float.class) {
            return targetType == Double.TYPE;
        }
        return false;
    }

    public static Class<?> getWrapperType(Class<?> type) {
        return primitiveToWrapperMap.get(type);
    }

    public static <T> T newInstance(Class<T> clazz, Object ... args) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(args, "Argument array must not be null");
        Preconditions.containsNoNullElements(args, "Individual arguments must not be null");
        try {
            Class[] parameterTypes = (Class[])Arrays.stream(args).map(Object::getClass).toArray(Class[]::new);
            return ReflectionUtils.newInstance(clazz.getDeclaredConstructor(parameterTypes), args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        Preconditions.notNull(constructor, "Constructor must not be null");
        try {
            return ReflectionUtils.makeAccessible(constructor).newInstance(args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static <T> Optional<Object> readFieldValue(Class<T> clazz, String fieldName, T instance) {
        return ReflectionUtils.tryToReadFieldValue(clazz, fieldName, instance).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static <T> Try<Object> tryToReadFieldValue(Class<T> clazz, String fieldName, T instance) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(fieldName, "Field name must not be null or blank");
        return Try.call(() -> clazz.getDeclaredField(fieldName)).andThen(field -> ReflectionUtils.tryToReadFieldValue(field, instance));
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Object> readFieldValue(Field field) {
        return ReflectionUtils.tryToReadFieldValue(field).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Object> tryToReadFieldValue(Field field) {
        return ReflectionUtils.tryToReadFieldValue(field, null);
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Object> readFieldValue(Field field, Object instance) {
        return ReflectionUtils.tryToReadFieldValue(field, instance).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Object> tryToReadFieldValue(Field field, Object instance) {
        Preconditions.notNull(field, "Field must not be null");
        Preconditions.condition(instance != null || ReflectionUtils.isStatic(field), () -> String.format("Cannot read non-static field [%s] on a null instance.", field));
        return Try.call(() -> ReflectionUtils.makeAccessible(field).get(instance));
    }

    public static List<Object> readFieldValues(List<Field> fields, Object instance) {
        return ReflectionUtils.readFieldValues(fields, instance, field -> true);
    }

    public static List<Object> readFieldValues(List<Field> fields, Object instance, Predicate<Field> predicate) {
        Preconditions.notNull(fields, "fields list must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        return fields.stream().filter(predicate).map(field -> ReflectionUtils.tryToReadFieldValue(field, instance).getOrThrow(ExceptionUtils::throwAsUncheckedException)).collect(CollectionUtils.toUnmodifiableList());
    }

    public static Object invokeMethod(Method method, Object target, Object ... args) {
        Preconditions.notNull(method, "Method must not be null");
        Preconditions.condition(target != null || ReflectionUtils.isStatic(method), () -> String.format("Cannot invoke non-static method [%s] on a null target.", method.toGenericString()));
        try {
            return ReflectionUtils.makeAccessible(method).invoke(target, args);
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Class<?>> loadClass(String name) {
        return ReflectionUtils.tryToLoadClass(name).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Class<?>> tryToLoadClass(String name) {
        return ReflectionUtils.tryToLoadClass(name, ClassLoaderUtils.getDefaultClassLoader());
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    public static Optional<Class<?>> loadClass(String name, ClassLoader classLoader) {
        return ReflectionUtils.tryToLoadClass(name, classLoader).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static Class<?> loadRequiredClass(String name, ClassLoader classLoader) throws JUnitException {
        return ReflectionUtils.tryToLoadClass(name, classLoader).getOrThrow(cause -> new JUnitException(String.format("Could not load class [%s]", name), (Throwable)cause));
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Class<?>> tryToLoadClass(String name, ClassLoader classLoader) {
        Preconditions.notBlank(name, "Class name must not be null or blank");
        Preconditions.notNull(classLoader, "ClassLoader must not be null");
        String trimmedName = name.trim();
        if (classNameToTypeMap.containsKey(trimmedName)) {
            return Try.success(classNameToTypeMap.get(trimmedName));
        }
        return Try.call(() -> {
            Matcher matcher = SOURCE_CODE_SYNTAX_ARRAY_PATTERN.matcher(trimmedName);
            if (matcher.matches()) {
                String componentTypeName = matcher.group(1);
                String bracketPairs = matcher.group(2);
                int dimensions = bracketPairs.length() / 2;
                return ReflectionUtils.loadArrayType(classLoader, componentTypeName, dimensions);
            }
            return Class.forName(trimmedName, false, classLoader);
        });
    }

    @API(status=API.Status.INTERNAL, since="1.12")
    public static Try<Set<Resource>> tryToGetResources(String classpathResourceName) {
        return ReflectionUtils.tryToGetResources(classpathResourceName, ClassLoaderUtils.getDefaultClassLoader());
    }

    @API(status=API.Status.INTERNAL, since="1.12")
    public static Try<Set<Resource>> tryToGetResources(String classpathResourceName, ClassLoader classLoader) {
        Preconditions.notBlank(classpathResourceName, "Resource name must not be null or blank");
        Preconditions.notNull(classLoader, "Class loader must not be null");
        boolean startsWithSlash = classpathResourceName.startsWith("/");
        String canonicalClasspathResourceName = startsWithSlash ? classpathResourceName.substring(1) : classpathResourceName;
        return Try.call(() -> {
            ArrayList<URL> resources = Collections.list(classLoader.getResources(canonicalClasspathResourceName));
            return resources.stream().map(url -> {
                try {
                    return new DefaultResource(canonicalClasspathResourceName, url.toURI());
                }
                catch (URISyntaxException e) {
                    throw ExceptionUtils.throwAsUncheckedException(e);
                }
            }).collect(Collectors.toCollection(LinkedHashSet::new));
        });
    }

    private static Class<?> loadArrayType(ClassLoader classLoader, String componentTypeName, int dimensions) throws ClassNotFoundException {
        Class<?> componentType = classNameToTypeMap.containsKey(componentTypeName) ? classNameToTypeMap.get(componentTypeName) : Class.forName(componentTypeName, false, classLoader);
        return Array.newInstance(componentType, new int[dimensions]).getClass();
    }

    public static String getFullyQualifiedMethodName(Class<?> clazz, Method method) {
        Preconditions.notNull(method, "Method must not be null");
        return ReflectionUtils.getFullyQualifiedMethodName(clazz, method.getName(), method.getParameterTypes());
    }

    public static String getFullyQualifiedMethodName(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        return ReflectionUtils.getFullyQualifiedMethodName(clazz.getName(), methodName, ClassUtils.nullSafeToString(parameterTypes));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static String getFullyQualifiedMethodName(String className, String methodName, String parameterTypeNames) {
        Preconditions.notBlank(className, "Class name must not be null or blank");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypeNames, "Parameter type names must not be null");
        return String.format("%s#%s(%s)", className, methodName, parameterTypeNames);
    }

    public static String[] parseFullyQualifiedMethodName(String fullyQualifiedMethodName) {
        int indexOfLastOpeningParenthesis;
        String methodPart;
        Preconditions.notBlank(fullyQualifiedMethodName, "fullyQualifiedMethodName must not be null or blank");
        int indexOfFirstHashtag = fullyQualifiedMethodName.indexOf(35);
        boolean validSyntax = indexOfFirstHashtag > 0 && indexOfFirstHashtag < fullyQualifiedMethodName.length() - 1;
        Preconditions.condition(validSyntax, () -> "[" + fullyQualifiedMethodName + "] is not a valid fully qualified method name: it must start with a fully qualified class name followed by a '#' and then the method name, optionally followed by a parameter list enclosed in parentheses.");
        String className = fullyQualifiedMethodName.substring(0, indexOfFirstHashtag);
        String methodName = methodPart = fullyQualifiedMethodName.substring(indexOfFirstHashtag + 1);
        String methodParameters = "";
        if (methodPart.endsWith("()")) {
            methodName = methodPart.substring(0, methodPart.length() - 2);
        } else if (methodPart.endsWith(")") && (indexOfLastOpeningParenthesis = methodPart.lastIndexOf(40)) > 0 && indexOfLastOpeningParenthesis < methodPart.length() - 1) {
            methodName = methodPart.substring(0, indexOfLastOpeningParenthesis);
            methodParameters = methodPart.substring(indexOfLastOpeningParenthesis + 1, methodPart.length() - 1);
        }
        return new String[]{className, methodName, methodParameters};
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static String[] parseFullyQualifiedFieldName(String fullyQualifiedFieldName) {
        Preconditions.notBlank(fullyQualifiedFieldName, "fullyQualifiedFieldName must not be null or blank");
        int indexOfHashtag = fullyQualifiedFieldName.indexOf(35);
        boolean validSyntax = indexOfHashtag > 0 && indexOfHashtag < fullyQualifiedFieldName.length() - 1;
        Preconditions.condition(validSyntax, () -> "[" + fullyQualifiedFieldName + "] is not a valid fully qualified field name: it must start with a fully qualified class name followed by a '#' and then the field name.");
        return fullyQualifiedFieldName.split("#");
    }

    public static Set<Path> getAllClasspathRootDirectories() {
        String fullClassPath = System.getProperty("java.class.path");
        return Arrays.stream(fullClassPath.split(File.pathSeparator)).map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).collect(Collectors.toSet());
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, ClassFilter.of(classNameFilter, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInClasspathRoot(URI root, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInClasspathRoot(root, ClassFilter.of(classNameFilter, classFilter));
    }

    public static List<Class<?>> findAllClassesInClasspathRoot(URI root, ClassFilter classFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForClassesInClasspathRoot(root, classFilter));
    }

    public static List<Resource> findAllResourcesInClasspathRoot(URI root, Predicate<Resource> resourceFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForResourcesInClasspathRoot(root, resourceFilter));
    }

    public static Stream<Class<?>> streamAllClassesInClasspathRoot(URI root, ClassFilter classFilter) {
        return ReflectionUtils.findAllClassesInClasspathRoot(root, classFilter).stream();
    }

    public static Stream<Resource> streamAllResourcesInClasspathRoot(URI root, Predicate<Resource> resourceFilter) {
        return ReflectionUtils.findAllResourcesInClasspathRoot(root, resourceFilter).stream();
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInPackage(String basePackageName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInPackage(basePackageName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static List<Class<?>> findAllClassesInPackage(String basePackageName, ClassFilter classFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForClassesInPackage(basePackageName, classFilter));
    }

    public static List<Resource> findAllResourcesInPackage(String basePackageName, Predicate<Resource> resourceFilter) {
        return Collections.unmodifiableList(classpathScanner.scanForResourcesInPackage(basePackageName, resourceFilter));
    }

    public static Stream<Class<?>> streamAllClassesInPackage(String basePackageName, ClassFilter classFilter) {
        return ReflectionUtils.findAllClassesInPackage(basePackageName, classFilter).stream();
    }

    public static Stream<Resource> streamAllResourcesInPackage(String basePackageName, Predicate<Resource> resourceFilter) {
        return ReflectionUtils.findAllResourcesInPackage(basePackageName, resourceFilter).stream();
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static Stream<Class<?>> streamAllClassesInModule(String moduleName, Predicate<Class<?>> classFilter, Predicate<String> classNameFilter) {
        return ReflectionUtils.streamAllClassesInModule(moduleName, ClassFilter.of(classNameFilter, classFilter));
    }

    public static List<Class<?>> findAllClassesInModule(String moduleName, ClassFilter classFilter) {
        return Collections.unmodifiableList(ModuleUtils.findAllClassesInModule(moduleName, classFilter));
    }

    public static List<Resource> findAllResourcesInModule(String moduleName, Predicate<Resource> resourceFilter) {
        return Collections.unmodifiableList(ModuleUtils.findAllResourcesInModule(moduleName, resourceFilter));
    }

    public static Stream<Class<?>> streamAllClassesInModule(String moduleName, ClassFilter classFilter) {
        return ReflectionUtils.findAllClassesInModule(moduleName, classFilter).stream();
    }

    public static Stream<Resource> streamAllResourcesInModule(String moduleName, Predicate<Resource> resourceFilter) {
        return ReflectionUtils.findAllResourcesInModule(moduleName, resourceFilter).stream();
    }

    public static List<Class<?>> findNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        LinkedHashSet candidates = new LinkedHashSet();
        ReflectionUtils.visitAllNestedClasses(clazz, predicate, candidates::add);
        return Collections.unmodifiableList(new ArrayList(candidates));
    }

    @API(status=API.Status.INTERNAL, since="1.13")
    public static boolean isNestedClassPresent(Class<?> clazz, Predicate<Class<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        AtomicBoolean foundNestedClass = new AtomicBoolean(false);
        ReflectionUtils.visitAllNestedClasses(clazz, predicate, __ -> foundNestedClass.set(true));
        return foundNestedClass.get();
    }

    public static Stream<Class<?>> streamNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate) {
        return ReflectionUtils.findNestedClasses(clazz, predicate).stream();
    }

    private static void visitAllNestedClasses(Class<?> clazz, Predicate<Class<?>> predicate, Consumer<Class<?>> consumer) {
        if (!ReflectionUtils.isSearchable(clazz)) {
            return;
        }
        if (ReflectionUtils.isInnerClass(clazz) && predicate.test(clazz)) {
            ReflectionUtils.detectInnerClassCycle(clazz);
        }
        try {
            for (Class<?> nestedClass : clazz.getDeclaredClasses()) {
                if (!predicate.test(nestedClass)) continue;
                ReflectionUtils.detectInnerClassCycle(nestedClass);
                consumer.accept(nestedClass);
            }
        }
        catch (NoClassDefFoundError error) {
            logger.debug(error, () -> "Failed to retrieve declared classes for " + clazz.getName());
        }
        ReflectionUtils.visitAllNestedClasses(clazz.getSuperclass(), predicate, consumer);
        for (Class<?> ifc : clazz.getInterfaces()) {
            ReflectionUtils.visitAllNestedClasses(ifc, predicate, consumer);
        }
    }

    private static void detectInnerClassCycle(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        String className = clazz.getName();
        if (noCyclesDetectedCache.contains(className)) {
            return;
        }
        Class<?> superclass = clazz.getSuperclass();
        if (ReflectionUtils.isInnerClass(clazz) && ReflectionUtils.isSearchable(superclass)) {
            for (Class<?> enclosing = clazz.getEnclosingClass(); enclosing != null; enclosing = enclosing.getEnclosingClass()) {
                if (!superclass.equals(enclosing)) continue;
                throw new JUnitException(String.format("Detected cycle in inner class hierarchy between %s and %s", className, enclosing.getName()));
            }
        }
        noCyclesDetectedCache.add(className);
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        try {
            Constructor[] constructors = (Constructor[])Arrays.stream(clazz.getDeclaredConstructors()).filter(ctor -> !ctor.isSynthetic()).toArray(Constructor[]::new);
            Preconditions.condition(constructors.length == 1, () -> String.format("Class [%s] must declare a single constructor", clazz.getName()));
            return constructors[0];
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static List<Constructor<?>> findConstructors(Class<?> clazz, Predicate<Constructor<?>> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        try {
            return Arrays.stream(clazz.getDeclaredConstructors()).filter(predicate).collect(CollectionUtils.toUnmodifiableList());
        }
        catch (Throwable t) {
            throw ExceptionUtils.throwAsUncheckedException(ReflectionUtils.getUnderlyingCause(t));
        }
    }

    public static List<Field> findFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        return ReflectionUtils.streamFields(clazz, predicate, traversalMode).collect(CollectionUtils.toUnmodifiableList());
    }

    public static Stream<Field> streamFields(Class<?> clazz, Predicate<Field> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findAllFieldsInHierarchy(clazz, traversalMode).stream().filter(predicate).distinct();
    }

    private static List<Field> findAllFieldsInHierarchy(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        Field[] localFields = (Field[])ReflectionUtils.getDeclaredFields(clazz).stream().filter(field -> !field.isSynthetic()).toArray(Field[]::new);
        Field[] superclassFields = (Field[])ReflectionUtils.getSuperclassFields(clazz, traversalMode).stream().filter(field -> ReflectionUtils.isNotShadowedByLocalFields(field, localFields)).toArray(Field[]::new);
        Field[] interfaceFields = (Field[])ReflectionUtils.getInterfaceFields(clazz, traversalMode).stream().filter(field -> ReflectionUtils.isNotShadowedByLocalFields(field, localFields)).toArray(Field[]::new);
        ArrayList<Field> fields = new ArrayList<Field>(superclassFields.length + interfaceFields.length + localFields.length);
        if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
            Collections.addAll(fields, superclassFields);
            Collections.addAll(fields, interfaceFields);
        }
        Collections.addAll(fields, localFields);
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            Collections.addAll(fields, interfaceFields);
            Collections.addAll(fields, superclassFields);
        }
        return fields;
    }

    public static boolean isMethodPresent(Class<?> clazz, Predicate<Method> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        return ReflectionUtils.findMethod(clazz, predicate).isPresent();
    }

    @API(status=API.Status.DEPRECATED, since="1.4")
    @Deprecated
    static Optional<Method> getMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.tryToGetMethod(clazz, methodName, parameterTypes).toOptional();
    }

    @API(status=API.Status.INTERNAL, since="1.4")
    public static Try<Method> tryToGetMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return Try.call(() -> clazz.getMethod(methodName, parameterTypes));
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static Method getInterfaceMethodIfPossible(Method method, Class<?> targetClass) {
        if (!ReflectionUtils.isPublic(method) || method.getDeclaringClass().isInterface()) {
            return method;
        }
        Method result = interfaceMethodCache.computeIfAbsent(method, m -> ReflectionUtils.findInterfaceMethodIfPossible(m, m.getParameterTypes(), m.getDeclaringClass(), Object.class));
        if (result == method && targetClass != null) {
            result = ReflectionUtils.findInterfaceMethodIfPossible(method, method.getParameterTypes(), targetClass, method.getDeclaringClass());
        }
        return result;
    }

    private static Method findInterfaceMethodIfPossible(Method method, Class<?>[] parameterTypes, Class<?> startClass, Class<?> endClass) {
        for (Class<?> current = startClass; current != null && current != endClass; current = current.getSuperclass()) {
            for (Class<?> ifc : current.getInterfaces()) {
                try {
                    return ifc.getMethod(method.getName(), parameterTypes);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
            }
        }
        return method;
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, String parameterTypeNames) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        return ReflectionUtils.findMethod(clazz, methodName, ReflectionUtils.resolveParameterTypes(clazz, methodName, parameterTypeNames));
    }

    @API(status=API.Status.INTERNAL, since="1.10")
    public static Class<?>[] resolveParameterTypes(Class<?> clazz, String methodName, String parameterTypeNames) {
        if (StringUtils.isBlank(parameterTypeNames)) {
            return EMPTY_CLASS_ARRAY;
        }
        return (Class[])Arrays.stream(parameterTypeNames.split(",")).map(String::trim).map(typeName -> ReflectionUtils.loadRequiredParameterType(clazz, methodName, typeName)).toArray(Class[]::new);
    }

    private static Class<?> loadRequiredParameterType(Class<?> clazz, String methodName, String typeName) {
        ClassLoader classLoader = ClassLoaderUtils.getClassLoader(clazz);
        return ReflectionUtils.tryToLoadClass(typeName, classLoader).getOrThrow(cause -> new JUnitException(String.format("Failed to load parameter type [%s] for method [%s] in class [%s].", typeName, methodName, clazz.getName()), (Throwable)cause));
    }

    public static Optional<Method> findMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notBlank(methodName, "Method name must not be null or blank");
        Preconditions.notNull(parameterTypes, "Parameter types array must not be null");
        Preconditions.containsNoNullElements(parameterTypes, "Individual parameter types must not be null");
        return ReflectionUtils.findMethod(clazz, method -> ReflectionUtils.hasCompatibleSignature(method, methodName, parameterTypes));
    }

    private static Optional<Method> findMethod(Class<?> clazz, Predicate<Method> predicate) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Class<?> current = clazz;
        while (ReflectionUtils.isSearchable(current)) {
            List<Method> methods = current.isInterface() ? ReflectionUtils.getMethods(current) : ReflectionUtils.getDeclaredMethods(current, HierarchyTraversalMode.BOTTOM_UP);
            for (Method method : methods) {
                if (!predicate.test(method)) continue;
                return Optional.of(method);
            }
            for (Class<?> ifc : current.getInterfaces()) {
                Optional<Method> optional = ReflectionUtils.findMethod(ifc, predicate);
                if (!optional.isPresent()) continue;
                return optional;
            }
            current = current.getSuperclass();
        }
        return Optional.empty();
    }

    @API(status=API.Status.STABLE, since="1.7")
    public static Method getRequiredMethod(Class<?> clazz, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.findMethod(clazz, methodName, parameterTypes).orElseThrow(() -> new JUnitException(String.format("Could not find method [%s] in class [%s]", methodName, clazz.getName())));
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate) {
        return ReflectionUtils.findMethods(clazz, predicate, HierarchyTraversalMode.TOP_DOWN);
    }

    public static List<Method> findMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        return ReflectionUtils.streamMethods(clazz, predicate, traversalMode).collect(CollectionUtils.toUnmodifiableList());
    }

    public static Stream<Method> streamMethods(Class<?> clazz, Predicate<Method> predicate, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(predicate, "Predicate must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        return ReflectionUtils.findAllMethodsInHierarchy(clazz, traversalMode).stream().filter(predicate).distinct();
    }

    private static List<Method> findAllMethodsInHierarchy(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        Preconditions.notNull(clazz, "Class must not be null");
        Preconditions.notNull(traversalMode, "HierarchyTraversalMode must not be null");
        Method[] localMethods = (Method[])ReflectionUtils.getDeclaredMethods(clazz, traversalMode).stream().filter(method -> !method.isSynthetic()).toArray(Method[]::new);
        Method[] superclassMethods = (Method[])ReflectionUtils.getSuperclassMethods(clazz, traversalMode).stream().filter(method -> ReflectionUtils.isNotOverriddenByLocalMethods(method, localMethods)).toArray(Method[]::new);
        Method[] interfaceMethods = (Method[])ReflectionUtils.getInterfaceMethods(clazz, traversalMode).stream().filter(method -> ReflectionUtils.isNotOverriddenByLocalMethods(method, localMethods)).toArray(Method[]::new);
        ArrayList<Method> methods = new ArrayList<Method>(superclassMethods.length + interfaceMethods.length + localMethods.length);
        if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
            Collections.addAll(methods, superclassMethods);
            Collections.addAll(methods, interfaceMethods);
        }
        Collections.addAll(methods, localMethods);
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            Collections.addAll(methods, interfaceMethods);
            Collections.addAll(methods, superclassMethods);
        }
        return methods;
    }

    private static List<Field> getFields(Class<?> clazz) {
        return ReflectionUtils.toSortedMutableList(clazz.getFields());
    }

    private static List<Field> getDeclaredFields(Class<?> clazz) {
        return ReflectionUtils.toSortedMutableList(clazz.getDeclaredFields());
    }

    private static List<Method> getMethods(Class<?> clazz) {
        return ReflectionUtils.toSortedMutableList(clazz.getMethods());
    }

    private static List<Method> getDeclaredMethods(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        List<Method> defaultMethods = ReflectionUtils.getDefaultMethods(clazz);
        List<Method> declaredMethods = ReflectionUtils.toSortedMutableList(clazz.getDeclaredMethods());
        if (traversalMode == HierarchyTraversalMode.BOTTOM_UP) {
            declaredMethods.addAll(defaultMethods);
            return declaredMethods;
        }
        defaultMethods.addAll(declaredMethods);
        return defaultMethods;
    }

    private static List<Method> getDefaultMethods(Class<?> clazz) {
        List visibleDefaultMethods = Arrays.stream(clazz.getMethods()).filter(Method::isDefault).collect(Collectors.toCollection(ArrayList::new));
        if (visibleDefaultMethods.isEmpty()) {
            return visibleDefaultMethods;
        }
        return Arrays.stream(clazz.getInterfaces()).map(ReflectionUtils::getMethods).flatMap(Collection::stream).filter(visibleDefaultMethods::contains).collect(Collectors.toCollection(ArrayList::new));
    }

    private static List<Field> toSortedMutableList(Field[] fields) {
        return ReflectionUtils.toSortedMutableList(fields, ReflectionUtils::defaultFieldSorter);
    }

    private static List<Method> toSortedMutableList(Method[] methods) {
        return ReflectionUtils.toSortedMutableList(methods, ReflectionUtils::defaultMethodSorter);
    }

    private static <T> List<T> toSortedMutableList(T[] items, Comparator<? super T> comparator) {
        ArrayList<? super T> result = new ArrayList<T>(items.length);
        Collections.addAll(result, items);
        result.sort(comparator);
        return result;
    }

    private static int defaultFieldSorter(Field field1, Field field2) {
        return Integer.compare(field1.getName().hashCode(), field2.getName().hashCode());
    }

    private static int defaultMethodSorter(Method method1, Method method2) {
        String name1 = method1.getName();
        String name2 = method2.getName();
        int comparison = Integer.compare(name1.hashCode(), name2.hashCode());
        if (comparison == 0 && (comparison = name1.compareTo(name2)) == 0) {
            comparison = method1.toString().compareTo(method2.toString());
        }
        return comparison;
    }

    private static List<Method> getInterfaceMethods(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        ArrayList<Method> allInterfaceMethods = new ArrayList<Method>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            Method[] localInterfaceMethods = (Method[])ReflectionUtils.getMethods(ifc).stream().filter(m -> !ReflectionUtils.isAbstract(m)).toArray(Method[]::new);
            Method[] superinterfaceMethods = (Method[])ReflectionUtils.getInterfaceMethods(ifc, traversalMode).stream().filter(method -> ReflectionUtils.isNotOverriddenByLocalMethods(method, localInterfaceMethods)).toArray(Method[]::new);
            if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
                Collections.addAll(allInterfaceMethods, superinterfaceMethods);
            }
            Collections.addAll(allInterfaceMethods, localInterfaceMethods);
            if (traversalMode != HierarchyTraversalMode.BOTTOM_UP) continue;
            Collections.addAll(allInterfaceMethods, superinterfaceMethods);
        }
        return allInterfaceMethods;
    }

    private static List<Field> getInterfaceFields(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        ArrayList<Field> allInterfaceFields = new ArrayList<Field>();
        for (Class<?> ifc : clazz.getInterfaces()) {
            Field[] localInterfaceFields = ifc.getFields();
            Arrays.sort(localInterfaceFields, ReflectionUtils::defaultFieldSorter);
            Field[] superinterfaceFields = (Field[])ReflectionUtils.getInterfaceFields(ifc, traversalMode).stream().filter(field -> ReflectionUtils.isNotShadowedByLocalFields(field, localInterfaceFields)).toArray(Field[]::new);
            if (traversalMode == HierarchyTraversalMode.TOP_DOWN) {
                Collections.addAll(allInterfaceFields, superinterfaceFields);
            }
            Collections.addAll(allInterfaceFields, localInterfaceFields);
            if (traversalMode != HierarchyTraversalMode.BOTTOM_UP) continue;
            Collections.addAll(allInterfaceFields, superinterfaceFields);
        }
        return allInterfaceFields;
    }

    private static List<Field> getSuperclassFields(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        Class<?> superclass = clazz.getSuperclass();
        if (!ReflectionUtils.isSearchable(superclass)) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findAllFieldsInHierarchy(superclass, traversalMode);
    }

    private static boolean isNotShadowedByLocalFields(Field field, Field[] localFields) {
        if (useLegacySearchSemantics) {
            for (Field local : localFields) {
                if (!local.getName().equals(field.getName())) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private static List<Method> getSuperclassMethods(Class<?> clazz, HierarchyTraversalMode traversalMode) {
        Class<?> superclass = clazz.getSuperclass();
        if (!ReflectionUtils.isSearchable(superclass)) {
            return Collections.emptyList();
        }
        return ReflectionUtils.findAllMethodsInHierarchy(superclass, traversalMode);
    }

    private static boolean isNotOverriddenByLocalMethods(Method method, Method[] localMethods) {
        for (Method local : localMethods) {
            if (!ReflectionUtils.isMethodOverriddenBy(method, local)) continue;
            return false;
        }
        return true;
    }

    private static boolean isMethodOverriddenBy(Method upper, Method lower) {
        if (!useLegacySearchSemantics) {
            if (Modifier.isStatic(lower.getModifiers())) {
                return false;
            }
            int modifiers = upper.getModifiers();
            if (Modifier.isPrivate(modifiers) || Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) {
                return false;
            }
            if (ReflectionUtils.isPackagePrivate(upper) && !ReflectionUtils.declaredInSamePackage(upper, lower)) {
                return false;
            }
        }
        return ReflectionUtils.hasCompatibleSignature(upper, lower.getName(), lower.getParameterTypes());
    }

    private static boolean isPackagePrivate(Member member) {
        int modifiers = member.getModifiers();
        return !Modifier.isPublic(modifiers) && !Modifier.isProtected(modifiers) && !Modifier.isPrivate(modifiers);
    }

    private static boolean declaredInSamePackage(Method m1, Method m2) {
        return PackageNameUtils.getPackageName(m1.getDeclaringClass()).equals(PackageNameUtils.getPackageName(m2.getDeclaringClass()));
    }

    private static boolean hasCompatibleSignature(Method candidate, String methodName, Class<?>[] parameterTypes) {
        if (!methodName.equals(candidate.getName())) {
            return false;
        }
        if (parameterTypes.length != candidate.getParameterCount()) {
            return false;
        }
        Object[] candidateParameterTypes = candidate.getParameterTypes();
        if (Arrays.equals(parameterTypes, candidateParameterTypes)) {
            return true;
        }
        for (int i = 0; i < parameterTypes.length; ++i) {
            Object upperType = candidateParameterTypes[i];
            Class<?> lowerType = parameterTypes[i];
            if (((Class)upperType).isAssignableFrom(lowerType)) continue;
            return false;
        }
        return ReflectionUtils.isGeneric(candidate);
    }

    static boolean isGeneric(Method method) {
        return ReflectionUtils.isGeneric(method.getGenericReturnType()) || Arrays.stream(method.getGenericParameterTypes()).anyMatch(ReflectionUtils::isGeneric);
    }

    private static boolean isGeneric(Type type) {
        return type instanceof TypeVariable || type instanceof GenericArrayType;
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static <T extends Executable> T makeAccessible(T executable) {
        if (!(ReflectionUtils.isPublic(executable) && ReflectionUtils.isPublic(executable.getDeclaringClass()) || executable.isAccessible())) {
            executable.setAccessible(true);
        }
        return executable;
    }

    @API(status=API.Status.INTERNAL, since="1.12")
    public static Field makeAccessible(Field field) {
        if (!(ReflectionUtils.isPublic(field) && ReflectionUtils.isPublic(field.getDeclaringClass()) && !ReflectionUtils.isFinal(field) || field.isAccessible())) {
            field.setAccessible(true);
        }
        return field;
    }

    public static Set<Class<?>> getAllAssignmentCompatibleClasses(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        LinkedHashSet result = new LinkedHashSet();
        ReflectionUtils.getAllAssignmentCompatibleClasses(clazz, result);
        return result;
    }

    private static void getAllAssignmentCompatibleClasses(Class<?> clazz, Set<Class<?>> result) {
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            result.add(current);
            for (Class<?> interfaceClass : current.getInterfaces()) {
                if (result.contains(interfaceClass)) continue;
                ReflectionUtils.getAllAssignmentCompatibleClasses(interfaceClass, result);
            }
        }
    }

    private static boolean isSearchable(Class<?> clazz) {
        return clazz != null && clazz != Object.class;
    }

    private static Throwable getUnderlyingCause(Throwable t) {
        if (t instanceof InvocationTargetException) {
            return ReflectionUtils.getUnderlyingCause(((InvocationTargetException)t).getTargetException());
        }
        return t;
    }

    private static boolean getLegacySearchSemanticsFlag() {
        String rawValue = System.getProperty(USE_LEGACY_SEARCH_SEMANTICS_PROPERTY_NAME);
        if (StringUtils.isBlank(rawValue)) {
            return false;
        }
        String value = rawValue.trim().toLowerCase();
        boolean isTrue = "true".equals(value);
        Preconditions.condition(isTrue || "false".equals(value), () -> "junit.platform.reflection.search.useLegacySemantics property must be 'true' or 'false' (ignoring case): " + rawValue);
        return isTrue;
    }

    static {
        List<Class> commonTypes = Arrays.asList(Boolean.TYPE, Byte.TYPE, Character.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE, Void.TYPE, boolean[].class, byte[].class, char[].class, short[].class, int[].class, long[].class, float[].class, double[].class, boolean[][].class, byte[][].class, char[][].class, short[][].class, int[][].class, long[][].class, float[][].class, double[][].class, Boolean.class, Byte.class, Character.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Void.class, String.class, Boolean[].class, Byte[].class, Character[].class, Short[].class, Integer[].class, Long[].class, Float[].class, Double[].class, String[].class, Boolean[][].class, Byte[][].class, Character[][].class, Short[][].class, Integer[][].class, Long[][].class, Float[][].class, Double[][].class, String[][].class);
        HashMap classNamesToTypes = new HashMap(64);
        commonTypes.forEach(type -> {
            classNamesToTypes.put(type.getName(), type);
            classNamesToTypes.put(type.getCanonicalName(), type);
        });
        classNameToTypeMap = Collections.unmodifiableMap(classNamesToTypes);
        IdentityHashMap<Class<Comparable<Boolean>>, Class> primitivesToWrappers = new IdentityHashMap<Class<Comparable<Boolean>>, Class>(9);
        primitivesToWrappers.put(Boolean.TYPE, Boolean.class);
        primitivesToWrappers.put(Byte.TYPE, Byte.class);
        primitivesToWrappers.put(Character.TYPE, Character.class);
        primitivesToWrappers.put(Short.TYPE, Short.class);
        primitivesToWrappers.put(Integer.TYPE, Integer.class);
        primitivesToWrappers.put(Long.TYPE, Long.class);
        primitivesToWrappers.put(Float.TYPE, Float.class);
        primitivesToWrappers.put(Double.TYPE, Double.class);
        primitiveToWrapperMap = Collections.unmodifiableMap(primitivesToWrappers);
        useLegacySearchSemantics = ReflectionUtils.getLegacySearchSemanticsFlag();
    }

    public static enum HierarchyTraversalMode {
        TOP_DOWN,
        BOTTOM_UP;

    }
}

