/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.ConfigSecuritySensitive;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import io.trino.spi.HostAddress;
import jakarta.annotation.Nullable;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Size;
import java.io.File;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class RedisConnectorConfig {
    private static final int REDIS_DEFAULT_PORT = 6379;
    private Set<HostAddress> nodes = ImmutableSet.of();
    private int redisScanCount = 100;
    private int redisMaxKeysPerFetch = 100;
    private int redisDataBaseIndex;
    private char redisKeyDelimiter = (char)58;
    private String redisUser;
    private String redisPassword;
    private Duration redisConnectTimeout = new Duration(2000.0, TimeUnit.MILLISECONDS);
    private String defaultSchema = "default";
    private Set<String> tableNames = ImmutableSet.of();
    private File tableDescriptionDir = new File("etc/redis/");
    private Duration tableDescriptionCacheDuration = new Duration(5.0, TimeUnit.MINUTES);
    private boolean hideInternalColumns = true;
    private boolean keyPrefixSchemaTable;

    @NotNull
    public File getTableDescriptionDir() {
        return this.tableDescriptionDir;
    }

    @Config(value="redis.table-description-dir")
    @ConfigDescription(value="Folder holding the JSON description files for Redis values")
    public RedisConnectorConfig setTableDescriptionDir(File tableDescriptionDir) {
        this.tableDescriptionDir = tableDescriptionDir;
        return this;
    }

    @NotNull
    @MinDuration(value="1s")
    public @NotNull @MinDuration(value="1s") Duration getTableDescriptionCacheDuration() {
        return this.tableDescriptionCacheDuration;
    }

    @Config(value="redis.table-description-cache-ttl")
    @ConfigDescription(value="The cache time for redis table description files")
    public RedisConnectorConfig setTableDescriptionCacheDuration(Duration tableDescriptionCacheDuration) {
        this.tableDescriptionCacheDuration = tableDescriptionCacheDuration;
        return this;
    }

    @NotNull
    public Set<String> getTableNames() {
        return this.tableNames;
    }

    @Config(value="redis.table-names")
    @ConfigDescription(value="Set of tables known to this connector. For each table, a description file may be present in the catalog folder which describes columns for the given table")
    public RedisConnectorConfig setTableNames(Set<String> tableNames) {
        this.tableNames = ImmutableSet.copyOf(tableNames);
        return this;
    }

    @NotNull
    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    @Config(value="redis.default-schema")
    @ConfigDescription(value="The schema name to use in the connector")
    public RedisConnectorConfig setDefaultSchema(String defaultSchema) {
        this.defaultSchema = defaultSchema;
        return this;
    }

    @Size(min=1)
    public @Size(min=1) Set<HostAddress> getNodes() {
        return this.nodes;
    }

    @Config(value="redis.nodes")
    @ConfigDescription(value="Seed nodes for Redis cluster. At least one must exist")
    public RedisConnectorConfig setNodes(List<String> nodes) {
        this.nodes = (Set)nodes.stream().map(RedisConnectorConfig::toHostAddress).collect(ImmutableSet.toImmutableSet());
        return this;
    }

    public int getRedisScanCount() {
        return this.redisScanCount;
    }

    @Config(value="redis.scan-count")
    @ConfigDescription(value="Count parameter for Redis scan command")
    public RedisConnectorConfig setRedisScanCount(int redisScanCount) {
        this.redisScanCount = redisScanCount;
        return this;
    }

    @Min(value=1L)
    public @Min(value=1L) int getRedisMaxKeysPerFetch() {
        return this.redisMaxKeysPerFetch;
    }

    @Config(value="redis.max-keys-per-fetch")
    @ConfigDescription(value="Get values associated with the specified number of keys in the command such as MGET(key...)")
    public RedisConnectorConfig setRedisMaxKeysPerFetch(int redisMaxKeysPerFetch) {
        this.redisMaxKeysPerFetch = redisMaxKeysPerFetch;
        return this;
    }

    public int getRedisDataBaseIndex() {
        return this.redisDataBaseIndex;
    }

    @Config(value="redis.database-index")
    @ConfigDescription(value="Index of the Redis DB to connect to")
    public RedisConnectorConfig setRedisDataBaseIndex(int redisDataBaseIndex) {
        this.redisDataBaseIndex = redisDataBaseIndex;
        return this;
    }

    @MinDuration(value="1s")
    public @MinDuration(value="1s") Duration getRedisConnectTimeout() {
        return this.redisConnectTimeout;
    }

    @Config(value="redis.connect-timeout")
    @ConfigDescription(value="Timeout to connect to Redis")
    public RedisConnectorConfig setRedisConnectTimeout(String redisConnectTimeout) {
        this.redisConnectTimeout = Duration.valueOf((String)redisConnectTimeout);
        return this;
    }

    public char getRedisKeyDelimiter() {
        return this.redisKeyDelimiter;
    }

    @Config(value="redis.key-delimiter")
    @ConfigDescription(value="Delimiter for separating schema name and table name in the KEY prefix")
    public RedisConnectorConfig setRedisKeyDelimiter(String redisKeyDelimiter) {
        this.redisKeyDelimiter = redisKeyDelimiter.charAt(0);
        return this;
    }

    @Nullable
    public String getRedisUser() {
        return this.redisUser;
    }

    @Config(value="redis.user")
    @ConfigDescription(value="Username for a Redis server")
    public RedisConnectorConfig setRedisUser(String redisUser) {
        this.redisUser = redisUser;
        return this;
    }

    public String getRedisPassword() {
        return this.redisPassword;
    }

    @Config(value="redis.password")
    @ConfigSecuritySensitive
    @ConfigDescription(value="Password for a password-protected Redis server")
    public RedisConnectorConfig setRedisPassword(String redisPassword) {
        this.redisPassword = redisPassword;
        return this;
    }

    public boolean isHideInternalColumns() {
        return this.hideInternalColumns;
    }

    @Config(value="redis.hide-internal-columns")
    @ConfigDescription(value="Whether internal columns are shown in table metadata or not. Default is no")
    public RedisConnectorConfig setHideInternalColumns(boolean hideInternalColumns) {
        this.hideInternalColumns = hideInternalColumns;
        return this;
    }

    public boolean isKeyPrefixSchemaTable() {
        return this.keyPrefixSchemaTable;
    }

    @Config(value="redis.key-prefix-schema-table")
    @ConfigDescription(value="Whether Redis key string follows \"schema:table:*\" format")
    public RedisConnectorConfig setKeyPrefixSchemaTable(boolean keyPrefixSchemaTable) {
        this.keyPrefixSchemaTable = keyPrefixSchemaTable;
        return this;
    }

    private static HostAddress toHostAddress(String value) {
        return HostAddress.fromString((String)value).withDefaultPort(6379);
    }
}

