/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.inject.Inject;
import io.airlift.log.Logger;
import io.trino.plugin.redis.RedisColumnHandle;
import io.trino.plugin.redis.RedisConnectorConfig;
import io.trino.plugin.redis.RedisDataType;
import io.trino.plugin.redis.RedisInternalFieldDescription;
import io.trino.plugin.redis.RedisSplit;
import io.trino.plugin.redis.RedisTableDescription;
import io.trino.plugin.redis.RedisTableFieldDescription;
import io.trino.plugin.redis.RedisTableFieldGroup;
import io.trino.plugin.redis.RedisTableHandle;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableHandle;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTableVersion;
import io.trino.spi.connector.Constraint;
import io.trino.spi.connector.ConstraintApplicationResult;
import io.trino.spi.connector.RelationColumnsMetadata;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.TableNotFoundException;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.Ranges;
import io.trino.spi.predicate.SortedRangeSet;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.predicate.ValueSet;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;

public class RedisMetadata
implements ConnectorMetadata {
    private static final Logger log = Logger.get(RedisMetadata.class);
    private final boolean hideInternalColumns;
    private final Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier;

    @Inject
    RedisMetadata(RedisConnectorConfig redisConnectorConfig, Supplier<Map<SchemaTableName, RedisTableDescription>> redisTableDescriptionSupplier) {
        this.hideInternalColumns = redisConnectorConfig.isHideInternalColumns();
        log.debug("Loading redis table definitions from %s", new Object[]{redisConnectorConfig.getTableDescriptionDir().getAbsolutePath()});
        this.redisTableDescriptionSupplier = Suppliers.memoizeWithExpiration(redisTableDescriptionSupplier::get, (long)redisConnectorConfig.getTableDescriptionCacheDuration().toMillis(), (TimeUnit)TimeUnit.MILLISECONDS);
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        Set schemas = this.getDefinedTables().keySet().stream().map(SchemaTableName::getSchemaName).collect(Collectors.toCollection(LinkedHashSet::new));
        return ImmutableList.copyOf((Collection)schemas);
    }

    public RedisTableHandle getTableHandle(ConnectorSession session, SchemaTableName schemaTableName, Optional<ConnectorTableVersion> startVersion, Optional<ConnectorTableVersion> endVersion) {
        if (startVersion.isPresent() || endVersion.isPresent()) {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "This connector does not support versioned tables");
        }
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            return null;
        }
        String keyName = null;
        if (table.key() != null) {
            keyName = table.key().name();
        }
        return new RedisTableHandle(schemaTableName.getSchemaName(), schemaTableName.getTableName(), RedisMetadata.getDataFormat(table.key()), RedisMetadata.getDataFormat(table.value()), keyName, (TupleDomain<ColumnHandle>)TupleDomain.all());
    }

    private static String getDataFormat(RedisTableFieldGroup fieldGroup) {
        return fieldGroup == null ? "dummy" : fieldGroup.dataFormat();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        SchemaTableName schemaTableName = ((RedisTableHandle)tableHandle).toSchemaTableName();
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(schemaTableName);
        if (tableMetadata == null) {
            throw new TableNotFoundException(schemaTableName);
        }
        return tableMetadata;
    }

    public List<SchemaTableName> listTables(ConnectorSession session, Optional<String> schemaName) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (SchemaTableName tableName : this.getDefinedTables().keySet()) {
            if (!schemaName.map(tableName.getSchemaName()::equals).orElse(true).booleanValue()) continue;
            builder.add((Object)tableName);
        }
        return builder.build();
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        List<RedisTableFieldDescription> fields;
        RedisTableFieldGroup value;
        List<RedisTableFieldDescription> fields2;
        RedisTableHandle redisTableHandle = (RedisTableHandle)tableHandle;
        RedisTableDescription redisTableDescription = this.getDefinedTables().get(redisTableHandle.toSchemaTableName());
        if (redisTableDescription == null) {
            throw new TableNotFoundException(redisTableHandle.toSchemaTableName());
        }
        ImmutableMap.Builder columnHandles = ImmutableMap.builder();
        int index = 0;
        RedisTableFieldGroup key = redisTableDescription.key();
        if (key != null && (fields2 = key.fields()) != null) {
            for (RedisTableFieldDescription field : fields2) {
                columnHandles.put((Object)field.name(), (Object)field.columnHandle(true, index));
                ++index;
            }
        }
        if ((value = redisTableDescription.value()) != null && (fields = value.fields()) != null) {
            for (RedisTableFieldDescription field : fields) {
                columnHandles.put((Object)field.name(), (Object)field.columnHandle(false, index));
                ++index;
            }
        }
        for (RedisInternalFieldDescription field : RedisInternalFieldDescription.values()) {
            columnHandles.put((Object)field.getColumnName(), (Object)field.getColumnHandle(index, this.hideInternalColumns));
            ++index;
        }
        return columnHandles.buildOrThrow();
    }

    public Optional<ConstraintApplicationResult<ConnectorTableHandle>> applyFilter(ConnectorSession session, ConnectorTableHandle table, Constraint constraint) {
        TupleDomain remainingFilter;
        RedisTableHandle handle = (RedisTableHandle)table;
        TupleDomain<ColumnHandle> oldDomain = handle.constraint();
        TupleDomain newDomain = oldDomain.intersect(constraint.getSummary());
        if (newDomain.isNone()) {
            remainingFilter = TupleDomain.all();
        } else {
            Map domains = (Map)newDomain.getDomains().orElseThrow();
            HashMap<RedisColumnHandle, Domain> supported = new HashMap<RedisColumnHandle, Domain>();
            Map<RedisColumnHandle, Domain> unsupported = new HashMap();
            if (RedisSplit.toRedisDataType(handle.keyDataFormat()) != RedisDataType.STRING) {
                unsupported = domains;
            } else if (this.getUserDefinedKeySize(session, handle) > 1L) {
                unsupported = domains;
            } else {
                for (Map.Entry entry : domains.entrySet()) {
                    Domain domain;
                    RedisColumnHandle columnHandle = (RedisColumnHandle)entry.getKey();
                    if (this.isColumnSupportsPushdown(columnHandle, domain = (Domain)entry.getValue())) {
                        supported.put(columnHandle, domain);
                        continue;
                    }
                    unsupported.put(columnHandle, domain);
                }
            }
            newDomain = TupleDomain.withColumnDomains(supported);
            remainingFilter = TupleDomain.withColumnDomains(unsupported);
        }
        if (oldDomain.equals((Object)newDomain)) {
            return Optional.empty();
        }
        handle = new RedisTableHandle(handle.schemaName(), handle.tableName(), handle.keyDataFormat(), handle.valueDataFormat(), handle.keyName(), (TupleDomain<ColumnHandle>)newDomain);
        return Optional.of(new ConstraintApplicationResult((Object)handle, remainingFilter, constraint.getExpression(), false));
    }

    public Iterator<RelationColumnsMetadata> streamRelationColumns(ConnectorSession session, Optional<String> schemaName, UnaryOperator<Set<SchemaTableName>> relationFilter) {
        HashMap<SchemaTableName, RelationColumnsMetadata> relationColumns = new HashMap<SchemaTableName, RelationColumnsMetadata>();
        for (SchemaTableName tableName : this.listTables(session, schemaName)) {
            ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableName);
            if (tableMetadata == null) continue;
            relationColumns.put(tableName, RelationColumnsMetadata.forTable((SchemaTableName)tableName, (List)tableMetadata.getColumns()));
        }
        return ((Set)relationFilter.apply(relationColumns.keySet())).stream().map(relationColumns::get).iterator();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        return ((RedisColumnHandle)columnHandle).getColumnMetadata();
    }

    @VisibleForTesting
    Map<SchemaTableName, RedisTableDescription> getDefinedTables() {
        return this.redisTableDescriptionSupplier.get();
    }

    @Nullable
    private ConnectorTableMetadata getTableMetadata(SchemaTableName schemaTableName) {
        RedisTableDescription table = this.getDefinedTables().get(schemaTableName);
        if (table == null) {
            return null;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        RedisMetadata.appendFields((ImmutableList.Builder<ColumnMetadata>)builder, table.key());
        RedisMetadata.appendFields((ImmutableList.Builder<ColumnMetadata>)builder, table.value());
        for (RedisInternalFieldDescription fieldDescription : RedisInternalFieldDescription.values()) {
            builder.add((Object)fieldDescription.getColumnMetadata(this.hideInternalColumns));
        }
        return new ConnectorTableMetadata(schemaTableName, (List)builder.build());
    }

    private static void appendFields(ImmutableList.Builder<ColumnMetadata> builder, RedisTableFieldGroup group) {
        List<RedisTableFieldDescription> fields;
        if (group != null && (fields = group.fields()) != null) {
            for (RedisTableFieldDescription fieldDescription : fields) {
                builder.add((Object)fieldDescription.columnMetadata());
            }
        }
    }

    private boolean isColumnSupportsPushdown(RedisColumnHandle columnHandle, Domain domain) {
        if (columnHandle.isKeyDecoder()) {
            if (domain.isSingleValue()) {
                return true;
            }
            ValueSet valueSet = domain.getValues();
            if (valueSet instanceof SortedRangeSet) {
                SortedRangeSet sortedRangeSet = (SortedRangeSet)valueSet;
                Ranges ranges = sortedRangeSet.getRanges();
                List rangeList = ranges.getOrderedRanges();
                return rangeList.stream().allMatch(Range::isSingleValue);
            }
        }
        return false;
    }

    private long getUserDefinedKeySize(ConnectorSession session, RedisTableHandle handle) {
        return this.getColumnHandles(session, handle).values().stream().filter(column -> ((RedisColumnHandle)column).isKeyDecoder()).count();
    }
}

