/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.redis;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.airlift.log.Logger;
import io.trino.plugin.redis.RedisConnectorConfig;
import io.trino.plugin.redis.RedisTableDescription;
import io.trino.plugin.redis.RedisTableFieldDescription;
import io.trino.plugin.redis.RedisTableFieldGroup;
import io.trino.spi.connector.SchemaTableName;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public class RedisTableDescriptionSupplier
implements Supplier<Map<SchemaTableName, RedisTableDescription>> {
    private static final Logger log = Logger.get(RedisTableDescriptionSupplier.class);
    private final File tableDescriptionDir;
    private final Set<String> tableNames;
    private final String defaultSchema;
    private final JsonCodec<RedisTableDescription> tableDescriptionCodec;

    @Inject
    RedisTableDescriptionSupplier(RedisConnectorConfig redisConnectorConfig, JsonCodec<RedisTableDescription> tableDescriptionCodec) {
        Objects.requireNonNull(redisConnectorConfig, "redisConnectorConfig is null");
        this.tableDescriptionDir = redisConnectorConfig.getTableDescriptionDir();
        this.tableNames = ImmutableSet.copyOf(redisConnectorConfig.getTableNames());
        this.defaultSchema = redisConnectorConfig.getDefaultSchema();
        this.tableDescriptionCodec = Objects.requireNonNull(tableDescriptionCodec, "tableDescriptionCodec is null");
    }

    @Override
    public Map<SchemaTableName, RedisTableDescription> get() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        try {
            for (File file : RedisTableDescriptionSupplier.listFiles(this.tableDescriptionDir)) {
                if (!file.isFile() || !file.getName().endsWith(".json")) continue;
                try (FileInputStream stream = new FileInputStream(file);){
                    RedisTableDescription table = (RedisTableDescription)this.tableDescriptionCodec.fromJson((InputStream)stream);
                    String schemaName = (String)MoreObjects.firstNonNull((Object)table.schemaName(), (Object)this.defaultSchema);
                    log.debug("Redis table %s.%s: %s", new Object[]{schemaName, table.tableName(), table});
                    builder.put((Object)new SchemaTableName(schemaName, table.tableName()), (Object)table);
                }
            }
            ImmutableMap tableDefinitions = builder.buildOrThrow();
            log.debug("Loaded table definitions: %s", new Object[]{tableDefinitions.keySet()});
            for (String definedTable : this.tableNames) {
                SchemaTableName tableName;
                try {
                    tableName = RedisTableDescriptionSupplier.parseTableName(definedTable);
                }
                catch (IllegalArgumentException iae) {
                    tableName = new SchemaTableName(this.defaultSchema, definedTable);
                }
                if (tableDefinitions.containsKey(tableName)) continue;
                log.debug("Created dummy Table definition for %s", new Object[]{tableName});
                builder.put((Object)tableName, (Object)new RedisTableDescription(tableName.getTableName(), tableName.getSchemaName(), new RedisTableFieldGroup("dummy", null, (List<RedisTableFieldDescription>)ImmutableList.of()), new RedisTableFieldGroup("dummy", null, (List<RedisTableFieldDescription>)ImmutableList.of())));
            }
            return builder.buildOrThrow();
        }
        catch (IOException e) {
            log.warn((Throwable)e, "Failed to get table description files for Redis");
            throw new UncheckedIOException(e);
        }
    }

    private static List<File> listFiles(File dir) {
        Object[] files;
        if (dir != null && dir.isDirectory() && (files = dir.listFiles()) != null) {
            log.debug("Considering files: %s", new Object[]{Arrays.asList(files)});
            return ImmutableList.copyOf((Object[])files);
        }
        return ImmutableList.of();
    }

    private static SchemaTableName parseTableName(String schemaTableName) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)schemaTableName) ? 1 : 0) != 0, (Object)"schemaTableName is null or is empty");
        List parts = Splitter.on((char)'.').splitToList((CharSequence)schemaTableName);
        Preconditions.checkArgument((parts.size() == 2 ? 1 : 0) != 0, (String)"Invalid schemaTableName: %s", (Object)schemaTableName);
        return new SchemaTableName((String)parts.get(0), (String)parts.get(1));
    }
}

