/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSSessionCredentials;
import java.util.Date;

public class CredentialsHolder
implements AWSCredentials {
    protected AWSCredentials m_credentials;
    private Date m_expiration;
    private IamMetadata m_metadata;

    protected CredentialsHolder(AWSCredentials credentials) {
        this(credentials, new Date(System.currentTimeMillis() + 900000L));
    }

    protected CredentialsHolder(AWSCredentials credentials, Date expiration) {
        this.m_credentials = credentials;
        if (credentials instanceof CredentialsHolder) {
            CredentialsHolder h = (CredentialsHolder)credentials;
            this.m_metadata = h.getMetadata();
            this.m_expiration = h.getExpiration();
        } else {
            this.m_expiration = expiration;
        }
    }

    public static CredentialsHolder newInstance(AWSCredentials credentials) {
        if (credentials instanceof AWSSessionCredentials) {
            return new SessionCredentialsHolder(credentials);
        }
        return new CredentialsHolder(credentials);
    }

    public static CredentialsHolder newInstance(AWSCredentials credentials, Date expiration) {
        if (credentials instanceof AWSSessionCredentials) {
            return new SessionCredentialsHolder(credentials, expiration);
        }
        return new CredentialsHolder(credentials, expiration);
    }

    public String getAWSAccessKeyId() {
        return this.m_credentials.getAWSAccessKeyId();
    }

    public String getAWSSecretKey() {
        return this.m_credentials.getAWSSecretKey();
    }

    public boolean isExpired() {
        return this.m_expiration != null && this.m_expiration.before(new Date());
    }

    public Date getExpiration() {
        return this.m_expiration;
    }

    public IamMetadata getMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata.clone();
    }

    public IamMetadata getThisMetadata() {
        if (this.m_metadata == null) {
            return null;
        }
        return this.m_metadata;
    }

    public void setMetadata(IamMetadata metadata) {
        this.m_metadata = metadata;
    }

    public static final class IamMetadata
    implements Cloneable {
        private Boolean autoCreate;
        private String dbUser;
        private String samlDbUser;
        private String profileDbUser;
        private String dbGroups;
        private boolean allowDbUserOverride = false;
        private boolean forceLowercase = false;

        public Boolean getAutoCreate() {
            return this.autoCreate;
        }

        public String getDbUser() {
            return this.dbUser;
        }

        public void setDbUser(String dbUser) {
            this.dbUser = dbUser;
        }

        public void setAutoCreate(Boolean autoCreate) {
            this.autoCreate = autoCreate;
        }

        public String getSamlDbUser() {
            return this.samlDbUser;
        }

        public void setSamlDbUser(String dbUser) {
            this.samlDbUser = dbUser;
        }

        public String getProfileDbUser() {
            return this.profileDbUser;
        }

        public void setProfileDbUser(String dbUser) {
            this.profileDbUser = dbUser;
        }

        public String getDbGroups() {
            return this.dbGroups;
        }

        public void setDbGroups(String dbGroups) {
            this.dbGroups = dbGroups;
        }

        public boolean getForceLowercase() {
            return this.forceLowercase;
        }

        public void setForceLowercase(boolean forceLowercase) {
            this.forceLowercase = forceLowercase;
        }

        public boolean getAllowDbUserOverride() {
            return this.allowDbUserOverride;
        }

        public void setAllowDbUserOverride(boolean allowDbUserOverride) {
            this.allowDbUserOverride = allowDbUserOverride;
        }

        public IamMetadata clone() {
            try {
                return (IamMetadata)super.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }
    }

    private static final class SessionCredentialsHolder
    extends CredentialsHolder
    implements AWSSessionCredentials {
        protected SessionCredentialsHolder(AWSCredentials credentials) {
            super(credentials);
        }

        protected SessionCredentialsHolder(AWSCredentials credentials, Date expiration) {
            super(credentials, expiration);
        }

        public String getSessionToken() {
            return ((AWSSessionCredentials)this.m_credentials).getSessionToken();
        }
    }
}

