/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.core;

import com.amazon.redshift.CredentialsHolder;
import com.amazon.redshift.IPlugin;
import com.amazon.redshift.RedshiftProperty;
import com.amazon.redshift.core.RedshiftJDBCSettings;
import com.amazon.redshift.logger.RedshiftLogger;
import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.auth.profile.internal.BasicProfile;
import com.amazonaws.auth.profile.internal.ProfileStaticCredentialsProvider;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.AssumeRoleResult;
import com.amazonaws.services.securitytoken.model.Credentials;
import com.amazonaws.util.StringUtils;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class PluginProfilesConfigFile
extends ProfilesConfigFile {
    private Map<String, CredentialsHolder> cache = new ConcurrentHashMap<String, CredentialsHolder>();
    private RedshiftJDBCSettings m_settings;
    private RedshiftLogger m_log;
    private static final String PROFILE_PREFIX = "profile ";

    public PluginProfilesConfigFile(RedshiftJDBCSettings settings, RedshiftLogger log) {
        this.m_settings = settings;
        this.m_log = log;
    }

    public CredentialsHolder getCredentials(String profileName) {
        CredentialsHolder credentials = this.cache.get(profileName);
        if (credentials == null) {
            credentials = this.cache.get(PROFILE_PREFIX + profileName);
        }
        if (credentials != null && !credentials.isExpired()) {
            return credentials;
        }
        Map map = this.getAllBasicProfiles();
        BasicProfile profile = (BasicProfile)map.get(profileName);
        if (profile == null) {
            profile = (BasicProfile)map.get(PROFILE_PREFIX + profileName);
        }
        if (profile == null) {
            throw new SdkClientException("No AWS profile named '" + profileName + "'");
        }
        if (profile.isRoleBasedProfile()) {
            String srcProfile = profile.getRoleSourceProfile();
            CredentialsHolder srcCred = this.getCredentials(srcProfile);
            AWSStaticCredentialsProvider provider = new AWSStaticCredentialsProvider((AWSCredentials)srcCred);
            credentials = this.assumeRole(profile, (AWSCredentialsProvider)provider);
            credentials.setMetadata(srcCred.getMetadata());
            this.cache.put(profileName, credentials);
            return credentials;
        }
        String dbUser = null;
        String autoCreate = null;
        String dbGroups = null;
        String forceLowercase = null;
        String pluginName = profile.getPropertyValue("plugin_name");
        if (!StringUtils.isNullOrEmpty((String)pluginName)) {
            try {
                Class<AWSCredentialsProvider> clazz = Class.forName(pluginName).asSubclass(AWSCredentialsProvider.class);
                AWSCredentialsProvider p = clazz.newInstance();
                if (p instanceof IPlugin) {
                    String key;
                    IPlugin plugin = (IPlugin)p;
                    plugin.setLogger(this.m_log);
                    Map prop = profile.getProperties();
                    for (Map.Entry entry : prop.entrySet()) {
                        key = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(key)) continue;
                        String value = (String)entry.getValue();
                        plugin.addParameter(key, value);
                        if (RedshiftProperty.DB_USER.getName().equalsIgnoreCase(key)) {
                            dbUser = value;
                            continue;
                        }
                        if (RedshiftProperty.DB_GROUPS.getName().equalsIgnoreCase(key)) {
                            dbGroups = value;
                            continue;
                        }
                        if (RedshiftProperty.FORCE_LOWERCASE.getName().equalsIgnoreCase(key)) {
                            forceLowercase = value;
                            continue;
                        }
                        if (!RedshiftProperty.USER_AUTOCREATE.getName().equalsIgnoreCase(key)) continue;
                        autoCreate = value;
                    }
                    for (Map.Entry<Object, Object> entry : this.m_settings.m_pluginArgs.entrySet()) {
                        key = ((String)entry.getKey()).toLowerCase(Locale.getDefault());
                        if ("plugin_name".equals(key)) continue;
                        plugin.addParameter((String)entry.getKey(), (String)entry.getValue());
                    }
                }
                credentials = CredentialsHolder.newInstance(p.getCredentials());
            }
            catch (InstantiationException e) {
                throw new SdkClientException("Invalid plugin: '" + pluginName + "'");
            }
            catch (IllegalAccessException e) {
                throw new SdkClientException("Invalid plugin: '" + pluginName + "'");
            }
            catch (ClassNotFoundException e) {
                throw new SdkClientException("Invalid plugin: '" + pluginName + "'");
            }
        } else {
            AWSCredentials c = new ProfileStaticCredentialsProvider(profile).getCredentials();
            credentials = CredentialsHolder.newInstance(c);
        }
        CredentialsHolder.IamMetadata metadata = credentials.getMetadata();
        if (null == metadata) {
            metadata = new CredentialsHolder.IamMetadata();
        }
        if (null != dbUser) {
            metadata.setProfileDbUser(dbUser);
        }
        if (null != autoCreate) {
            metadata.setAutoCreate(Boolean.valueOf(autoCreate));
        }
        if (null != dbGroups) {
            metadata.setDbGroups(dbGroups);
        }
        if (null != forceLowercase) {
            metadata.setForceLowercase(Boolean.valueOf(forceLowercase));
        }
        credentials.setMetadata(metadata);
        this.cache.put(profileName, credentials);
        return credentials;
    }

    private CredentialsHolder assumeRole(BasicProfile profile, AWSCredentialsProvider provider) {
        AWSSecurityTokenServiceClientBuilder builder = AWSSecurityTokenServiceClientBuilder.standard();
        if (!StringUtils.isNullOrEmpty((String)this.m_settings.m_awsRegion)) {
            builder.setRegion(this.m_settings.m_awsRegion);
        }
        AWSSecurityTokenService stsSvc = (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)builder.withCredentials(provider)).build();
        String roleArn = profile.getRoleArn();
        String roleSessionName = profile.getRoleSessionName();
        if (StringUtils.isNullOrEmpty((String)roleSessionName)) {
            roleSessionName = "redshift-jdbc-" + System.currentTimeMillis();
        }
        String externalId = profile.getRoleExternalId();
        AssumeRoleRequest assumeRoleRequest = new AssumeRoleRequest().withRoleArn(roleArn).withRoleSessionName(roleSessionName);
        if (!StringUtils.isNullOrEmpty((String)externalId)) {
            assumeRoleRequest = assumeRoleRequest.withExternalId(externalId);
        }
        AssumeRoleResult result = stsSvc.assumeRole(assumeRoleRequest);
        Credentials cred = result.getCredentials();
        Date expiration = cred.getExpiration();
        BasicSessionCredentials c = new BasicSessionCredentials(cred.getAccessKeyId(), cred.getSecretAccessKey(), cred.getSessionToken());
        return CredentialsHolder.newInstance((AWSCredentials)c, expiration);
    }
}

