/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc;

import io.trino.plugin.jdbc.JdbcIdentity;
import io.trino.plugin.jdbc.JdbcIdentityCacheMapping;
import io.trino.plugin.jdbc.credential.ExtraCredentialConfig;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public final class ExtraCredentialsBasedJdbcIdentityCacheMapping
implements JdbcIdentityCacheMapping {
    private final MessageDigest sha256;
    private final Optional<String> userCredentialName;
    private final Optional<String> passwordCredentialName;

    @Inject
    public ExtraCredentialsBasedJdbcIdentityCacheMapping(ExtraCredentialConfig config) {
        try {
            this.sha256 = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        Objects.requireNonNull(config, "config is null");
        this.userCredentialName = config.getUserCredentialName();
        this.passwordCredentialName = config.getPasswordCredentialName();
    }

    @Override
    public JdbcIdentityCacheMapping.JdbcIdentityCacheKey getRemoteUserCacheKey(JdbcIdentity identity) {
        Map<String, String> extraCredentials = identity.getExtraCredentials();
        return new ExtraCredentialsBasedJdbcIdentityCacheKey(this.userCredentialName.map(extraCredentials::get).map(this::hash), this.passwordCredentialName.map(extraCredentials::get).map(this::hash));
    }

    private byte[] hash(String value) {
        return this.sha256.digest(value.getBytes(StandardCharsets.UTF_8));
    }

    private static final class ExtraCredentialsBasedJdbcIdentityCacheKey
    extends JdbcIdentityCacheMapping.JdbcIdentityCacheKey {
        private static final byte[] EMPTY_BYTES = new byte[0];
        private final byte[] userHash;
        private final byte[] passwordHash;

        public ExtraCredentialsBasedJdbcIdentityCacheKey(Optional<byte[]> userHash, Optional<byte[]> passwordHash) {
            this.userHash = Objects.requireNonNull(userHash, "userHash is null").orElse(EMPTY_BYTES);
            this.passwordHash = Objects.requireNonNull(passwordHash, "passwordHash is null").orElse(EMPTY_BYTES);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExtraCredentialsBasedJdbcIdentityCacheKey that = (ExtraCredentialsBasedJdbcIdentityCacheKey)o;
            return Arrays.equals(this.userHash, that.userHash) && Arrays.equals(this.passwordHash, that.passwordHash);
        }

        @Override
        public int hashCode() {
            int result = Arrays.hashCode(this.userHash);
            result = 31 * result + Arrays.hashCode(this.passwordHash);
            return result;
        }
    }
}

